
FishTracker – Fish Classification Algorithm
========================================

This script classifies fish passage events using binary data collected by the FishTrack infrared beam-break sensor system. It detects individual passages, calculates direction, velocity, estimated length and width, filters out invalid events, and logs the results.

File to run: fish_clasification.py
---------------------------

Requirements
------------
- Python 3.7 or higher
- Required Python libraries:
  - pandas
  - matplotlib

Install dependencies with:
pip install pandas matplotlib

Local modules required (expected to be in the same or subfolder):
- process_events.py
- filter_events_new.py
- save_events.py
- plot_events.py
- charge_filepath.py

Input
-----
The script expects an input file located in the 'rawData/' directory.
This file should contain space-delimited binary values (1 = beam unbroken, 0 = beam broken) representing sensor status over time.

Example input file path inside the script (raw experiment data):
file_path = 'rawData/2023-07-28_01.txt'

How It Works
------------
1. Loads the IR sensor data from the specified text file.
2. Detects potential fish passage events by identifying patterns of consecutive beam interruptions.
3. Removes noise and invalid events using filtering rules.
4. Calculates:
   - Direction (based on entry and exit timing)
   - Velocity (based on time difference between arrays)
   - Length (from velocity and duration)
   - Width (based on number of vertical beams interrupted)
5. Logs results in a summary file.
6. Saves event-specific data in a separate folder.
7. Optionally, visualizes the silhouette of each fish passage event.

Outputs
-------
- event_log.txt: a summary file listing all classified events with key parameters
- classifiedEvents/: a folder containing individual event data files
- (Optional) Silhouette plots if visualization is enabled

Usage
-----
To run the script:
python fish_clasification.py

Make sure the target data file exists in the 'rawData/' folder before running.