#ifndef UTIL_H_
#define UTIL_H_

#include <cassert>
#include <cerrno>
#include <cstring>
#include <fstream>
#include <optional>
#include <sstream>
#include <stdexcept>
#include <string>

#include "log.h"

#define LOG_AND_THROW_ERROR(MSG, T)                                   \
  do {                                                                \
    LOG(error) << MSG << " (errno: " << std::strerror(errno) << ")."; \
    throw T(MSG);                                                     \
  } while (false)

#define UNREACHABLE          \
  do {                       \
    assert(false);           \
    __builtin_unreachable(); \
  } while (false)

static inline std::optional<std::string> read_file(const char *p_filename) {
  std::ifstream in_f{p_filename};

  if (!in_f.is_open()) {
    LOG_AND_THROW_ERROR("Could not open file.", std::runtime_error);
    return {};
  }

  std::stringstream buf;
  buf << in_f.rdbuf();

  return buf.str();
}

static inline std::string string_of_string_option(
    const std::optional<std::string> value) {
  if (value) {
    return *value;
  } else {
    return "(( None ))";
  }
}

#endif  // UTIL_H_
