#include <gtest/gtest.h>

#include <chrono>
#include <cstdlib>
#include <cstring>
#include <memory>
#include <thread>

#include "test_common.h"
#include "tls.h"
#include "transport_iface.h"

TEST(tls, simple_connection) {
  TLS12Client client{tls_test_context(), TLSVersion::k1_2};
  TLS12Server server{tls_test_context(), TLSVersion::k1_2};

  {
    auto init_success = client.try_init();
    ASSERT_TRUE(init_success);
  }

  {
    auto init_success = server.try_init();
    ASSERT_TRUE(init_success);
  }

  run_simple_communication_test(&client, &server);
}
