#include <gtest/gtest.h>

#include <chrono>
#include <cstdlib>
#include <cstring>
#include <memory>
#include <thread>
#include <utility>

#include "ssh.h"
#include "test_common.h"
#include "transport_iface.h"

TEST(ssh, simple_connection) {
  SSHClient client{ssh_test_context()};
  SSHServer server{ssh_test_context()};

  {
    auto init_success = client.try_init();
    ASSERT_TRUE(init_success);
  }

  {
    auto init_success = server.try_init();
    ASSERT_TRUE(init_success);
  }

  run_simple_communication_test(&client, &server);
}
