#include <gtest/gtest.h>

#include <chrono>
#include <thread>

#include "rs.h"
#include "test_common.h"

static void run_client_(RSKind rs_kind) {
  RSClient client{rs_test_context(), rs_kind};
  client.try_init();

  client.connect();
  client.send(100);
  client.recv(100);
}

static void run_server_(RSKind rs_kind) {
  RSServer server{rs_test_context(), rs_kind};
  server.try_init();

  server.listen();
  server.accept();
  server.send(100);
  server.recv(100);
}

TEST(rs, snow) {
  std::thread server{run_server_, RSKind::kSnow};
  std::this_thread::sleep_for(std::chrono::milliseconds(200));
  std::thread client{run_client_, RSKind::kSnow};

  client.join();
  server.join();
}

TEST(rs, secio) {
  std::thread server{run_server_, RSKind::kSecio};
  std::this_thread::sleep_for(std::chrono::milliseconds(200));
  std::thread client{run_client_, RSKind::kSecio};

  client.join();
  server.join();
}
