#include <gtest/gtest.h>

#include "etgen_rs.h"
#include "log.h"
#include "tls.h"

int main(int argc, char **argv) {
  ::testing::InitGoogleTest(&argc, argv);

#ifdef DEBUG
  log_init("trace");
  ffi_log_init(4);
#else
  log_init("info");
  ffi_log_init(2);
#endif  // DEBUG

  tls_global_init();

  return RUN_ALL_TESTS();
}
