#include <gtest/gtest.h>

#include <chrono>
#include <thread>

#include "curvezmq.h"
#include "test_common.h"

static void aux_() {
  CurveZMQServer server{curvezmq_test_context()};
  server.try_init();
  server.listen();
  server.accept();

  server.send(100);

  std::this_thread::sleep_for(std::chrono::seconds(1));
}

TEST(curvezmq, foo) {
  void *server_task(void *args);

  std::thread x{aux_};

  CurveZMQClient client{curvezmq_test_context()};

  client.try_init();
  client.connect();
  client.recv(100);

  x.join();
}

TEST(curvezmq, server) {
}
