#ifndef TEST_COMMON_H_
#define TEST_COMMON_H_

#include <cassert>
#include <condition_variable>
#include <memory>
#include <mutex>
#include <thread>

#include "transport_iface.h"

std::shared_ptr<const ConnectionContext> ssh_test_context();
std::shared_ptr<const ConnectionContext> tls_test_context();
std::shared_ptr<const ConnectionContext> curvezmq_test_context();
std::shared_ptr<const ConnectionContext> rs_test_context();

static inline void run_simple_communication_test(ClientIFace *p_client,
                                                 ServerIFace *p_server) {
  assert(p_client && p_server);

  std::mutex mtx{};
  std::condition_variable cv{};
  bool ready{false};

  auto run_client = [&mtx, &cv, &ready, p_client] {
    std::unique_lock lk{mtx};
    cv.wait(lk, [&ready] { return ready; });

    p_client->connect();
    p_client->send(1);
    p_client->recv(1);

    p_client->cleanup();
  };

  auto run_server = [&mtx, &cv, &ready, p_server] {
    p_server->listen();

    {
      std::lock_guard lk{mtx};
      ready = true;
    }
    cv.notify_one();

    p_server->accept();

    p_server->recv(1);
    p_server->send(1);

    p_server->cleanup();
  };

  std::thread client_thread{run_client};
  std::thread server_thread{run_server};

  client_thread.join();
  server_thread.join();
}

#endif  // TEST_COMMON_H_
