#include "test_common.h"

static std::shared_ptr<const ConnectionContext> ssh_test_context_{new ConnectionContext{
      .client_hostname = "localhost",
      .server_hostname = "localhost",
      .client_port = 2222,
      .server_port = 2223,
      .ssh_server_pubkey =
          "/home/rwails/prj/upgen/encrypted_tgen/resource/ssh/server.rsa.pub",
      .ssh_server_privkey =
          "/home/rwails/prj/upgen/encrypted_tgen/resource/ssh/server.rsa",
      .tls_server_key = std::nullopt,
      .tls_server_cert = std::nullopt,
      .snow_noise_params = std::nullopt,
}};

static std::shared_ptr<const ConnectionContext> tls_test_context_{new ConnectionContext{
    .client_hostname = "localhost",
    .server_hostname = "localhost",
    .client_port = 2225,
    .server_port = 2224,
    .ssh_server_pubkey = std::nullopt,
    .ssh_server_privkey = std::nullopt,
    .tls_server_key =
        "/home/rwails/prj/upgen/encrypted_tgen/resource/tls/key.pem",
    .tls_server_cert =
        "/home/rwails/prj/upgen/encrypted_tgen/resource/tls/cert.pem",
    .snow_noise_params = std::nullopt,
}};

static std::shared_ptr<const ConnectionContext> curvezmq_test_context_{new ConnectionContext{
    .client_hostname = "localhost",
    .server_hostname = "localhost",
    .client_port = 3000,
    .server_port = 3001,
    .ssh_server_pubkey = std::nullopt,
    .ssh_server_privkey = std::nullopt,
    .tls_server_key = std::nullopt,
    .tls_server_cert = std::nullopt,
    .curvezmq_client_cert = "/home/rwails/prj/upgen/encrypted_tgen/resource/curvezmq/client_cert.txt_secret",
    .curvezmq_server_cert = "/home/rwails/prj/upgen/encrypted_tgen/resource/curvezmq/server_cert.txt_secret",
    .snow_noise_params = std::nullopt,
}};

static std::shared_ptr<const ConnectionContext> rs_test_context_{new ConnectionContext{
    .client_hostname = "localhost",
    .server_hostname = "localhost",
    .client_port = 3010,
    .server_port = 3011,
    .ssh_server_pubkey = std::nullopt,
    .ssh_server_privkey = std::nullopt,
    .tls_server_key = std::nullopt,
    .tls_server_cert = std::nullopt,
    .snow_noise_params = "Noise_XXpsk3_25519_ChaChaPoly_BLAKE2s",
}};

std::shared_ptr<const ConnectionContext> ssh_test_context() {
  return ssh_test_context_;
}

std::shared_ptr<const ConnectionContext> tls_test_context() {
  return tls_test_context_;
}

std::shared_ptr<const ConnectionContext> curvezmq_test_context() {
  return curvezmq_test_context_;
}

std::shared_ptr<const ConnectionContext> rs_test_context() {
  return rs_test_context_;
}
