#ifndef SSH_H_
#define SSH_H_

#include <cassert>
#include <memory>

#include "macro.h"
#include "transport_iface.h"

class SSHClient : public ClientIFace {
 public:
  SSHClient(std::shared_ptr<const ConnectionContext> conn_ctx);
  virtual ~SSHClient();

  void cleanup() override;
  bool try_init() override;
  void connect() override;
  void recv(std::size_t nbytes) override;
  void send(std::size_t nbytes) override;

  DISALLOW_COPY_AND_ASSIGN(SSHClient);

 private:
  struct SSHClientInternals;

  enum State { kUninit, kInit, kDead, kInvalid, kConnected };

  inline SSHClientInternals& internal() {
    assert(internal_);
    return *this->internal_;
  }

  std::unique_ptr<SSHClientInternals> internal_{nullptr};
  State state_;
};

class SSHServer : public ServerIFace {
 public:
  SSHServer(std::shared_ptr<const ConnectionContext> conn_ctx);
  virtual ~SSHServer();

  void cleanup() override;
  bool try_init() override;
  void listen() override;
  void accept() override;
  void recv(std::size_t nbytes) override;
  void send(std::size_t nbytes) override;

  DISALLOW_COPY_AND_ASSIGN(SSHServer);

 private:
  struct SSHServerInternals;

  enum State { kUninit, kInit, kDead, kInvalid, kListening };

  inline SSHServerInternals& internal() {
    assert(internal_);
    return *this->internal_;
  }

  std::unique_ptr<SSHServerInternals> internal_{nullptr};
  State state_;
};

#endif // SSH_H_
