#ifndef RS_H_
#define RS_H_
#include <cassert>

#include "macro.h"
#include "transport_iface.h"

enum class RSKind {
  kSnow,
  kSecio,
};

class RSClient : public ClientIFace {
 public:
  RSClient(std::shared_ptr<const ConnectionContext> conn_ctx, RSKind rs_kind);
  virtual ~RSClient();

  void cleanup() override;
  bool try_init() override;
  void connect() override;
  void recv(std::size_t nbytes) override;
  void send(std::size_t nbytes) override;

  DISALLOW_COPY_AND_ASSIGN(RSClient);

 private:
  struct Internal;

  inline Internal& internal() {
    assert(internal_);
    return *this->internal_;
  }

  std::unique_ptr<Internal> internal_{nullptr};
};

class RSServer : public ServerIFace {
 public:
  RSServer(std::shared_ptr<const ConnectionContext> conn_ctx, RSKind rs_kind);
  virtual ~RSServer();

  void cleanup() override;
  bool try_init() override;
  void listen() override;
  void accept() override;
  void recv(std::size_t nbytes) override;
  void send(std::size_t nbytes) override;

  DISALLOW_COPY_AND_ASSIGN(RSServer);

 private:
  struct Internal;

  inline Internal& internal() {
    assert(internal_);
    return *this->internal_;
  }

  std::unique_ptr<Internal> internal_{nullptr};
};

#endif  // RS_H_
