#ifndef LOG_H_
#define LOG_H_

#include <boost/log/core.hpp>
#include <boost/log/expressions.hpp>
#include <boost/log/trivial.hpp>
#include <boost/log/utility/setup/common_attributes.hpp>
#include <boost/log/utility/setup/console.hpp>
#include <cstdio>
#include <string>

static inline void log_init(const std::string &level) {
  boost::log::add_console_log(
      std::cerr,
      boost::log::keywords::format = "[%TimeStamp%] [%Severity%] %Message%");

  auto typed_level = boost::log::trivial::fatal;

  if (level == "trace") {
    typed_level = boost::log::trivial::trace;
  } else if (level == "debug") {
    typed_level = boost::log::trivial::debug;
  } else if (level == "info") {
    typed_level = boost::log::trivial::info;
  } else if (level == "warning") {
    typed_level = boost::log::trivial::warning;
  } else if (level == "error") {
    typed_level = boost::log::trivial::error;
  } else {
    assert(level == "fatal");
    typed_level = boost::log::trivial::fatal;
  }

  boost::log::core::get()->set_filter(boost::log::trivial::severity >=
                                      typed_level);

  boost::log::add_common_attributes();
}

#define LOG(SEVERITY) \
  BOOST_LOG_TRIVIAL(SEVERITY) << "[" << __FILE__ << ":" << __LINE__ << "] "

#endif  // LOG_H_
