#include <boost/program_options.hpp>
#include <cstdint>
#include <cstdio>
#include <cstdlib>
#include <iostream>
#include <iosfwd>
#include <string>

#include "log.h"

struct ProgramOptions {
  std::string forward_hostname;
  std::uint16_t forward_port, listen_port;
};

struct ServerOptions {
  std::string forward_hostname;
  std::uint8_t forward_port;
};

ProgramOptions program_options_of_args_ext(int argc, const char **argv) {
  namespace po = boost::program_options;
  po::options_description desc("Allowed options");
  desc.add_options()("help", "produce help message")(
      "compression", po::value<int>(), "set compression level");

  po::variables_map vm;
  po::store(po::parse_command_line(argc, argv, desc), vm);
  po::notify(vm);

  if (vm.count("help")) {
    std::cout << desc << "\n";
    std::exit(EXIT_FAILURE);
  }

  return ProgramOptions{};
}

int main(int argc, char **argv) {
  log_init("info");
  LOG(info) << "hello world!";

  return 0;
}
