#ifndef DRIVER_RESPONDER_H_
#define DRIVER_RESPONDER_H_

#include <cassert>
#include <cstdint>
#include <memory>
#include <optional>
#include <variant>

#include "macro.h"
#include "transport_iface.h"

class Transcript;

class DriverResponder {
 public:
  DriverResponder(
      std::variant<std::unique_ptr<ClientIFace>, std::unique_ptr<ServerIFace>>
          endpoint_iface,
      std::uint16_t port);
  ~DriverResponder();

  bool init();

  void work_loop();

  DISALLOW_COPY_AND_ASSIGN(DriverResponder);

 private:
  struct DriverResponderInternals;

  inline DriverResponderInternals& internal() {
    assert(internal_);
    return *this->internal_;
  }

  inline bool client_role() { return client_.has_value(); }

  inline bool server_role() { return server_.has_value(); }

  void execute_transcript(const Transcript &transcript);

  std::unique_ptr<DriverResponderInternals> internal_;
  std::optional<std::unique_ptr<ClientIFace>> client_;
  std::optional<std::unique_ptr<ServerIFace>> server_;
  std::uint16_t port_;
};

#endif  // DRIVER_RESPONDER_H_
