#ifndef DRIVER_REQUESTER_H_
#define DRIVER_REQUESTER_H_

#include <cassert>
#include <cstdint>
#include <memory>
#include <string>

#include "common.h"
#include "driver_common.h"
#include "macro.h"
#include "transport_iface.h"

class DriverRequester {
 public:

  DriverRequester(std::string client_addr, std::uint16_t client_port,
                  std::string server_addr, std::uint16_t server_port);

  ~DriverRequester();

  bool init();

  void send_message(const Command &req, Endpoint ep);

  DISALLOW_COPY_AND_ASSIGN(DriverRequester);

 private:
  struct DriverRequesterInternals;

  inline DriverRequesterInternals& internal() {
    assert(internal_);
    return *this->internal_;
  }

  std::unique_ptr<DriverRequesterInternals> internal_;
  std::string client_addr_, server_addr_;
  std::uint16_t client_port_, server_port_;
};

#endif  // DRIVER_REQUESTER_H_
