#ifndef DRIVER_COMMON_H_
#define DRIVER_COMMON_H_

#include <cassert>
#include <cstddef>
#include <iosfwd>
#include <memory>
#include <optional>
#include <string>

#include "command.pb.h"

namespace zmq {
class message_t;
class socket_t;
}  // namespace zmq

class Transcript;

std::ostream &operator<<(std::ostream &stream, const Command &cmd);

void zmq_message_of_command(const Command &cmd, zmq::message_t *p_out);
std::unique_ptr<Command> command_of_zmq_message(const zmq::message_t &zmsg);

void send_command_synch(const Command &cmd, zmq::socket_t *sock);
std::unique_ptr<Command> recv_command_synch(zmq::socket_t *sock);

std::optional<std::unique_ptr<Transcript>> transcript_of_json(
    const char *p_str);

std::optional<std::string> json_of_transcript(const Transcript &transcript);

static inline Command make_no_data_command(Command::Kind kind) {
  Command cmd{};
  cmd.set_kind(kind);
  return cmd;
}

static inline Command make_ack_command(Command::Kind kind) {
  Command cmd{};
  cmd.set_kind(Command::Kind::Command_Kind_ACK);
  cmd.set_ack(kind);
  return cmd;
}

static inline Command make_data_command(Command::Kind kind,
                                        std::size_t nbytes) {
  assert(kind == Command::Kind::Command_Kind_SEND ||
         kind == Command::Kind::Command_Kind_RECV);

  Command cmd{};
  cmd.set_kind(kind);
  cmd.set_nbytes(nbytes);
  return cmd;
}

static inline Command make_transcript_command(const Transcript &transcript) {
  Command cmd{};
  cmd.set_kind(Command::Kind::Command_Kind_TRANSCRIPT);
  auto *dst = cmd.mutable_transcript();
  *dst = transcript;
  return cmd;
}

#endif  // DRIVER_COMMON_H_
