#ifndef CURVEZMQ_H_
#define CURVEZMQ_H_

#include <cassert>
#include <memory>

#include "macro.h"
#include "transport_iface.h"

class CurveZMQClient : public ClientIFace {
 public:
  CurveZMQClient(std::shared_ptr<const ConnectionContext> conn_ctx);
  virtual ~CurveZMQClient();
  DISALLOW_COPY_AND_ASSIGN(CurveZMQClient);

  virtual void cleanup() override;
  virtual bool try_init() override;
  virtual void connect() override;
  virtual void recv(std::size_t nbytes) override;
  virtual void send(std::size_t nbytes) override;

 private:

  struct CurveZMQClientInternals;

  inline CurveZMQClientInternals& internal() {
    assert(internal_);
    return *this->internal_;
  }

  std::unique_ptr<CurveZMQClientInternals> internal_{nullptr};
};

class CurveZMQServer : public ServerIFace {
 public:
  CurveZMQServer(std::shared_ptr<const ConnectionContext> conn_ctx);
  virtual ~CurveZMQServer();
  DISALLOW_COPY_AND_ASSIGN(CurveZMQServer);

  virtual void cleanup() override;
  virtual bool try_init() override;
  virtual void listen() override;
  virtual void accept() override;
  virtual void recv(std::size_t nbytes) override;
  virtual void send(std::size_t nbytes) override;

 private:

  struct CurveZMQServerInternals;

  inline CurveZMQServerInternals& internal() {
    assert(internal_);
    return *this->internal_;
  }

  std::unique_ptr<CurveZMQServerInternals> internal_{nullptr};
};

#endif  // CURVEZMQ_H_
