{ pkgs ? import <nixpkgs> {} }:

(pkgs.mkShell.override { stdenv = pkgs.gcc13Stdenv; }) {
  nativeBuildInputs = [
    pkgs.gettext
    pkgs.libtool
    pkgs.pkg-config
  ];

  shellHook = ''
    export PREFIX_DIR=$(readlink -f deps/prefix)
    export C_INCLUDE_PATH="$PREFIX_DIR/include:$C_INCLUDE_PATH"
    export CPLUS_INCLUDE_PATH="$PREFIX_DIR/include:$CPLUS_INCLUDE_PATH"
    export LIBRARY_PATH="$PREFIX_DIR/lib:$LIBRARY_PATH"
    export LD_LIBRARY_PATH="$PREFIX_DIR/lib:$LD_LIBRARY_PATH"
    export PKG_CONFIG_PATH="$PREFIX_DIR/lib/pkgconfig:$PKG_CONFIG_PATH"
    export PATH="$PREFIX_DIR/bin:$PATH"
    export CFLAGS='-Wno-deprecated -Wno-deprecated-declarations -Wno-format-truncation -Wno-stringop-truncation -Wno-error'
  '';
}
