{ pkgs ? import <nixpkgs> {} }:

(pkgs.mkShell.override { stdenv = pkgs.gcc13Stdenv; }) {
  buildInputs = [
    pkgs.boost
    pkgs.leveldb
  ];

  nativeBuildInputs = [
    pkgs.cmake
    pkgs.ninja
    pkgs.pkg-config
  ];

  shellHook = ''
    export CFLAGS='-Wno-error=range-loop-construct -Wno-deprecated -Wno-deprecated-declarations -Wno-format-truncation -Wno-stringop-truncation -Wno-error'
    export CPPFLAGS='-Wno-error=range-loop-construct -Wno-deprecated -Wno-deprecated-declarations -Wno-format-truncation -Wno-stringop-truncation -Wno-error'
    export CXXFLAGS='-Wno-error=range-loop-construct -Wno-deprecated -Wno-deprecated-declarations -Wno-format-truncation -Wno-stringop-truncation -Wno-error'
  '';
}
