#!/usr/bin/env bash

set -eou pipefail

if [ "$#" != 2 ]; then
    >&2 echo "Error: incorrect arguments provided. Usage: $0 INTERFACE MTU"
    exit -1
fi

set -x

# Default MTU is 65536 on loopback.
# Typical MTU is 1500 for a physical ethernet device

ifconfig $1 mtu $2 up
