#!/usr/bin/env bash

set -eou pipefail

set -x

PREFIX=$(readlink -f deps/build/libzmq)
RPATH=$(readlink -f deps/prefix/lib)

git clone --depth 1 --branch v4.3.5 \
  https://github.com/zeromq/libzmq.git deps/src/libzmq

cd deps/src/libzmq && mkdir build && cd build && cmake -G Ninja \
  -DWITH_LIBSODIUM=ON -DENABLE_CURVE=ON -DCMAKE_INSTALL_PREFIX=$PREFIX \
  -DCMAKE_CXX_FLAGS="-Wl,-rpath=$RPATH" \
  ..

ninja && ninja install

cd ../../.. && cd build && stow -t ../prefix libzmq
