#!/usr/bin/env bash

set -eou pipefail

set -x

UNAME=$(uname)

if [ "$UNAME" == "Darwin" ];
then
PREFIX=$(realpath deps/build/etgen_rs)
fi

if [ "$UNAME" == "Linux" ];
then
PREFIX=$(readlink -f deps/build/etgen_rs)
fi

cd etgen-rs && make install PREFIX=$PREFIX
cd - && cd deps/build && stow -t ../prefix etgen_rs
