#!/usr/bin/env bash

set -eou pipefail

set -x

PREFIX=$(readlink -f deps/build/czmq)
RPATH=$(readlink -f deps/prefix/lib)

git clone --depth 1 --branch v3.0.2 \
  https://github.com/zeromq/czmq.git deps/src/czmq

cd deps/src/czmq && \
  ./autogen.sh && \
  ./configure LDFLAGS=-Wl,-rpath=$RPATH --prefix=$PREFIX \
  && make -j && make install

cd - && cd deps/build && stow -t ../prefix czmq
