#!/usr/bin/env bash

set -eou pipefail

set -x

PREFIX=$(readlink -f deps/build/libcurve)
RPATH=$(readlink -f deps/prefix/lib)

git clone --depth 1 https://github.com/zeromq/libcurve.git \
  deps/src/libcurve

cd deps/src/libcurve && sh autogen.sh && \
  ./configure LDFLAGS=-Wl,-rpath=$RPATH --prefix=$PREFIX && \
  make -j && make install

cd - && cd deps/build && stow -t ../prefix libcurve
