pub trait ClientIFace {
    fn try_init(&mut self) -> bool;
    fn connect(&mut self);
    fn recv(&mut self, nbytes: usize);
    fn send(&mut self, nbytes: usize);
    fn cleanup(&mut self);
}

pub trait ServerIFace {
    fn try_init(&mut self) -> bool;
    fn listen(&mut self);
    fn accept(&mut self);
    fn recv(&mut self, nbytes: usize);
    fn send(&mut self, nbytes: usize);
    fn cleanup(&mut self);
}

#[derive(Clone)]
pub struct Config {
    pub client_hostname: String,
    pub server_hostname: String,
    pub client_port: u16,
    pub server_port: u16,
    pub snow_noise_params: Option<String>,
}
