#[repr(C)]
pub struct ConfigRS {
    client_hostname: *const core::ffi::c_char,
    server_hostname: *const core::ffi::c_char,
    client_port: u16,
    server_port: u16,
    snow_noise_params: *const core::ffi::c_char,
}

impl ConfigRS {
    pub fn into_config(self) -> crate::interface::Config {
        let client_hostname = String::from(unsafe {
            core::ffi::CStr::from_ptr(self.client_hostname)
                .to_str()
                .unwrap()
        });

        let server_hostname = String::from(unsafe {
            core::ffi::CStr::from_ptr(self.server_hostname)
                .to_str()
                .unwrap()
        });

        let snow_noise_params = if self.snow_noise_params.is_null() {
            None
        } else {
            Some(unsafe {
                core::ffi::CStr::from_ptr(self.snow_noise_params)
                    .to_str()
                    .unwrap()
                    .to_string()
            })
        };

        crate::interface::Config {
            client_hostname,
            server_hostname,
            client_port: self.client_port,
            server_port: self.server_port,
            snow_noise_params,
        }
    }
}

pub struct ClientInterfaceFFI {
    pub p_this: *mut core::ffi::c_void, // Place to hold the pointer to the uncasted version
    pub try_init: fn(p_this: *mut core::ffi::c_void) -> bool,
    pub free: fn(p_this: *mut core::ffi::c_void),
    pub connect: fn(p_this: *mut core::ffi::c_void),
    pub send: fn(p_this: *mut core::ffi::c_void, nbytes: usize),
    pub recv: fn(p_this: *mut core::ffi::c_void, nbytes: usize),
    pub cleanup: fn(p_this: *mut core::ffi::c_void),
}

pub struct ServerInterfaceFFI {
    pub p_this: *mut core::ffi::c_void, // Place to hold the pointer to the uncasted version
    pub try_init: fn(p_this: *mut core::ffi::c_void) -> bool,
    pub free: fn(p_this: *mut core::ffi::c_void),
    pub listen: fn(p_this: *mut core::ffi::c_void),
    pub accept: fn(p_this: *mut core::ffi::c_void),
    pub send: fn(p_this: *mut core::ffi::c_void, nbytes: usize),
    pub recv: fn(p_this: *mut core::ffi::c_void, nbytes: usize),
    pub cleanup: fn(p_this: *mut core::ffi::c_void),
}

#[no_mangle]
pub extern "C" fn ffi_log_init(verbosity: usize) {
    stderrlog::new()
        .verbosity(verbosity)
        .timestamp(stderrlog::Timestamp::Second)
        .init()
        .unwrap();
    log::info!("Rust logging initialized.");
}

// Snow ////////////////////////////////////////////////////////////////////////

#[no_mangle]
pub extern "C" fn snow_client_create(config: ConfigRS) -> *mut core::ffi::c_void {
    Box::into_raw(Box::new(
        crate::snow::SnowClient::new(config.into_config()).into_interface_ffi(),
    )) as *mut core::ffi::c_void
}

#[no_mangle]
pub extern "C" fn snow_client_destroy(p_ffi: *mut core::ffi::c_void) {
    let ffi = unsafe { &mut *(p_ffi as *mut ClientInterfaceFFI) };
    (ffi.free)(ffi.p_this);
    let boxed = unsafe { Box::from_raw(p_ffi as *mut ClientInterfaceFFI) };
    drop(boxed);
}

#[no_mangle]
pub extern "C" fn snow_server_create(config: ConfigRS) -> *mut core::ffi::c_void {
    Box::into_raw(Box::new(
        crate::snow::SnowServer::new(config.into_config()).into_interface_ffi(),
    )) as *mut core::ffi::c_void
}

#[no_mangle]
pub extern "C" fn snow_server_destroy(p_ffi: *mut core::ffi::c_void) {
    let ffi = unsafe { &mut *(p_ffi as *mut ServerInterfaceFFI) };
    (ffi.free)(ffi.p_this);
    let boxed = unsafe { Box::from_raw(p_ffi as *mut ServerInterfaceFFI) };
    drop(boxed);
}

// Secio ///////////////////////////////////////////////////////////////////////

#[no_mangle]
pub extern "C" fn secio_client_create(config: ConfigRS) -> *mut core::ffi::c_void {
    Box::into_raw(Box::new(
        crate::secio::SecioClient::new(config.into_config()).into_interface_ffi(),
    )) as *mut core::ffi::c_void
}

#[no_mangle]
pub extern "C" fn secio_client_destroy(p_ffi: *mut core::ffi::c_void) {
    let ffi = unsafe { &mut *(p_ffi as *mut ClientInterfaceFFI) };
    (ffi.free)(ffi.p_this);
    let boxed = unsafe { Box::from_raw(p_ffi as *mut ClientInterfaceFFI) };
    drop(boxed);
}

#[no_mangle]
pub extern "C" fn secio_server_create(config: ConfigRS) -> *mut core::ffi::c_void {
    Box::into_raw(Box::new(
        crate::secio::SecioServer::new(config.into_config()).into_interface_ffi(),
    )) as *mut core::ffi::c_void
}

#[no_mangle]
pub extern "C" fn secio_server_destroy(p_ffi: *mut core::ffi::c_void) {
    let ffi = unsafe { &mut *(p_ffi as *mut ServerInterfaceFFI) };
    (ffi.free)(ffi.p_this);
    let boxed = unsafe { Box::from_raw(p_ffi as *mut ServerInterfaceFFI) };
    drop(boxed);
}

// Client //////////////////////////////////////////////////////////////////////

#[no_mangle]
pub extern "C" fn rs_client_init(p_ffi: *mut core::ffi::c_void) -> bool {
    let ffi = unsafe { &mut *(p_ffi as *mut ClientInterfaceFFI) };
    (ffi.try_init)(ffi.p_this)
}

#[no_mangle]
pub extern "C" fn rs_client_connect(p_ffi: *mut core::ffi::c_void) {
    let ffi = unsafe { &mut *(p_ffi as *mut ClientInterfaceFFI) };
    (ffi.connect)(ffi.p_this);
}

#[no_mangle]
pub extern "C" fn rs_client_send(p_ffi: *mut core::ffi::c_void, nbytes: usize) {
    let ffi = unsafe { &mut *(p_ffi as *mut ClientInterfaceFFI) };
    (ffi.send)(ffi.p_this, nbytes);
}

#[no_mangle]
pub extern "C" fn rs_client_recv(p_ffi: *mut core::ffi::c_void, nbytes: usize) {
    let ffi = unsafe { &mut *(p_ffi as *mut ClientInterfaceFFI) };
    (ffi.recv)(ffi.p_this, nbytes);
}

#[no_mangle]
pub extern "C" fn rs_client_cleanup(p_ffi: *mut core::ffi::c_void) {
    let ffi = unsafe { &mut *(p_ffi as *mut ClientInterfaceFFI) };
    (ffi.cleanup)(ffi.p_this);
}

// Server //////////////////////////////////////////////////////////////////////

#[no_mangle]
pub extern "C" fn rs_server_init(p_ffi: *mut core::ffi::c_void) -> bool {
    let ffi = unsafe { &mut *(p_ffi as *mut ServerInterfaceFFI) };
    (ffi.try_init)(ffi.p_this)
}

#[no_mangle]
pub extern "C" fn rs_server_listen(p_ffi: *mut core::ffi::c_void) {
    let ffi = unsafe { &mut *(p_ffi as *mut ServerInterfaceFFI) };
    (ffi.listen)(ffi.p_this);
}

#[no_mangle]
pub extern "C" fn rs_server_accept(p_ffi: *mut core::ffi::c_void) {
    let ffi = unsafe { &mut *(p_ffi as *mut ServerInterfaceFFI) };
    (ffi.accept)(ffi.p_this);
}

#[no_mangle]
pub extern "C" fn rs_server_send(p_ffi: *mut core::ffi::c_void, nbytes: usize) {
    let ffi = unsafe { &mut *(p_ffi as *mut ServerInterfaceFFI) };
    (ffi.send)(ffi.p_this, nbytes);
}

#[no_mangle]
pub extern "C" fn rs_server_recv(p_ffi: *mut core::ffi::c_void, nbytes: usize) {
    let ffi = unsafe { &mut *(p_ffi as *mut ServerInterfaceFFI) };
    (ffi.recv)(ffi.p_this, nbytes);
}

#[no_mangle]
pub extern "C" fn rs_server_cleanup(p_ffi: *mut core::ffi::c_void) {
    let ffi = unsafe { &mut *(p_ffi as *mut ServerInterfaceFFI) };
    (ffi.cleanup)(ffi.p_this);
}
