% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_classification_as_factor.R
\name{add_effect_classification}
\alias{add_effect_classification}
\title{Add effect classifications to a dataframe by comparing the confidence
intervals with a reference and thresholds}
\usage{
add_effect_classification(
  df,
  cl_columns,
  threshold,
  reference = 0,
  coarse = TRUE
)
}
\arguments{
\item{df}{A dataframe containing summary data of confidence limits. Two
columns are required containing lower and upper limits indicated by the
\code{cl_columns} argument. Any other columns are optional.}

\item{cl_columns}{A vector of 2 column names in \code{df} indicating respectively
the lower and upper confidence limits (e.g. \code{c("lcl", "ucl")}).}

\item{threshold}{A vector of either 1 or 2 thresholds. A single threshold
will be transformed into \code{reference + c(-abs(threshold), abs(threshold))}.}

\item{reference}{The null hypothesis value to compare confidence intervals
against. Defaults to 0.}

\item{coarse}{Logical, defaults to \code{TRUE}. If \code{TRUE}, add a coarse
classification to the dataframe.}
}
\value{
The returned value is a modified version of the original input
dataframe \code{df} with additional columns \code{effect_code} and \code{effect} containing
respectively the effect symbols and descriptions as ordered factor variables.
In case of \code{coarse = TRUE} (by default) also \code{effect_code_coarse} and
\code{effect_coarse} containing the coarse classification effects.
}
\description{
This function adds classified effects to a dataframe as ordered factor
variables by comparing the confidence intervals with a reference and
thresholds.
}
\details{
This function is a wrapper around \code{effectclass::classify()} and
\code{effectclass::coarse_classification()} from the \pkg{effectclass} package
(Onkelinx, 2023). They classify effects in a stable and transparent manner.\tabular{clll}{
   Symbol \tab Fine effect / trend \tab Coarse effect / trend \tab Rule \cr
   \verb{++} \tab strong positive effect / strong increase \tab positive effect / increase \tab confidence interval above the upper threshold \cr
   \code{+} \tab positive effect / increase \tab positive effect / increase \tab confidence interval above reference and contains the upper threshold \cr
   \verb{+~} \tab moderate positive effect / moderate increase \tab positive effect / increase \tab confidence interval between reference and the upper threshold \cr
   \code{~} \tab no effect / stable \tab no effect / stable \tab confidence interval between thresholds and contains reference \cr
   \verb{-~} \tab moderate negative effect / moderate decrease \tab negative effect / decrease \tab confidence interval between reference and the lower threshold \cr
   \code{-} \tab negative effect / decrease \tab negative effect / decrease \tab confidence interval below reference and contains the lower threshold \cr
   \verb{--} \tab strong negative effect / strong decrease \tab negative effect / decrease \tab confidence interval below the lower threshold \cr
   \verb{?+} \tab potential positive effect / potential increase \tab unknown effect / unknown \tab confidence interval contains reference and the upper threshold \cr
   \verb{?-} \tab potential negative effect / potential decrease \tab unknown effect / unknown \tab confidence interval contains reference and the lower threshold \cr
   \verb{?} \tab unknown effect / unknown \tab unknown effect / unknown \tab confidence interval contains the lower and upper threshold \cr
}
}
\examples{
# Example dataset
ds <- data.frame(
  mean = c(0, 0.5, -0.5, 1, -1, 1.5, -1.5, 0.5, -0.5, 0),
  sd = c(1, 0.5, 0.5, 0.5, 0.5, 0.25, 0.25, 0.25, 0.25, 0.5)
)
ds$lcl <- qnorm(0.05, ds$mean, ds$sd)
ds$ucl <- qnorm(0.95, ds$mean, ds$sd)

add_effect_classification(
 df = ds,
 cl_columns = c("lcl", "ucl"),
 threshold = 1,
 reference = 0,
 coarse = TRUE
)
}
\references{
Onkelinx, T. (2023). effectclass: Classification and visualisation of effects
[Computer software]. \url{https://inbo.github.io/effectclass/}
}
\seealso{
Other indicator_uncertainty: 
\code{\link{bootstrap_cube}()},
\code{\link{calculate_acceleration}()},
\code{\link{calculate_bootstrap_ci}()}
}
\concept{indicator_uncertainty}
