
<!-- README.md is generated from README.Rmd. Please edit that file -->

# dubicube <a href="https://b-cubed-eu.github.io/dubicube/"><img src="man/figures/logo.png" align="right" height="139" alt="dubicube website" /></a>

<!-- badges: start -->

[![repo
status](https://www.repostatus.org/badges/latest/wip.svg)](https://www.repostatus.org/#wip)
[![Release](https://img.shields.io/github/release/b-cubed-eu/dubicube.svg)](https://github.com/b-cubed-eu/dubicube/releases)
[![dubicube status
badge](https://b-cubed-eu.r-universe.dev/dubicube/badges/version)](https://b-cubed-eu.r-universe.dev/dubicube)
[![CRAN
status](https://www.r-pkg.org/badges/version/dubicube)](https://CRAN.R-project.org/package=dubicube)
[![R-CMD-check](https://github.com/b-cubed-eu/dubicube/actions/workflows/check_on_different_r_os.yml/badge.svg)](https://github.com/b-cubed-eu/dubicube/actions/workflows/check_on_different_r_os.yml)
[![codecov](https://codecov.io/gh/b-cubed-eu/dubicube/branch/main/graph/badge.svg)](https://app.codecov.io/gh/b-cubed-eu/dubicube/)
[![DOI](https://zenodo.org/badge/DOI/10.5281/zenodo.14850237.svg)](https://doi.org/10.5281/zenodo.14850237)
[![name status
badge](https://b-cubed-eu.r-universe.dev/badges/:name?color=6CDDB4)](https://b-cubed-eu.r-universe.dev/)

<!-- badges: end -->

The **dubicube** package aims to deliver measures for assessing the
applicability of biodiversity data cubes, whether for general use or
specific biodiversity indicators. These measures facilitate data
exploration by providing insights into data quality and reliability.
Additionally, the package includes functions for calculating indicator
uncertainty using bootstrapping, as well as tools for interpreting and
visualising uncertainty in biodiversity indicators derived from
occurrence cubes.

## Installation

Install **dubicube** in R:

``` r
install.packages("dubicube"", repos = c("https://b-cubed-eu.r-universe.dev", "https://cloud.r-project.org"))
```

You can install the development version from
[GitHub](https://github.com/) with:

``` r
# install.packages("remotes")
remotes::install_github("b-cubed-eu/dubicube")
```

## Key features of **dubicube**

The **dubicube** package provides a set of tools for assessing,
interpreting, and visualising uncertainty in biodiversity indicators
derived from occurrence data cubes. Its functionality is organised into
three main areas:

### 1. Data exploration and variability assessment

**dubicube** includes functions to evaluate the structure and
sensitivity of biodiversity data cubes, helping users understand data
quality and applicability.

- `cross_validate_cube()` Perform cross-validation (e.g. leave-one-out
  or k-fold) to assess group-level sensitivity of biodiversity
  indicators. This helps evaluate how individual categories influence
  biodiversity indicator values.

> Additional data quality measures are under development and will be
> available in future updates.

### 2. Estimating indicator uncertainty

To quantify the uncertainty associated with biodiversity indicators
derived from data cubes, **dubicube** provides bootstrap-based tools:

- `bootstrap_cube()` Generate bootstrap replicates of the input cube to
  estimate the variability, bias, and standard error of biodiversity
  indicators.

- `calculate_bootstrap_ci()` Compute confidence intervals (percentile,
  BCa, normal, or basic) from bootstrap distributions, optionally
  applying transformations or bias corrections.

### 3. Interpretation and visualisation of indicators

**dubicube** supports the interpretation of indicator values in the
context of uncertainty and predefined reference or threshold values:

- `add_effect_classification()` Classify indicator results
  (e.g. increase, stable, decrease) by comparing confidence intervals to
  user-defined references and thresholds.

> Tutorials on good practices for spatial and temporal indicator
> interpretation are coming soon!
