# CONTRIBUTING #

### Fixing typos

Small typos or grammatical errors in documentation may be edited directly using the GitHub web interface, so long as the changes are made in the _source_ file.
E.g. edit a `roxygen2` comment in a `.R` file below `R/`, not in an `.Rd` file below `man/`.

### Prerequisites

Before you make a substantial pull request, you should always file an issue and make sure someone from the team agrees that it’s a problem. 
If you’ve found a bug, create an associated issue and illustrate the bug with a minimal [reproducible example](https://www.tidyverse.org/help/#reprex).

### Pull request process

*  We recommend that you create a Git branch for each pull request (PR).  
*  Look at the GitHub Actions build status before and after making changes.
The `README` should contain badges for any continuous integration services used by the package.  
*  We require the `tidyverse` [style guide](http://style.tidyverse.org).
You can use the [`styler`](https://CRAN.R-project.org/package=styler) package to apply these styles, but please don't restyle code that has nothing to do with your PR.  
*  We use [`roxygen2`](https://cran.r-project.org/package=roxygen2).  
*  We use [`testthat`](https://cran.r-project.org/package=testthat). 
Contributions with test cases included are easier to accept.  
*  For user-facing changes, add a bullet to the top of `NEWS.md` below the current development version header describing the changes made followed by your GitHub username, and links to relevant issue(s)/PR(s).

### Code of Conduct

Please note that this project is released with a [Contributor Code of Conduct](CODE_OF_CONDUCT.md). 
By contributing to this project you agree to abide by its terms.

### Prefer to Email? 

Email the person listed as maintainer in the `DESCRIPTION` file of this repo.

Though note that private discussions over email don't help others - of course
email is totally warranted if it's a sensitive problem of any kind.

### Thanks for contributing!

This contributing guide is adapted from the `tidyverse` contributing guide available at https://raw.githubusercontent.com/r-lib/usethis/master/inst/templates/tidy-contributing.md 
