#!/usr/bin/env bash

# vim:ft=bash

set -u

# Takes an Expect script as generated by autoexpect, and modifies it so as to
# make it more useable by ./run-tests.sh.

# I delete lines 3-42 not because I don't like them, but because I don't need
# them in _all_ the test scripts.

# Then I define and parse options -t and -w, which pass Expect timeout and
# Crossterm poll wait time, respectively.

# Next, if the autoexpect command wasn't passed --poll-wait-time, I add it,
# using the value of pwt as an argument (this is just the argument to -t as
# passed to the Expect script). IOW, the wait time passed to the Expect script
# via -t gets passed to termal vial --poll-wait-time.

# Then I add a `default` clause to all `expect` commands, so that the test
# _fails_ (instead of blithely proceeding) if an expect is not met.

# And finally I add a few lines that catch the exit code of termal and exit with
# it, so that if termal fails, so does the Expect script.

sed '{
	3,42d;
    /^set timeout/c\
package require cmdline\
\
set options {\
        {t.arg 1 "Expect timeout [s]"}\
        {w.arg 500 "Crossterm poll wait time [ms]"}\
}\
set usage ": prog \\[options]"\
array set params [::cmdline::getoptions argv $options $usage]\
\
set pwt $params(w)\
set timeout $params(t)\

/\/debug\/termal/{
    /--poll-wait-time/!s/termal/termal --poll-wait-time $pwt/
}
s/^expect -exact \(.*\)$/expect {\n\texpect -exact \1 {} \n\tdefault { exit 1 }\n}/
$a\
\
# Gets the exit code of the spawned process, so that this script fails IFF it \
# did. \
catch wait result \
set prog_exit_code [lindex $result 3] \
exit $prog_exit_code
}' 
