###############################################################################
### PROTECTOR:
protect <- function(expr){
  i <- 0
  temp <- 0; class(temp) <- "try-error"
  repeat{
    if(i > 100) stop(text = deparse(substitute(expr)))
    suppressWarnings(temp <- try(expr, silent = T))
    if(!("try-error" %in% class(temp))) break
    system("sleep 1s")
    i <- i + 1
  }
  return(invisible(NULL))
}
protect(source("common.R"))
protect(dyn.load("newHS.so"))
###############################################################################
library(nloptr)

###############################################################################
LEM.CORE <- function(target.ind, reg.ref.ind){
  tic <- proc.time()
  reg.ref <- as.integer(strsplit(tgtFree.tasks[reg.ref.ind, "forms"], split = ",",
    fixed = T)[[1]])
  funPkg <- fastTestfunGenerator(Data = level.data, target = target.set[target.ind],
    regulator.set = regulator.set[reg.ref[-length(reg.ref)]],
    logic.ind = reg.ref[length(reg.ref)], gxM = gxM)
  rep.try <- rep(Inf, length.out = REQUIRED.REPLICATIONS)
  opt.val.min <- Inf; rec.opt.par <- rec.opt.err.info <- NULL
  rec.par.init <- matrix(NA, nrow = REQUIRED.REPLICATIONS, ncol = length(funPkg$par.lower))
  for(i0 in 1:REQUIRED.REPLICATIONS){
    par.init <- runif(length(funPkg$par.lower)) *
      (funPkg$par.upper - funPkg$par.lower) + funPkg$par.lower
    rec.par.init[i0, ] <- par.init
    opt.prblm <- list(fn = funPkg$fn, gr = funPkg$gr,
      par.upper = funPkg$par.upper, par.lower = funPkg$par.lower,
      par.init = par.init, val = funPkg$fn(par.init), info = "")
    repeatStopper <- 0
    catch.exception <- try(repeat{
      repeatStopper <- repeatStopper + 1
      val.record <- opt.prblm$val
      opt.prblm <- optim.COR.SRCH(opt.prblm)
      opt.prblm <- optim.L.BFGS.B(opt.prblm)
      opt.prblm <- optim.LD.SLSQP(opt.prblm)
      opt.prblm <- optim.COR.SRCH(opt.prblm)
      if(val.record - opt.prblm$val < 1e-8) break
      if(repeatStopper > 5) break
    }, silent = T)
    if("try-error" %in% class(catch.exception)){
      opt.prblm$val <- Inf
      opt.prblm$par.init <- par.init
      opt.prblm$info <- "fn gives Infinity values. The scaling box may be too large."
    }
    rep.try[i0] <- opt.prblm$val
    if(opt.val.min > rep.try[i0]){
      opt.val.min <- rep.try[i0]
      rec.opt.par <- opt.prblm$par.init
      rec.opt.err.info <- opt.prblm$info
    }
    #opt.chi2<- mean((funPkg$slam.fn(opt.par)$target.predict - Data[,target])^2 / Data[,target])
    ### OPTIMIZATION ENDS
  }
  rep.order <- order(rep.try, decreasing = F)
  ################################################################################
  ## NOW DO IMPORTANCE SAMPLING TO COMPUTE THE (UNNORMALIZED) PLD
  pld <- gen.pld(funPkg = funPkg, opt.par = rec.opt.par)
  ################################################################################
  rep.try <- sqrt(rep.try / nrow(level.data))[rep.order]
  return(list(
    reg.ref.ind = reg.ref.ind,
    opt.val = rep.try[1], # sqrt of l(rec.opt.par)
    par = rec.opt.par,
    predict.curv = (funPkg$slam.fn(rec.opt.par))$target.predict,
    err.info = rec.opt.err.info,
    rep.try = rep.try,
    running.time = proc.time() - tic,
    rep.order = rep.order,
    par.init = rec.par.init,
    version = paste(c(unlist(version), system("lsb_release -a",intern = T),
      system("cat /proc/version", intern = T)), collapse = "|"),
    pld = pld$pld,
    pld.prd.raw = pld$const / pld$volume,
    volume = pld$volume
  ))
}
###############################################################################
### MAIN PROGRAM BEGIN
args <- as.integer(commandArgs(TRUE))[[1]]# Here we get taskID, starting from 1.
set.seed(COMMON.RAND.SEED)
set.seed(as.integer(1e8 * (runif(args)[args])))
protect(load("gxTasks.Rdata.SUPER"))
tasks <- tasks[[args]]
if(length(tasks$set.reg.ref.ind) == 0)q("no")
tgtFree.tasks <- gen.tgtFree.tasks(tgtFree.sortedRegIndSets)
LEM.output <- list(); length(LEM.output) <- length(tasks$set.reg.ref.ind)
for(i in 1:length(tasks$set.reg.ref.ind)){
  LEM.output[[i]] <- LEM.CORE(target.ind = tasks$target.ind,
    reg.ref.ind = tasks$set.reg.ref.ind[i])
}
protect(save(LEM.output, file = paste0(args, ".Rdata")))
### MAIN PROGRAM END
