## generate all edges
load("gxTasks.Rdata.SUPER")
source("common.R")
################################################################################
### ROC COMPUTING CODE
library("ROCR")
get.auc <- function(predicted, real.labels){
  return(performance(prediction.obj =
    prediction(predictions = predicted, labels = real.labels),
    measure = "auc")@y.values[[1]])
}
get.aupr <- function(predicted, real.labels){
  pr <- get.pr(predicted = predicted, real.labels = real.labels)
  prlen <- nrow(pr)
  return(sum((diff(pr[,"x"])) * (pr[-1,"y"] + pr[-prlen,"y"])) / 2)
}
get.roc <- function(predicted, real.labels){
  roc <- performance(prediction.obj =
    prediction(predictions = predicted, labels = real.labels),
    measure = "tpr", x.measure = "fpr")
  roc <- cbind(roc@x.values[[1]], roc@y.values[[1]])
  colnames(roc) <- c("x", "y")
  return(roc)
}
get.pr <- function(predicted, real.labels){
  roc <- performance(prediction.obj =
    prediction(predictions = predicted, labels = real.labels),
    measure = "prec", x.measure = "rec")
  roc <- cbind(roc@x.values[[1]], roc@y.values[[1]])
  colnames(roc) <- c("x", "y")
  roc[1,"y"] <- 0
  return(roc)
}
################################################################################
##### GEN SORTED SCORE LIST BEGIN
auc.list <- do.call(c, lapply(target.set, function(this.target){
  load(paste0("lem.", this.target, ".pld"))
  edge.names <- c(paste0("a(", target.set, ")"),
    paste0("r(", target.set, ")"))
  exprs <- gen.tgtFree.tasks(tgtFree.sortedRegIndSets)[reg.ref.ind, 2]
  edge.prob <- unlist(lapply(edge.names, function(edge){
    sum(pld[grep(edge, exprs, fixed = T)])
  })); names(edge.prob) <- paste(this.target, "=", edge.names)
  return(edge.prob)
}))
write.table(sort(auc.list,decreasing = T), file = "auc.list.tsv", sep = "\t", row.names = T,
  col.names = F, quote = F)
##### GEN SORTED SCORE LIST END
ft1 <- function(str)sub("R[LS].+", "", ignore.case = FALSE, str)
ft2 <- function(str)sub("N[0-9].+", "", ignore.case = FALSE, str)
source(paste0("../teds/", ft1(ft2(myFolder.name)), ".ted"))
is.right <- names(auc.list) %in% ted
roc.curv <- get.roc(predicted = auc.list, real.labels = is.right)
pr.curv <- get.pr(predicted = auc.list, real.labels = is.right)
auc <- get.auc(predicted = auc.list, real.labels = is.right)
aupr <- get.aupr(predicted = auc.list, real.labels = is.right)

setEPS();postscript(paste0("auc-",myFolder.name,".eps"))
plot(roc.curv[,1], roc.curv[,2], main = paste(myFolder.name, "\nauc =", auc),
  type = "l", lwd = 2, col = "#FF5555",
  xlab = "False positive rate", ylab = "True positive rate")
dev.off()
setEPS();postscript(paste0("aupr-",myFolder.name,".eps"))
plot(pr.curv[,1], pr.curv[,2], main = paste(myFolder.name, "\naupr =", aupr),
  type = "l", lwd = 2, col = "#FF5555",
  xlab = "Recall", ylab = "Precision")
dev.off()

right.list <- sort(auc.list[is.right], decreasing = F)
wrong.list <- sort(auc.list[!is.right], decreasing = T)
write.table(cbind(right.list), file = "right.list.txt", quote = F, sep = "\t", col.names = F, row.names = T)
write.table(cbind(wrong.list), file = "wrong.list.txt", quote = F, sep = "\t", col.names = F, row.names = T)

write(paste(auc), file = paste0("../", myFolder.name, ".auc"))
write(paste(aupr), file = paste0("../", myFolder.name, ".aupr"))
