source("common.R")
uni.denser <- function(orig, ratio){
  #ratio: {modified sampling times}/{original sampling times}
  PRECISION <- 1e6 # total steps of the whole timing span
  LOWER.BOUND <- 0.001 # if level <= 0, replace with this bound.
  time.offset <- orig[1,"time"]; orig[,"time"] <- orig[,"time"] - time.offset
  path <- seq(min(orig[,"time"]), max(orig[,"time"]), length.out = PRECISION)
  is.node.output <- c(T, rep(F, times = PRECISION - 2), T)
  interpo.data <- lapply(colnames(orig)[-1], function(a){
    y <- approx(x = orig[,"time"], y = orig[,a], xout = path)$y
    #y <- spline(x = orig[,"time"], y = orig[,a], xout = path)$y
    return(pmax(LOWER.BOUND, y))
  }); names(interpo.data) <- colnames(orig)[-1]
  max.tot.var <- do.call(pmax, lapply(interpo.data, function(a)abs(diff(a))))
  max.tot.var <- diffinv(sqrt(max.tot.var^2 + diff(path)^2), xi = 0)
  num.new.samp.pts <- as.integer(nrow(orig) * ratio + 0.5)
  for(i in 1:(num.new.samp.pts-2)){
    this.threshold <- max.tot.var[PRECISION] * i / (num.new.samp.pts-1)
    is.node.output[sum(max.tot.var <= this.threshold)] <- T
  }
  output <- matrix(0, nrow = num.new.samp.pts, ncol = ncol(orig))
  colnames(output) <- colnames(orig)
  output[,"time"] <- time.offset + path[is.node.output]
  for(a in colnames(orig)[-1]){
    output[,a] <- interpo.data[[a]][is.node.output]
  }
  return(output)
}

args <- commandArgs(TRUE)
ratio <- as.double(ifelse(length(args) == 2, yes = args[2], no = 1))
var.nm <- args[1]
var.nm <- sub("\\.DATA$", "", var.nm, fixed = F)
var.nm <- sub("\\.Rdata$", "", var.nm, fixed = F)
new.var.nm <- paste0(var.nm, "RLSP", ratio)
load(args[1])
orig <- get(var.nm); rm(list = var.nm)
################################################################################
#  THIS PART BOXES THE DATA
orig[,"time"] <- (orig[,"time"] - orig[1,"time"]) / diff(range(orig[,"time"])) * TIME.BOX.SIZE
for(nm in colnames(orig)[-1]) orig[,nm] <- orig[,nm] / max(orig[,nm]) * LEVEL.BOX.SIZE
################################################################################
assign(new.var.nm, uni.denser(orig = orig, ratio = ratio))
save(list=new.var.nm, file = paste0(new.var.nm, ".DATA"))
temp <- get(new.var.nm)
for(a in colnames(temp)[-1]){
  setEPS();postscript(paste0("plt-", a, "-", new.var.nm, ".eps"))
  plot(temp[,"time"], temp[,a], main = "red:orig, black:interpolated.")
  lines(orig[,"time"], orig[,a], type="o", col="red", pch = 4)
  dev.off()
}
