library(deSolve)
source("common.R")
load("gxTasks.Rdata.SUPER")
tgtFree.tasks <- gen.tgtFree.tasks(tgtFree.sortedRegIndSets)
task.target.ind <- unlist(lapply(tasks, function(a)a$target.ind))

gen.odeOutput <- function(list.reg.ref.ind, times){
  d <- length(target.set)
  stopifnot(length(list.reg.ref.ind) == d)
  option.list <- list(); length(option.list) <- d; names(option.list) <- target.set
  for(i in 1:d){
    file.ind <- which(task.target.ind == i)[unlist(lapply(
      tasks[task.target.ind == i], function(i0){
        list.reg.ref.ind[i] %in% i0$set.reg.ref.ind
      }))]
    load(paste0(file.ind, ".Rdata"))
    LEM.output <- LEM.output[[which(unlist(lapply( LEM.output, function(i0){
        list.reg.ref.ind[i] == i0$reg.ref.ind })))]]
    temp <- as.integer(strsplit(tgtFree.tasks[list.reg.ref.ind[i],
      "forms"], split = ",")[[1]])
    option.list[[i]] <- list(
      regulators = target.set[temp[-length(temp)]],
      logic = temp[length(temp)],
      par.init = LEM.output$par,
      predict.curv = LEM.output$predict.curv
    )
  }
  #############################################################################
  par.dim <- unlist(lapply(option.list, function(a)length(a$regulators)))
  par.pointerC <- diffinv(unlist(lapply(option.list,
    function(i0)length(i0$par.init))), xi = 0)
  par.init <- unlist(lapply(option.list, function(a){ a$par.init }))
  str <- "#include \"../newG.h\"\n"
  str <- paste0(str,
    "void gemc(const double *yin, double *yout, const double *par){\n")
  regulator.indexSet <- structure(1:d, names = target.set)
  for(i in 1:d){
    Iout <- i - 1
    Iregus <- regulator.indexSet[option.list[[i]]$regulators] - 1
    Iregus <- sortAndPermut(obj = Iregus, logicInd = option.list[[i]]$logic)
    Ipar <- par.pointerC[i]
    logic.str <- paste0("  LOGIC_",
      get.form.name(numOfRegs = par.dim[i], logicInd = option.list[[i]]$logic))
    str <- paste0(str, logic.str, "(", Iout, ", ", paste(Iregus,
      collapse = ", "), ", ", Ipar, ");\n")
  }
  str <- paste0(str, "}")
  ### BEGIN TO WRITE FUNCTION
  temp <- 0; class(temp) <- "try-error"
  my.wd <- getwd()
  i <- 0
  while("try-error" %in% class(temp)){
    i <- i + 1
    if(i > 10){
      error("c code cannot be CoMpIlEd.")
    }
    folder <- system(command = "mktemp --directory -p .", intern = T)
    setwd(folder)
    write(str, file = "a.c")
    system("R CMD SHLIB a.c")
    suppressWarnings(temp <- try(dyn.load("a.so"), silent = T))
    setwd(my.wd)
    system(paste("rm -rf ", folder))
    system(paste("rm -rf ", folder))# What a buggy machine! It asks me to do it twice!!!
  }
  pointer <- getNativeSymbolInfo(name = "gemc", PACKAGE = "a")$address
  Gy <- function(t, y, parms,...){
    return(list(y=.C(pointer, yin = as.double(y), yout = double(length(y)),
      par = as.double(par.init), NAOK = T, DUP = F)$yout))
  }
  times <- sort(unique(sort(c(times, level.data[,"time"]), decreasing = F)), decreasing = F)
  ode.solution <- ode(y = level.data[1,target.set], times = times,
    func = Gy, parms = NULL, method = "bdf_d")[,-1]
  colnames(ode.solution) <- target.set
  ### OUTPUT ALL THE DATA INTO A TSV FILE ######################################
  save(ode.solution, times, file = "odeDataPackage.SUPER")
  ### GENERATE OUTPUT ##########################################################
  for(nm in target.set){
    setEPS(); postscript(paste(nm, "-comparing.eps"))
    x2 <- x1 <- level.data[,"time"]
    y1 <- level.data[,nm]
    y2 <- option.list[[nm]]$predict.curv
    x3 <- times
    y3 <- ode.solution[,nm]
    y3.ess <- y3[times %in% level.data[,"time"]]
    x.range <- range(c(x1,x2,x3)); y.range <- range(c(y1,y2,y3))
    plot(x.range, y.range, type = "n", ylab="representing level",
      xlab = paste0("dashed:lem-approx(L); circle:data(D); red:ODE(O)\n",
      " d(L,D)=",signif(sqrt(mean((y2-y1)^2))),
      " d(L,O)=",signif(sqrt(mean((y2-y3.ess)^2))),
      " d(D,O)=",signif(sqrt(mean((y1-y3.ess)^2)))), main = nm)
    lines(x1, y1, type = "p")
    lines(x2, y2, type = "l", lty = 2)
    lines(x3, y3, type = "l", col = "red")
    dev.off()
  }
}
logics <- list(
c(8, 3, 15, 35, 9),
c(47, 3, 15, 35, 9),
c(8, 10, 15, 35, 9),
c(8, 3, 44, 35, 9),
c(8, 3, 15, 7, 9),
c(8, 3, 15, 35, 25),
c(205,71,73,178,209)
)
collect <- (1:length(target.set)) * NA; names(collect) <- target.set
for(nm in target.set){
  temp <- paste0(nm, ".txt")
  temp <- paste0("cat ", temp, "| head -2 |tail -1")
  temp <- system(temp, intern = T)
  temp <- as.integer(strsplit(temp, split="\t")[[1]][1])
  collect[nm] <- temp
}
write(paste(collect, collapse = ", "), file ="")
gen.odeOutput(list.reg.ref.ind = collect,
  times = seq(min(level.data[,"time"]),
  max(level.data[,"time"]), length.out = 500))

uncertainty <- mapply(function(nm){
  pld <- NULL; rm(pld)
  load(paste0("lem.", nm, ".pld"))
  pld <- pld[pld > 0]
  print(sum(pld))
  pld <- pld / sum(pld)
  pld <- pld[pld > 0]
  return(-sum(pld * log(pld)))
}, target.set)
names(uncertainty) <- target.set
write.table(uncertainty, quote = F, col.names = F, file = "NodeUncertainty.tsv",
  sep = "\t")
