form.name.set <- c("r", "a", "rr", "ra", "aa", "apa", "rrr", "rra", "raa", "rapa",
  "aaa", "aapa", "apapa", "aappa", "rrrr", "rrra", "rraa", "rrapa", "raaa",
  "raapa", "rapapa", "aaaa", "aaapa", "aapapa", "apapapa", "apaapa",
  "rrrrr", "rrrra", "rrraa", "rrrapa", "rraaa", "rraapa", "rrapapa",
  "raaaa", "raaapa", "raapapa", "rapapapa", "aaaaa", "aaaapa", "aaapapa",
  "aapapapa", "apapapapa", "rapaapa", "aapaapa", "apapaapa")

form.label.set <- c("r(X)", "a(X)", "r(X) * r(X)", "r(X) * a(X)", "a(X) * a(X)",
  "a(X) + a(X)", "r(X) * r(X) * r(X)", "r(X) * r(X) * a(X)",
  "r(X) * a(X) * a(X)", "r(X) * [a(X) + a(X)]", "a(X) * a(X) * a(X)",
  "a(X) * [a(X) + a(X)]", "a(X) + a(X) + a(X)", "a(X) * a(X) + a(X)", "r(X) * r(X) * r(X) * r(X)",
  "r(X) * r(X) * r(X) * a(X)", "r(X) * r(X) * a(X) * a(X)",
  "r(X) * r(X) * [a(X) + a(X)]", "r(X) * a(X) * a(X) * a(X)",
  "r(X) * a(X) * [a(X) + a(X)]", "r(X) * [a(X) + a(X) + a(X)]",
  "a(X) * a(X) * a(X) * a(X)", "a(X) * a(X) * [a(X) + a(X)]",
  "a(X) * [a(X) + a(X) + a(X)]", "a(X) + a(X) + a(X) + a(X)",
  "[a(X) + a(X)] * [a(X) + a(X)]", "r(X) * r(X) * r(X) * r(X) * r(X)",
  "r(X) * r(X) * r(X) * r(X) * a(X)", "r(X) * r(X) * r(X) * a(X) * a(X)",
  "r(X) * r(X) * r(X) * [a(X) + a(X)]", "r(X) * r(X) * a(X) * a(X) * a(X)",
  "r(X) * r(X) * a(X) * [a(X) + a(X)]", "r(X) * r(X) * [a(X) + a(X) + a(X)]",
  "r(X) * a(X) * a(X) * a(X) * a(X)", "r(X) * a(X) * a(X) * [a(X) + a(X)]",
  "r(X) * a(X) * [a(X) + a(X) + a(X)]", "r(X) * [a(X) + a(X) + a(X) + a(X)]",
  "a(X) * a(X) * a(X) * a(X) * a(X)", "a(X) * a(X) * a(X) * [a(X) + a(X)]",
  "a(X) * a(X) * [a(X) + a(X) + a(X)]", "a(X) * [a(X) + a(X) + a(X) + a(X)]",
  "a(X) + a(X) + a(X) + a(X) + a(X)", "r(X) * [a(X) + a(X)] * [a(X) + a(X)]",
  "a(X) * [a(X) + a(X)] * [a(X) + a(X)]", "[a(X) + a(X) + a(X)] * [a(X) + a(X)]")
form.numpar.4code.set <- c(1,1,1,1,1,2,1,1,1,2, 1,2,3,2,1,1,1,2,1,
  2,3,1,2,3,4,4, 1,1,1,2,1,2,3, 1,2,3,4,1,2,3, 4,5,4,4,6)
form.numpar.4show.set <- c(1,1,1,1,1,2,1,1,1,2, 1,2,3,2,1,1,1,2,1,
  2,3,1,2,3,4,3, 1,1,1,2,1,2,3, 1,2,3,4,1,2,3, 4,5,3,3,4)

permut.set <- list()
gxdcmp <- function(...)lapply(c(...), function(i) as.integer(strsplit(
            paste0(i), split = "", fixed = T)[[1]]))

permut.set[[1]] <- 1

permut.set[2:3]  <- gxdcmp(12, 21)

permut.set[4:6]  <- gxdcmp(123, 231, 312)

permut.set[7:10] <- gxdcmp(4321, 4132, 4213, 1234)

permut.set[11:22] <- gxdcmp(1234, 1324, 1423, 2314, 2413, 3412,
                       2134, 3124, 4123, 3214, 4213, 4312)

permut.set[23:27] <- gxdcmp(12345, 23451, 34512, 45123, 51234)

permut.set[28:32] <- gxdcmp(13524, 35241, 52413, 24135, 41352)

permut.set[33:42] <- gxdcmp(21345, 32451, 43512, 54123, 15234,
                       31524, 53241, 25413, 42135, 14352)

permut.set[43:72] <- gxdcmp(12345, 23145, 31245, 12435, 24135, 41235,
                       13425, 34125, 41325, 23415, 34215, 42315,
                       12534, 25134, 51234, 13524, 35124, 51324,
                       23514, 35214, 52314, 14523, 45123, 51423,
                       24513, 45213, 52413, 34512, 45312, 53412)

permut.set[73:87] <- gxdcmp(12345, 12435, 12534,
                       21345, 21435, 21534,
                       31245, 31425, 31524,
                       41235, 41325, 41523,
                       51234, 51324, 51423)
rm(gxdcmp)
###############################################################################
form.map <- list()# index of function call
permut.map <- list()# index of permutations

form.map[[1]] <- 1:2
permut.map[[1]] <- c(1,1)

form.map[[2]] <- c(3,4,4,5,6)
permut.map[[2]] <- c(2,2,3,2,2)


form.map[[3]] <- c(7, 8,8,8, 9,9,9, 10,10,10, 11, 12,12,12, 13, 14,14,14)
permut.map[[3]] <- c(4, 4,5,6, 4,5,6,    4,5,6,  4,    4,5,6,  4,4,5,6)

form.map[[4]] <- c(rep(14, 1), rep(15, 4), rep(16, 6), rep(17, 6),
                  rep(18, 4), rep(19,12), rep(20, 4), rep(21, 1),
		  rep(22, 6), rep(23, 4), rep(24, 1), rep(25, 3)) + 1
permut.map[[4]] <- c(        11,       7:10,      11:16,      11:16,
                        c(12,15,18,21),      11:22,       c(12,15,18,21),         11,
		       11:16,       c(12,15,18,21),         11,        7:9)

form.map[[5]] <- c(rep(26, 1), rep(27, 5), rep(28,10), rep(29,10),
                  rep(30,10), rep(31,30), rep(32,10), rep(33, 5),
		  rep(34,30), rep(35,20), rep(36, 5), rep(37, 1),
		  rep(38,10), rep(39,10), rep(40, 5), rep(41, 1),
		  rep(42,15), rep(43,15), rep(44,10)) + 1
permut.map[[5]] <- c(        23,      23:27,      23:32,      23:32,
                       23:32,      43:72,      23:32,      23:27,
		       43:72,      23:42,      23:27,         23,
		       23:32,      23:32,      23:27,         23,
		       73:87,      73:87,      23:32)
################################################################################
parent.M <- list(); length(parent.M) <- 5
#parent.M[[1]] <- matrix(c(1,1), nrow = 1, ncol = 2)
parent.M[[2]] <- rbind(
  c(1,2,1,2,2),#delA
  c(1,1,2,2,2)#delB
)
parent.M[[3]] <- rbind(
  c(1, 2, 1, 3, 4, 2, 3, 5, 2, 3, 4, 5, 4, 4, 5, 5, 4, 5),#delA
  c(1, 2, 3, 1, 2, 4, 3, 2, 5, 3, 4, 4, 5, 4, 5, 5, 5, 4),#delB
  c(1, 1, 3, 2, 2, 3, 4, 2, 3, 5, 4, 4, 4, 5, 5, 4, 5, 5)#delC
)
parent.M[[4]] <- rbind(
  c(1, 1, 3, 4, 2, 5, 6, 7, 2, 4, 3, 8, 9, 10, 2, 4, 3, 11, 5, 6, 7, 12, 13, 14,
  5, 5, 6, 8, 9, 10, 6, 7, 7, 15, 8, 9, 10, 11, 12, 13, 14, 11, 11, 11, 15, 12,
  13, 14, 15, 12, 14, 13),#delA
  c(1, 3, 1, 4, 2, 5, 2, 4, 6, 7, 3, 8, 2, 4, 9, 10, 3, 5, 11, 6, 7, 8, 5, 5,
  13, 14, 6, 12, 6, 7, 9, 10, 7, 8, 15, 9, 10, 11, 12, 11, 11, 13, 14, 11, 12,
  15, 13, 14, 15, 12, 13, 14),#delB
  c(1, 3, 4, 1, 2, 2, 5, 4, 6, 3, 7, 2, 8, 4, 9, 3, 10, 5, 6, 11, 7, 5, 8, 5, 9,
  6, 14, 6, 12, 7, 13, 7, 10, 8, 9, 15, 10, 11, 11, 12, 11, 13, 11, 14, 12, 13,
  15, 14, 15, 14, 13, 12),#delC
  c(1, 3, 4, 2, 1, 2, 4, 5, 3, 6, 7, 2, 4, 8, 3, 9, 10, 5, 6, 7, 11, 5, 5, 8, 6,
  9, 10, 6, 7, 12, 7, 13, 14, 8, 9, 10, 15, 11, 11, 11, 12, 11, 13, 14, 12, 13,
  14, 15, 15, 14, 12, 13)#delD
)
parent.M[[5]] <- rbind(
  c(1, 5, 1, 2, 3, 4, 6, 5, 2, 11, 8, 10, 4, 3, 7, 9, 12, 5, 2, 17, 14, 16, 4,
  3, 13, 15, 18, 6, 9, 11, 21, 19, 10, 8, 7, 20, 22, 12, 28, 23, 13, 29, 25, 15,
  31, 6, 9, 7, 24, 14, 30, 26, 16, 32, 6, 10, 8, 27, 17, 33, 7, 11, 8, 9, 11,
  10, 34, 12, 15, 17, 37, 35, 16, 14, 13, 36, 38, 18, 19, 20, 21, 39, 22, 28,
  40, 23, 29, 42, 25, 31, 18, 19, 20, 41, 24, 30, 43, 26, 32, 18, 19, 21, 44,
  27, 33, 18, 20, 21, 19, 20, 21, 45, 22, 25, 27, 37, 46, 26, 30, 23, 36, 34,
  28, 31, 33, 48, 35, 32, 24, 29, 47, 49, 34, 35, 36, 37, 38, 39, 38, 38, 44,
  41, 43, 38, 38, 40, 42, 45, 39, 42, 44, 48, 46, 43, 41, 40, 47, 49, 45, 46,
  47, 48, 49, 50, 52, 51, 22, 23, 24, 28, 25, 26, 29, 31, 27, 30, 32, 33, 50,
  52, 51, 39, 40, 41, 39, 42, 43, 40, 42, 44, 41, 43, 44, 50, 48, 45, 50, 51,
  52, 47, 46, 52, 51),#delA
  c(1, 5, 2, 1, 3, 4, 6, 9, 2, 3, 8, 4, 10, 11, 7, 5, 12, 15, 2, 3, 14, 4, 16,
  17, 13, 5, 18, 19, 9, 11, 8, 6, 10, 21, 20, 7, 22, 28, 12, 23, 29, 13, 6, 9,
  7, 25, 15, 31, 24, 30, 14, 6, 10, 8, 26, 16, 32, 7, 11, 8, 27, 17, 33, 9, 11,
  10, 34, 35, 15, 17, 14, 12, 16, 37, 36, 13, 18, 38, 19, 20, 21, 22, 39, 28,
  23, 40, 29, 18, 19, 20, 42, 25, 31, 24, 41, 30, 18, 19, 21, 43, 26, 32, 18,
  20, 21, 44, 27, 33, 19, 20, 21, 34, 46, 25, 27, 30, 22, 26, 37, 47, 29, 45,
  35, 31, 33, 24, 28, 32, 48, 36, 23, 34, 49, 35, 36, 37, 38, 39, 42, 38, 38,
  41, 38, 43, 44, 40, 38, 45, 46, 42, 44, 41, 39, 43, 48, 47, 40, 45, 49, 46,
  47, 48, 49, 22, 23, 24, 50, 52, 51, 28, 26, 25, 29, 27, 31, 30, 33, 32, 39,
  40, 41, 50, 52, 51, 39, 43, 42, 40, 44, 42, 41, 44, 43, 50, 51, 45, 46, 51,
  47, 52, 50, 52, 48),#delB
  c(1, 5, 2, 3, 1, 4, 6, 9, 11, 3, 4, 8, 10, 2, 5, 7, 12, 15, 17, 3, 4, 14, 16,
  2, 5, 13, 6, 19, 20, 11, 8, 18, 21, 10, 9, 7, 12, 28, 22, 6, 9, 7, 23, 29, 13,
  25, 31, 15, 6, 10, 8, 24, 30, 14, 26, 32, 16, 7, 11, 8, 9, 11, 10, 27, 17, 33,
  12, 35, 36, 17, 14, 34, 37, 16, 15, 13, 18, 19, 38, 20, 21, 22, 28, 39, 18,
  19, 20, 23, 40, 29, 25, 42, 31, 18, 19, 21, 24, 41, 30, 26, 43, 32, 18, 20,
  21, 19, 20, 21, 44, 27, 33, 22, 35, 47, 27, 30, 34, 48, 32, 25, 29, 28, 46,
  36, 33, 24, 45, 37, 26, 31, 23, 34, 35, 49, 36, 37, 38, 39, 42, 44, 38, 38,
  41, 43, 38, 38, 40, 39, 46, 47, 44, 41, 45, 48, 43, 42, 40, 45, 46, 49, 47,
  48, 49, 22, 24, 23, 28, 26, 25, 50, 52, 51, 27, 29, 31, 33, 30, 32, 39, 41,
  40, 39, 43, 42, 50, 52, 51, 44, 40, 42, 44, 41, 43, 50, 51, 50, 46, 47, 51,
  52, 45, 48, 52),#delC
  c(1, 5, 2, 3, 4, 1, 5, 9, 11, 8, 4, 3, 2, 10, 6, 7, 5, 15, 17, 14, 4, 3, 2,
  16, 12, 13, 6, 9, 20, 21, 8, 7, 11, 10, 19, 18, 6, 9, 7, 12, 28, 22, 13, 29,
  23, 15, 31, 25, 6, 10, 8, 7, 11, 8, 9, 11, 10, 24, 30, 14, 26, 32, 16, 27, 33,
  17, 12, 15, 36, 37, 14, 13, 17, 16, 35, 34, 18, 19, 20, 38, 21, 18, 19, 20,
  22, 28, 39, 23, 29, 40, 25, 31, 42, 18, 19, 21, 18, 20, 21, 19, 20, 21, 24,
  41, 30, 26, 43, 32, 27, 44, 33, 22, 25, 36, 48, 30, 23, 27, 32, 35, 45, 28,
  31, 47, 37, 24, 29, 33, 26, 46, 34, 34, 35, 36, 49, 37, 38, 38, 42, 44, 41,
  38, 38, 38, 43, 39, 40, 39, 42, 47, 48, 41, 40, 44, 43, 46, 45, 45, 46, 47,
  49, 48, 49, 24, 22, 23, 26, 28, 25, 27, 29, 31, 50, 52, 51, 33, 32, 30, 41,
  39, 40, 43, 39, 42, 44, 40, 42, 50, 52, 51, 44, 43, 41, 48, 51, 50, 51, 47,
  46, 45, 52, 50, 52),#delD
  c(1, 1, 2, 3, 4, 5, 5, 2, 11, 8, 6, 7, 9, 10, 4, 3, 5, 2, 17, 14, 12, 13, 15,
  16, 4, 3, 6, 9, 11, 21, 18, 7, 20, 19, 10, 8, 6, 9, 7, 6, 10, 8, 7, 11, 8, 9,
  11, 10, 12, 28, 22, 13, 29, 23, 15, 31, 25, 14, 30, 24, 16, 32, 26, 17, 33,
  27, 12, 15, 17, 37, 34, 13, 36, 35, 16, 14, 18, 19, 20, 21, 38, 18, 19, 20,
  18, 19, 21, 18, 20, 21, 19, 20, 21, 22, 28, 39, 23, 29, 40, 25, 31, 42, 24,
  30, 41, 26, 32, 43, 27, 33, 44, 22, 25, 27, 37, 45, 23, 36, 46, 26, 30, 28,
  31, 33, 48, 34, 29, 47, 35, 32, 24, 34, 35, 36, 37, 49, 38, 38, 38, 44, 41,
  39, 40, 42, 43, 38, 38, 39, 42, 44, 48, 45, 40, 47, 46, 43, 41, 45, 46, 47,
  48, 49, 49, 24, 23, 22, 26, 25, 28, 27, 31, 29, 33, 32, 30, 50, 52, 51, 41,
  40, 39, 43, 42, 39, 44, 42, 40, 44, 43, 41, 50, 52, 51, 48, 45, 50, 51, 50,
  52, 51, 52, 47, 46)#delE
)
################################################################################
#  BELOW ARE FUNCTIONS THIS FILE OFFERS.
################################################################################
get.form.name <- function(numOfRegs, logicInd){
  stopifnot(length(logicInd) == 1)
  stopifnot(numOfRegs %in% 1:length(form.map))
  stopifnot(logicInd %in% 1:length(form.map[[numOfRegs]]))
  return(form.name.set[ form.map[[numOfRegs]][logicInd] ])
}
get.form.label <- function(numOfRegs, logicInd){
  stopifnot(length(logicInd) == 1)
  stopifnot(numOfRegs %in% 1:length(form.map))
  stopifnot(logicInd %in% 1:length(form.map[[numOfRegs]]))
  return(form.label.set[ form.map[[numOfRegs]][logicInd] ])
}
sortAndPermut <- function(obj, logicInd){
  stopifnot(length(logicInd) == 1)
  numOfRegs = length(obj)
  stopifnot(numOfRegs %in% 1:length(permut.map))
  stopifnot(logicInd %in% 1:length(permut.map[[numOfRegs]]))
  obj <- sort(obj, decreasing = F)
  return(obj[ permut.set[[ permut.map[[numOfRegs]][logicInd] ]] ])
}
get.numOfAlphas.4code <- function(numOfRegs, logicInd){
  stopifnot(length(logicInd) == 1)
  stopifnot(numOfRegs %in% 1:length(form.map))
  stopifnot(logicInd %in% 1:length(form.map[[numOfRegs]]))
  return(form.numpar.4code.set[ form.map[[numOfRegs]][logicInd] ])
}
get.numOfAlphas.4show <- function(numOfRegs, logicInd){
  stopifnot(length(logicInd) == 1)
  stopifnot(numOfRegs %in% 1:length(form.map))
  stopifnot(logicInd %in% 1:length(form.map[[numOfRegs]]))
  return(form.numpar.4show.set[ form.map[[numOfRegs]][logicInd] ])
}
get.ParentLogicIndexes <- function(numOfRegs, logicInd){
  stopifnot(length(logicInd) == 1)
  stopifnot(numOfRegs %in% 1:length(form.map))
  stopifnot(logicInd %in% 1:length(form.map[[numOfRegs]]))
  return(parent.M[[numOfRegs]][ ,logicInd])
}
get.expr <- function(vars.unSorted, logicInd){
  vars <- sortAndPermut(obj = vars.unSorted, logicInd = logicInd)
  numOfRegs <- length(vars)
  temp <- get.form.label(numOfRegs = numOfRegs, logicInd = logicInd)
  temp <- strsplit(paste0(temp, "%%"), split = "X")[[1]]
  temp <- strsplit(paste0(temp, vars, collapse = ""), split = "%%")[[1]][1]
  return(temp)
}
gen.parent.M <- function(){
  vars <- c("A", "B", "C", "D", "E")
  parent.M <- list(); length(parent.M) <- 5
  ranv <- function()rnorm(300)
  zero <- ranv() * 0
  remov.bracket <- function(temp){
    temp <- gsub(pattern="[", replacement="(", x = temp, fixed = T)
    temp <- gsub(pattern="]", replacement=")", x = temp, fixed = T)
    return(temp)
  }
  fundiff <- function(str1, str2, var.list, killWhich){
    for(a in var.list)assign(a, ranv())
    for(a in killWhich)assign(var.list[a], zero)
    str1 <- remov.bracket(str1)
    str2 <- remov.bracket(str2)
    a <- function(x)cos(exp(1)*x); r <- function(x)cos(x)
    the.diff <- sum(abs(eval(parse(text = str1)) - eval(parse(text = str2))))
    a <- function(x)sin(exp(1)*x); r <- function(x)sin(x)
    the.diff <- the.diff * sum(abs(eval(parse(text = str1)) - eval(parse(text = str2))))
    return(the.diff)
  }
  min.margin <- Inf
  max.zero <- 0
  max.scope <- 0
  for(numOfRegs in 2:3){
    parent.M[[numOfRegs]] <- do.call(cbind,
      lapply(1:length(form.map[[numOfRegs]]), FUN = function(logicInd){
        # now we look for the parents of a fixed logic.
	parents <- c()
	exprs <- get.expr(vars.unSorted = vars[1:numOfRegs], logicInd = logicInd)
	for(i in 1:numOfRegs){
	  vars.remove.i <- vars[1:numOfRegs][-i]
	  corresponding.parents <- do.call(c, lapply(1:length(form.map[[numOfRegs - 1]]),
	    function(j){
	      get.expr(vars.unSorted = vars.remove.i, logicInd = j)
	    }))
	  dist.list <- unlist(lapply(corresponding.parents, function(j){
	    fundiff(str1 = exprs, str2 = j, var.list = vars[1:numOfRegs], killWhich = i)
	  }))
	  parents <- c(parents, which(dist.list == min(dist.list)))
	  stopifnot(sum(dist.list == min(dist.list)) == 1)
	  min.margin <<- min(c(min.margin, diff(sort(dist.list, decreasing = F))[1]))
	  max.zero <<- max(max.zero, min(dist.list))
	  max.scope <<- max(max.scope, max(dist.list))
	}
	return(parents)
      }))
  }
  print(paste("MIN MARGIN:", min.margin))
  print(paste("MAX ZERO:", max.zero))
  print(paste("MAX SCOPE:", max.scope))
  return(parent.M)
}
# temp <- gen.parent.M()
# Thu Feb 27 18:18:20 EST 2014 tested, find that parent.M could
# be precisely recovered by gen.parent.M.
