#include <R.h>
#include <math.h>

#define AG const double (*p_Data)[],\
       const int p_Ccol[1],\
       const int p_needGradient[1],\
       const double *p_par,\
       double (*p_workSpace)[],\
       double *p_output,\
       const double (*p_gxM)[],\
       double p_targetPredict[]
#define OBJr -1
#define OBJa 1
/******************************************************************************
* EXPLANATION OF VARIABLES in the C side                                      *
* Data: row 0 stores the levels of target,                                    *
*       row 1~* stores the correctly ordered vectors of the regulators' levels*
* Ccol: row length of the Data, or the time length observed                   *
* needGradient: if not zero, then output gradient information also, otherwise *
*       only returns the function value ||Gamma||^2                           *
* workSpace: space for data operations. Placing R/A, Gblocks, gxM'ed blocks,  *
*       and Gamma                                                             *
* output: if with gradient, then {value, gr1, gr2, ...}, otherwise {value}    *
******************************************************************************/
/* WE ASSUME THAT p_Ccol[0]>=2, and we do not check it. */
static double dotProduct(const double *x, const double *y, int n)
{
    int i;
    double temp = 0;
    for (i = 0; i < n; i++) {
	temp += x[i] * y[i];
    }
    return temp;
}

static double sum(const double *x, int n)
{
    int i;
    double temp = 0;
    for (i = 0; i < n; i++) {
	temp += x[i];
    }
    return temp;
}

static void a(double *ar, const double *xn, double kn, int col)
{
    int i;
    for (i = 0; i < col; i++) {
	ar[i] = xn[i] / (xn[i] + kn);
    }
}

static void r(double *ar, const double *xn, double kn, int col)
{
    int i;
    for (i = 0; i < col; i++) {
	ar[i] = kn / (xn[i] + kn);
    }
}

/******************************************************************************/
#define GENERALHANDLE(K) int col = p_Ccol[0], i,j;\
	      double avgGamma;\
              const int NUMVAR = K;\
	      int NUMBLK;\
	      double *targetPredict = p_targetPredict;\
              const double (*Data)[col] = p_Data;\
              const double (*gxM)[col - 1] = p_gxM;\
              double temp, tp;\
              double (*xn)[col] = p_workSpace;\
              double (*ar)[col] = xn + K;\
              double (*pre_blk)[col] = ar + K;\
              double (*DarDn)[col] = pre_blk + K + 1;\
              double (*DarDk)[col] = DarDn + K;\
              double (*DGammaDn)[col] = DarDk + K;\
              double (*DGammaDk)[col] = DGammaDn + K;\
              double *GBlock = DGammaDk[K];\
              double *Gamma = DGammaDk[K+1];\
              double *IntGBlock = DGammaDk[K+2];\
              double *(blk[K + 1]);\
              const double *nn = p_par;\
              const double *kk = p_par + K;\
              const double gm = p_par[2 * K];\
              const double bt = p_par[2 * K + 1];\
              const double *al = p_par + 2 * K + 2;\
              double kn[K];\
              i=0; do{\
                  kn[i]=pow(kk[i],nn[i]);\
                  blk[i] = pre_blk[i];\
                  for(j=0;j<col;j++){\
                      xn[i][j] = pow(Data[i+1][j], nn[i]);\
              }}while(++i < K);\
	      blk[K] = pre_blk[K]

#define MAKE_BigBlock\
    for(i=0; i<col; i++) GBlock[i] = gm - bt * Data[0][i];\
    for(j=0; j<NUMBLK; j++)for(i=0; i<col; i++) GBlock[i] += blk[j][i] * al[j];\
    for(i=0; i<col; i++) IntGBlock[i]=0;\
    for(j=0; j<col; j++)for(i=1; i<col; i++) IntGBlock[i] += GBlock[j] * gxM[j][i-1];\
    for(i=0; i<col; i++) Gamma[i] = IntGBlock[i] - Data[0][i];\
    avgGamma = 0;\
    for(i=0; i<col; i++) avgGamma += Gamma[i];\
    avgGamma /= col;\
    p_output[0] = 0;\
    for(i=0; i<col; i++) p_output[0] += Gamma[i] * (Gamma[i] - avgGamma);\
    for(i=0; i<col; i++) targetPredict[i] = IntGBlock[i] - avgGamma

#define GET_DarDnk\
    for(i=0; i<NUMVAR; i++){\
    tp = nn[i] * pow(kk[i], nn[i] - 1);\
    for(j=0; j<col; j++){\
        temp = (kn[i] + xn[i][j]) * (kn[i] + xn[i][j]);\
        DarDn[i][j] = -kn[i] * xn[i][j] * log(kk[i] / Data[1 + i][j]) / temp;\
        DarDk[i][j] = -tp * xn[i][j] / temp; }}\
    for(i=0; i<col; i++) GBlock[i] = Gamma[i] - avgGamma;\
    for(i=0; i<col; i++) IntGBlock[i] = 0;\
    for(i=0; i<col; i++)for(j=1; j<col; j++) IntGBlock[i] += gxM[i][j-1]*GBlock[j];\
    for(i=0; i<col; i++) IntGBlock[i] *= 2

#define GARBAGE_MACRO(A)\
    DGammaDn[A][i] = DarDn[A][i] * temp;\
    DGammaDk[A][i] = DarDk[A][i] * temp
#define MTPL1(A,T1) i=0; do{\
    temp = T1;\
    GARBAGE_MACRO(A);}while(++i < col)
#define MTPL2(A,B,T1) i=0; do{\
    temp = ar[B][i] * T1;\
    GARBAGE_MACRO(A);}while(++i < col)
#define MTPL3(A,B,C,T1) i=0; do{\
    temp = ar[B][i] * ar[C][i] * T1;\
    GARBAGE_MACRO(A);}while(++i < col)
#define MTPL4(A,B,C,D,T1) i=0; do{\
    temp = ar[B][i] * ar[C][i] * ar[D][i] * T1;\
    GARBAGE_MACRO(A);}while(++i < col)
#define MTPL5(A,B,C,D,E,T1) i=0; do{\
    temp = ar[B][i] * ar[C][i] * ar[D][i] * ar[E][i] * T1;\
    GARBAGE_MACRO(A);}while(++i < col)
#define MAA(A,B,C,T1,T2) i=0; do{\
    temp = ar[B][i] * T1 + ar[C][i] * T2;\
    GARBAGE_MACRO(A);}while(++i < col)
#define MMAA(A,B,C,D,T1,T2) i=0; do{\
    temp = ar[B][i] * (ar[C][i] * T1 + ar[D][i] * T2);\
    GARBAGE_MACRO(A);}while(++i < col)
#define MAAA(A,B,C,D,T1,T2,T3) i=0; do{\
    temp = ar[B][i] * T1 + ar[C][i] * T2 + ar[D][i] * T3;\
    GARBAGE_MACRO(A);}while(++i < col)
#define MMMAA(A,B,C,D,E,T1,T2) i=0; do{\
    temp = ar[B][i]*ar[C][i]*(ar[D][i]*T1 + ar[E][i]*T2);\
    GARBAGE_MACRO(A);}while(++i < col)
#define MMAAA(A,B,C,D,E,T1,T2,T3) i=0; do{\
    temp = ar[B][i]*(ar[C][i]*T1 + ar[D][i]*T2 + ar[E][i]*T3);\
    GARBAGE_MACRO(A);}while(++i < col)
#define MAAAA(A,B,C,D,E,T1,T2,T3,T4) i=0; do{\
    temp = ar[B][i]*T1 + ar[C][i]*T2 + ar[D][i]*T3 + ar[E][i]*T4;\
    GARBAGE_MACRO(A);}while(++i < col)

/*****************************************************************************/

#define COMBINER_x\
    MTPL1(0,al[0])

#define COMBINER_xx\
    MTPL2(0,1,al[0]); MTPL2(1,0,al[0])
#define COMBINER_xpx\
    MTPL1(0,al[0]); MTPL1(1,al[1])

#define COMBINER_xxx\
    MTPL3(0,1,2,al[0]); MTPL3(1,2,0,al[0]); MTPL3(2,0,1,al[0])
#define COMBINER_xxpx\
    MAA(0,1,2,al[0],al[1]); MTPL2(1,0,al[0]); MTPL2(2,0,al[1])
#define COMBINER_xpxpx\
    MTPL1(0,al[0]); MTPL1(1,al[1]); MTPL1(2,al[2])
#define COMBINER_xxppx\
    MTPL2(0,1,al[0]); MTPL2(1,0,al[0]); MTPL1(2,al[1])

#define COMBINER_xxxx\
    MTPL4(0,1,2,3,al[0]); MTPL4(1,2,3,0,al[0]);\
    MTPL4(2,3,0,1,al[0]); MTPL4(3,0,1,2,al[0])
#define COMBINER_xxxpx\
    MMAA(0,1,2,3,al[0],al[1]); MMAA(1,0,2,3,al[0],al[1]);\
    MTPL3(2,0,1,al[0]); MTPL3(3,0,1,al[1])
#define COMBINER_xxpxpx\
    MAAA(0,1,2,3,al[0],al[1],al[2]);\
    MTPL2(1,0,al[0]);MTPL2(2,0,al[1]);MTPL2(3,0,al[2])
#define COMBINER_xpxpxpx\
    MTPL1(0,al[0]); MTPL1(1,al[1]); MTPL1(2,al[2]); MTPL1(3,al[3])
#define COMBINER_xpxxpx\
    MAA(0,2,3,al[0],al[1]); MAA(1,2,3,al[2],al[3]);\
    MAA(2,0,1,al[0],al[2]); MAA(3,0,1,al[1],al[3])

#define COMBINER_xxxxx\
    MTPL5(0,1,2,3,4,al[0]);MTPL5(1,2,3,4,0,al[0]);MTPL5(2,3,4,0,1,al[0]);\
    MTPL5(3,4,0,1,2,al[0]);MTPL5(4,0,1,2,3,al[0])
#define COMBINER_xxxxpx\
    MMMAA(0,1,2,3,4,al[0],al[1]);MMMAA(1,2,0,3,4,al[0],al[1]);\
    MMMAA(2,0,1,3,4,al[0],al[1]);MTPL4(3,0,1,2,al[0]);\
    MTPL4(4,0,1,2,al[1])
#define COMBINER_xxxpxpx\
    MMAAA(0,1,2,3,4,al[0],al[1],al[2]);\
    MMAAA(1,0,2,3,4,al[0],al[1],al[2]);\
    MTPL3(2,0,1,al[0]);MTPL3(3,0,1,al[1]);MTPL3(4,0,1,al[2])
#define COMBINER_xxpxpxpx\
    MAAAA(0,1,2,3,4,al[0],al[1],al[2],al[3]);\
    MTPL2(1,0,al[0]);MTPL2(2,0,al[1]);MTPL2(3,0,al[2]);MTPL2(4,0,al[3])
#define COMBINER_xpxpxpxpx\
    MTPL1(0,al[0]);MTPL1(1,al[1]);MTPL1(2,al[2]);MTPL1(3,al[3]);MTPL1(4,al[4])
#define COMBINER_xxpxxpx\
    i=0; do{\
    temp = ar[1][i]*ar[3][i]*al[0] + ar[1][i]*ar[4][i]*al[1] +\
        ar[2][i]*ar[3][i]*al[2] + ar[2][i]*ar[4][i]*al[3];\
    GARBAGE_MACRO(0);}while(++i < col);\
    MMAA(1,0,3,4,al[0],al[1]); MMAA(2,0,3,4,al[2],al[3]);\
    MMAA(3,0,1,2,al[0],al[2]); MMAA(4,0,1,2,al[1],al[3])
#define COMBINER_xpxpxxpx\
    MAA(0,3,4,al[0],al[1]);MAA(1,3,4,al[2],al[3]);MAA(2,3,4,al[4],al[5]);\
    MAAA(3,0,1,2,al[0],al[2],al[4]);MAAA(4,0,1,2,al[1],al[3],al[5])

/*****************************************************************************/

#define BLKARRANGE_x blk[0] = ar[0]; NUMBLK = 1


#define BLKARRANGE_xx for(i=0; i<col; i++)blk[0][i]=ar[0][i]*ar[1][i]; NUMBLK = 1
#define BLKARRANGE_xpx blk[0]=ar[0]; blk[1]=ar[1]; NUMBLK = 2


#define BLKARRANGE_xxx for(i=0;i<col;i++)\
	blk[0][i]=ar[0][i]*ar[1][i]*ar[2][i]; NUMBLK = 1
#define BLKARRANGE_xxpx i=0; do{\
	blk[0][i]=ar[0][i]*ar[1][i];\
	blk[1][i]=ar[0][i]*ar[2][i];\
	}while(++i < col); NUMBLK = 2
#define BLKARRANGE_xpxpx blk[0]=ar[0]; blk[1]=ar[1]; blk[2]=ar[2]; NUMBLK = 3
#define BLKARRANGE_xxppx for(i=0;i<col;i++){blk[0][i]=ar[0][i]*ar[1][i];}\
        blk[1]=ar[2]; NUMBLK = 2


#define BLKARRANGE_xxxx for(i=0;i<col;i++)\
	blk[0][i]=ar[0][i]*ar[1][i]*ar[2][i]*ar[3][i]; NUMBLK = 1
#define BLKARRANGE_xxxpx i=0; do{\
	blk[0][i]=ar[0][i]*ar[1][i]*ar[2][i];\
	blk[1][i]=ar[0][i]*ar[1][i]*ar[3][i];\
	}while(++i < col); NUMBLK = 2
#define BLKARRANGE_xxpxpx i=0; do{\
	blk[0][i]=ar[0][i]*ar[1][i];\
	blk[1][i]=ar[0][i]*ar[2][i];\
	blk[2][i]=ar[0][i]*ar[3][i];\
	}while(++i < col); NUMBLK = 3
#define BLKARRANGE_xpxpxpx blk[0]=ar[0];blk[1]=ar[1];blk[2]=ar[2];blk[3]=ar[3]; NUMBLK = 4
#define BLKARRANGE_xpxxpx i=0; do{\
	blk[0][i]=ar[0][i]*ar[2][i];\
	blk[1][i]=ar[0][i]*ar[3][i];\
	blk[2][i]=ar[1][i]*ar[2][i];\
	blk[3][i]=ar[1][i]*ar[3][i];\
	}while(++i < col); NUMBLK = 4


#define BLKARRANGE_xxxxx for(i=0;i<col;i++)\
	blk[0][i]=ar[0][i]*ar[1][i]*ar[2][i]*ar[3][i]*ar[4][i]; NUMBLK = 1
#define BLKARRANGE_xxxxpx i=0; do{\
	blk[0][i]=ar[0][i]*ar[1][i]*ar[2][i]*ar[3][i];\
	blk[1][i]=ar[0][i]*ar[1][i]*ar[2][i]*ar[4][i];\
	}while(++i < col); NUMBLK = 2
#define BLKARRANGE_xxxpxpx i=0; do{\
	blk[0][i]=ar[0][i]*ar[1][i]*ar[2][i];\
	blk[1][i]=ar[0][i]*ar[1][i]*ar[3][i];\
	blk[2][i]=ar[0][i]*ar[1][i]*ar[4][i];\
	}while(++i < col); NUMBLK = 3
#define BLKARRANGE_xxpxpxpx i=0; do{\
	blk[0][i]=ar[0][i]*ar[1][i];\
	blk[1][i]=ar[0][i]*ar[2][i];\
	blk[2][i]=ar[0][i]*ar[3][i];\
	blk[3][i]=ar[0][i]*ar[4][i];\
	}while(++i < col); NUMBLK = 4
#define BLKARRANGE_xpxpxpxpx blk[0]=ar[0];blk[1]=ar[1];blk[2]=ar[2];\
	blk[3]=ar[3];blk[4]=ar[4]; NUMBLK = 5
#define BLKARRANGE_xxpxxpx i=0; do{\
	blk[0][i]=ar[0][i]*ar[1][i]*ar[3][i];\
	blk[1][i]=ar[0][i]*ar[1][i]*ar[4][i];\
	blk[2][i]=ar[0][i]*ar[2][i]*ar[3][i];\
	blk[3][i]=ar[0][i]*ar[2][i]*ar[4][i];\
	}while(++i < col); NUMBLK = 4
#define BLKARRANGE_xpxpxxpx i=0; do{\
	blk[0][i]=ar[0][i]*ar[3][i];\
	blk[1][i]=ar[0][i]*ar[4][i];\
	blk[2][i]=ar[1][i]*ar[3][i];\
	blk[3][i]=ar[1][i]*ar[4][i];\
	blk[4][i]=ar[2][i]*ar[3][i];\
	blk[5][i]=ar[2][i]*ar[4][i];\
	}while(++i < col); NUMBLK = 6

#define MAKEFUNCTION(RA, UU, FUN1)\
    void ag_##RA (AG){\
    GENERALHANDLE(1);\
    FUN1(ar[0], xn[0], kn[0], col);\
    BLKARRANGE_##UU;\
    MAKE_BigBlock;\
    if (p_needGradient[0] != 0) {\
    GET_DarDnk;\
    COMBINER_##UU;\
    p_output[1] = OBJ##FUN1 * dotProduct(IntGBlock, DGammaDn[0], col);\
    p_output[2] = OBJ##FUN1 * dotProduct(IntGBlock, DGammaDk[0], col);\
    p_output[3] = sum(IntGBlock, col);\
    p_output[4] = -dotProduct(IntGBlock, Data[0], col);\
    p_output[5] = dotProduct(IntGBlock, blk[0], col);}}

MAKEFUNCTION(r,x,r)
MAKEFUNCTION(a,x,a)

#undef MAKEFUNCTION

/*****************************************************************************/
#define MAKEFUNCTION(RA, UU, FUN1, FUN2)\
    void ag_##RA (AG){\
    GENERALHANDLE(2);\
    FUN1(ar[0], xn[0], kn[0], col);\
    FUN2(ar[1], xn[1], kn[1], col);\
    BLKARRANGE_##UU;\
    MAKE_BigBlock;\
    if (p_needGradient[0] != 0) {\
    GET_DarDnk;\
    COMBINER_##UU;\
    p_output[1] = OBJ##FUN1 * dotProduct(IntGBlock, DGammaDn[0], col);\
    p_output[2] = OBJ##FUN2 * dotProduct(IntGBlock, DGammaDn[1], col);\
    p_output[3] = OBJ##FUN1 * dotProduct(IntGBlock, DGammaDk[0], col);\
    p_output[4] = OBJ##FUN2 * dotProduct(IntGBlock, DGammaDk[1], col);\
    p_output[5] = sum(IntGBlock, col);\
    p_output[6] = -dotProduct(IntGBlock, Data[0], col);\
    for(i=0;i<NUMBLK;i++)\
    	p_output[7+i] = dotProduct(IntGBlock, blk[i], col);}}

MAKEFUNCTION( rr,  xx, r, r)
MAKEFUNCTION( ra,  xx, r, a)
MAKEFUNCTION( aa,  xx, a, a)
MAKEFUNCTION(apa, xpx, a, a)

#undef MAKEFUNCTION

/*****************************************************************************/
#define MAKEFUNCTION(RA, UU, FUN1, FUN2, FUN3)\
    void ag_##RA (AG){\
    GENERALHANDLE(3);\
    FUN1(ar[0], xn[0], kn[0], col);\
    FUN2(ar[1], xn[1], kn[1], col);\
    FUN3(ar[2], xn[2], kn[2], col);\
    BLKARRANGE_##UU;\
    MAKE_BigBlock;\
    if (p_needGradient[0] != 0) {\
    GET_DarDnk;\
    COMBINER_##UU;\
    p_output[1] = OBJ##FUN1 * dotProduct(IntGBlock, DGammaDn[0], col);\
    p_output[2] = OBJ##FUN2 * dotProduct(IntGBlock, DGammaDn[1], col);\
    p_output[3] = OBJ##FUN3 * dotProduct(IntGBlock, DGammaDn[2], col);\
    p_output[4] = OBJ##FUN1 * dotProduct(IntGBlock, DGammaDk[0], col);\
    p_output[5] = OBJ##FUN2 * dotProduct(IntGBlock, DGammaDk[1], col);\
    p_output[6] = OBJ##FUN3 * dotProduct(IntGBlock, DGammaDk[2], col);\
    p_output[7] = sum(IntGBlock, col);\
    p_output[8] = -dotProduct(IntGBlock, Data[0], col);\
    for(i=0;i<NUMBLK;i++)\
    	p_output[9+i] = dotProduct(IntGBlock, blk[i], col);}}

MAKEFUNCTION(  rrr,   xxx, r, r, r)
MAKEFUNCTION(  rra,   xxx, r, r, a)
MAKEFUNCTION(  raa,   xxx, r, a, a)
MAKEFUNCTION( rapa,  xxpx, r, a, a)
MAKEFUNCTION(  aaa,   xxx, a, a, a)
MAKEFUNCTION( aapa,  xxpx, a, a, a)
MAKEFUNCTION(apapa, xpxpx, a, a, a)
MAKEFUNCTION(aappa, xxppx, a, a, a)

#undef MAKEFUNCTION

/*****************************************************************************/

#define MAKEFUNCTION(RA, UU, FUN1, FUN2, FUN3, FUN4)\
    void ag_##RA (AG){\
    GENERALHANDLE(4);\
    FUN1(ar[0], xn[0], kn[0], col);\
    FUN2(ar[1], xn[1], kn[1], col);\
    FUN3(ar[2], xn[2], kn[2], col);\
    FUN4(ar[3], xn[3], kn[3], col);\
    BLKARRANGE_##UU;\
    MAKE_BigBlock;\
    if (p_needGradient[0] != 0) {\
    GET_DarDnk;\
    COMBINER_##UU;\
    p_output[1] = OBJ##FUN1 * dotProduct(IntGBlock, DGammaDn[0], col);\
    p_output[2] = OBJ##FUN2 * dotProduct(IntGBlock, DGammaDn[1], col);\
    p_output[3] = OBJ##FUN3 * dotProduct(IntGBlock, DGammaDn[2], col);\
    p_output[4] = OBJ##FUN4 * dotProduct(IntGBlock, DGammaDn[3], col);\
    p_output[5] = OBJ##FUN1 * dotProduct(IntGBlock, DGammaDk[0], col);\
    p_output[6] = OBJ##FUN2 * dotProduct(IntGBlock, DGammaDk[1], col);\
    p_output[7] = OBJ##FUN3 * dotProduct(IntGBlock, DGammaDk[2], col);\
    p_output[8] = OBJ##FUN4 * dotProduct(IntGBlock, DGammaDk[3], col);\
    p_output[9] = sum(IntGBlock, col);\
    p_output[10] = -dotProduct(IntGBlock, Data[0], col);\
    for(i=0;i<NUMBLK;i++)\
    	p_output[11+i] = dotProduct(IntGBlock, blk[i], col);}}

MAKEFUNCTION(   rrrr,    xxxx, r, r, r, r)
MAKEFUNCTION(   rrra,    xxxx, r, r, r, a)
MAKEFUNCTION(   rraa,    xxxx, r, r, a, a)
MAKEFUNCTION(  rrapa,   xxxpx, r, r, a, a)
MAKEFUNCTION(   raaa,    xxxx, r, a, a, a)
MAKEFUNCTION(  raapa,   xxxpx, r, a, a, a)
MAKEFUNCTION( rapapa,  xxpxpx, r, a, a, a)
MAKEFUNCTION(   aaaa,    xxxx, a, a, a, a)
MAKEFUNCTION(  aaapa,   xxxpx, a, a, a, a)
MAKEFUNCTION( aapapa,  xxpxpx, a, a, a, a)
MAKEFUNCTION(apapapa, xpxpxpx, a, a, a, a)
MAKEFUNCTION( apaapa,  xpxxpx, a, a, a, a)

#undef MAKEFUNCTION

/*****************************************************************************/

#define MAKEFUNCTION(RA, UU, FUN1, FUN2, FUN3, FUN4, FUN5)\
    void ag_##RA (AG){\
    GENERALHANDLE(5);\
    FUN1(ar[0], xn[0], kn[0], col);\
    FUN2(ar[1], xn[1], kn[1], col);\
    FUN3(ar[2], xn[2], kn[2], col);\
    FUN4(ar[3], xn[3], kn[3], col);\
    FUN5(ar[4], xn[4], kn[4], col);\
    BLKARRANGE_##UU;\
    MAKE_BigBlock;\
    if (p_needGradient[0] != 0) {\
    GET_DarDnk;\
    COMBINER_##UU;\
    p_output[1]  = OBJ##FUN1 * dotProduct(IntGBlock, DGammaDn[0], col);\
    p_output[2]  = OBJ##FUN2 * dotProduct(IntGBlock, DGammaDn[1], col);\
    p_output[3]  = OBJ##FUN3 * dotProduct(IntGBlock, DGammaDn[2], col);\
    p_output[4]  = OBJ##FUN4 * dotProduct(IntGBlock, DGammaDn[3], col);\
    p_output[5]  = OBJ##FUN5 * dotProduct(IntGBlock, DGammaDn[4], col);\
    p_output[6]  = OBJ##FUN1 * dotProduct(IntGBlock, DGammaDk[0], col);\
    p_output[7]  = OBJ##FUN2 * dotProduct(IntGBlock, DGammaDk[1], col);\
    p_output[8]  = OBJ##FUN3 * dotProduct(IntGBlock, DGammaDk[2], col);\
    p_output[9]  = OBJ##FUN4 * dotProduct(IntGBlock, DGammaDk[3], col);\
    p_output[10] = OBJ##FUN5 * dotProduct(IntGBlock, DGammaDk[4], col);\
    p_output[11] = sum(IntGBlock, col);\
    p_output[12] = -dotProduct(IntGBlock, Data[0], col);\
    for(i=0;i<NUMBLK;i++)\
    	p_output[13+i] = dotProduct(IntGBlock, blk[i], col);}}

MAKEFUNCTION(    rrrrr,     xxxxx, r, r, r, r, r)
MAKEFUNCTION(    rrrra,     xxxxx, r, r, r, r, a)
MAKEFUNCTION(    rrraa,     xxxxx, r, r, r, a, a)
MAKEFUNCTION(   rrrapa,    xxxxpx, r, r, r, a, a)
MAKEFUNCTION(    rraaa,     xxxxx, r, r, a, a, a)
MAKEFUNCTION(   rraapa,    xxxxpx, r, r, a, a, a)
MAKEFUNCTION(  rrapapa,   xxxpxpx, r, r, a, a, a)
MAKEFUNCTION(    raaaa,     xxxxx, r, a, a, a, a)
MAKEFUNCTION(   raaapa,    xxxxpx, r, a, a, a, a)
MAKEFUNCTION(  raapapa,   xxxpxpx, r, a, a, a, a)
MAKEFUNCTION( rapapapa,  xxpxpxpx, r, a, a, a, a)
MAKEFUNCTION(    aaaaa,     xxxxx, a, a, a, a, a)
MAKEFUNCTION(   aaaapa,    xxxxpx, a, a, a, a, a)
MAKEFUNCTION(  aaapapa,   xxxpxpx, a, a, a, a, a)
MAKEFUNCTION( aapapapa,  xxpxpxpx, a, a, a, a, a)
MAKEFUNCTION(apapapapa, xpxpxpxpx, a, a, a, a, a)
MAKEFUNCTION(  rapaapa,   xxpxxpx, r, a, a, a, a)
MAKEFUNCTION(  aapaapa,   xxpxxpx, a, a, a, a, a)
MAKEFUNCTION( apapaapa,  xpxpxxpx, a, a, a, a, a)

#undef MAKEFUNCTION
