#include <math.h>
#include <R.h>

static double activate(double x, double k, double n){
  double temp;
  temp = pow(x, n);
  return(temp / (temp + pow(k, n)));
}

/* void gemc(const double *yin, double *yout, const double *par) */
define(`C', `\
  par[Ipar + eval(dim * 2 + 2 + $1)]')dnl
define(`n', `par[Ipar + $1]')dnl
define(`k', `par[Ipar + eval($1 + dim)]')dnl
define(`GB', `\
  yout[Iout] = par[Ipar + eval(dim * 2)] - par[Ipar + eval(dim * 2 + 1)] * yin[Iout]')dnl
define(`MD', `ifelse(eval($1>0), 1, `MD(eval($1-1)), Iregu$1', Iregu0)')dnl
define(`DEF', ``#''define LOGIC_$1(Iout, `MD(eval(dim - 1))', Ipar))dnl
define(`y', `yin[Iregu$1]')dnl
define(`A', `\
  activate(y($1), k($1), n($1))')dnl
define(`R', `\
  activate(k($1), y($1), n($1))')dnl

define(`dim', 1)dnl
DEF(r) GB + C(0) * R(0)
DEF(a) GB + C(0) * A(0)

define(`dim', 2)dnl
DEF(rr) GB + C(0) * R(0) * R(1)
DEF(ra) GB + C(0) * R(0) * A(1)
DEF(aa) GB + C(0) * A(0) * A(1)
DEF(apa) GB + C(0) * A(0) + C(1) * A(1)

define(`dim', 3)dnl
DEF(rrr) GB + C(0) * R(0) * R(1) * R(2)
DEF(rra) GB + C(0) * R(0) * R(1) * A(2)
DEF(raa) GB + C(0) * R(0) * A(1) * A(2)
DEF(rapa) GB + R(0) * (C(0) * A(1) + C(1) * A(2))
DEF(aaa) GB + C(0) * A(0) * A(1) * A(2)
DEF(aapa) GB + A(0) * (A(1) * C(0) + A(2) * C(1))
DEF(apapa) GB + C(0) * A(0) + C(1) * A(1) + C(2) * A(2)
DEF(aappa) GB + C(0) * A(0) * A(1) + C(1) * A(2)

define(`dim', 4)dnl
DEF(rrrr) GB + C(0) * R(0) * R(1) * R(2) * R(3)
DEF(rrra) GB + C(0) * R(0) * R(1) * R(2) * A(3)
DEF(rraa) GB + C(0) * R(0) * R(1) * A(2) * A(3)
DEF(rrapa) GB + R(0) * R(1) * (C(0) * A(2) + C(1) * A(3))
DEF(raaa) GB + C(0) * R(0) * A(1) * A(2) * A(3)
DEF(raapa) GB + R(0) * A(1) * (C(0) * A(2) + C(1) * A(3))
DEF(rapapa) GB + R(0) * (C(0) * A(1) + C(1) * A(2) + C(2) * A(3))
DEF(aaaa) GB + C(0) * A(0) * A(1) * A(2) * A(3)
DEF(aaapa) GB + A(0) * A(1) * (C(0) * A(2) + C(1) * A(3))
DEF(aapapa) GB + A(0) * (C(0) * A(1) + C(1) * A(2) + C(2) * A(3))
DEF(apapapa) GB + C(0)*A(0) + C(1)*A(1) + C(2)*A(2) + C(3)*A(3)
DEF(apaapa) GB + C(0)*A(0)*A(2) + C(1)*A(0)*A(3) + C(2)*A(1)*A(2) + C(3)*A(1)*A(3)

define(`dim', 5)dnl
DEF(rrrrr) GB + C(0) * R(0) * R(1) * R(2) * R(3) * R(4)
DEF(rrrra) GB + C(0) * R(0) * R(1) * R(2) * R(3) * A(4)
DEF(rrraa) GB + C(0) * R(0) * R(1) * R(2) * A(3) * A(4)
DEF(rrrapa) GB + R(0) * R(1) * R(2) * (C(0) * A(3) + C(1) * A(4))
DEF(rraaa) GB + C(0) * R(0) * R(1) * A(2) * A(3) * A(4)
DEF(rraapa) GB + R(0) * R(1) * A(2) * (C(0) * A(3) + C(1) * A(4))
DEF(rrapapa) GB + R(0) * R(1) * (C(0)*A(2) + C(1)*A(3) + C(2)*A(4))
DEF(raaaa) GB + C(0) * R(0) * A(1) * A(2) * A(3) * A(4)
DEF(raaapa) GB + R(0) * A(1) * A(2) * (C(0) * A(3) + C(1) * A(4))
DEF(raapapa) GB + R(0) * A(1) * (C(0)*A(2) + C(1)*A(3) + C(2)*A(4))
DEF(rapapapa) GB + R(0) * (C(0)*A(1) + C(1)*A(2) + C(2)*A(3) + C(3)*A(4))
DEF(aaaaa) GB + C(0) * A(0) * A(1) * A(2) * A(3) * A(4)
DEF(aaaapa) GB + A(0) * A(1) * A(2) * (C(0) * A(3) + C(1) * A(4))
DEF(aaapapa) GB + A(0) * A(1) * (C(0)*A(2) + C(1)*A(3) + C(2)*A(4))
DEF(aapapapa) GB + A(0) * (C(0)*A(1) + C(1)*A(2) + C(2)*A(3) + C(3)*A(4))
DEF(apapapapa) GB + C(0)*A(0) + C(1)*A(1) + C(2)*A(2) + C(3)*A(3) + C(4)*A(4)
DEF(rapaapa) GB + R(0) * (C(0)*A(1)*A(3) + C(1)*A(1)*A(4) + C(2)*A(2)*A(3) + C(3)*A(2)*A(4))
DEF(aapaapa) GB + A(0) * (C(0)*A(1)*A(3) + C(1)*A(1)*A(4) + C(2)*A(2)*A(3) + C(3)*A(2)*A(4))
DEF(apapaapa) GB + C(0)*A(0)*A(3) + C(1)*A(0)*A(4) + C(2)*A(1)*A(3) + C(3)*A(1)*A(4) + C(4)*A(2)*A(3) + C(5)*A(2)*A(4)
