source("common.R")
load("gxTasks.Rdata.SUPER")
load("parents.Rdata.SUPER")
library(nloptr)
dyn.load("newHS.so")
compRoot <- function(x){# x is the target level
  ## FUNCTION MADE ON FEB 24, 2014 THANKS TO KEVIN MCGOFF.
  ## MODEL: f(gamma, beta) = min_{c} ||x + c - gxM %*% (gamma - beta * x)||^2
  ## TARGET: min f, st. gamma, beta \in their scope each.
  ## THIS IS A QUADRATIC CONVEX MINIMIZATION PROBLEM.
  len.x <- length(x)
  if(USE.EMPIRICAL.PRIOR){
    max.dydt <- max(diff(x) / diff(level.data[, "time"]))
    max.M.dydt.over.y <- max( - diff(x) * 2 / diff(level.data[, "time"]) /
      (x[-1] + x[-len.x]))
    gamma.upper.bound <- GAMMA.FACTOR.UPPER.BOUND * max.dydt
    beta.upper.bound <- BETA.FACTOR.UPPER.BOUND * max.M.dydt.over.y
  }else{
    gamma.upper.bound <- GAMMA.FACTOR.UPPER.BOUND
    beta.upper.bound <- BETA.FACTOR.UPPER.BOUND
  }
  A <- diag(nrow = len.x) - matrix(1/len.x, nrow = len.x, ncol = len.x)
  b <- drop(A %*% x)
  A <- A %*% rbind(c(0,0), gxM %*% cbind(rep(1, length.out = ncol(gxM)), -x))
  fn <- function(u) sum((drop(A %*% u) - b)^2)
  gr <- function(u) 2*drop( t(A) %*% (drop(A %*% u) - b) )
  hs <- function(u) t(A) %*% A
  funPkg <- list(fn = fn, par.upper = c(gamma.upper.bound,
    beta.upper.bound), par.lower = c(0,0))
  par.init <- funPkg$par.upper/2 # CONVEX, ANY INI WORKS.
  opt.prblm <- list(fn = fn, gr = gr,
    par.upper = funPkg$par.upper, par.lower = funPkg$par.lower,
    par.init = par.init, val = funPkg$fn(par.init), info = "")
  repeatStopper <- 0
  repeat{
    repeatStopper <- repeatStopper + 1
    val.record <- opt.prblm$val
    opt.prblm <- optim.COR.SRCH(opt.prblm)
    opt.prblm <- optim.L.BFGS.B(opt.prblm)
    opt.prblm <- optim.LD.SLSQP(opt.prblm)
    opt.prblm <- optim.COR.SRCH(opt.prblm)
    if(val.record - opt.prblm$val < 1e-8) break
    if(repeatStopper > 5) break
  }
  scope <- 1e-4 * (funPkg$par.upper - c(0,0))
  ## THIS SHOULD BE CHANGED WITH THE OTHER 1e-4 IN THIS CODE!!
  num.corners <- sum(((opt.prblm$par.init - c(0,0)) < scope) | ((funPkg$par.upper - opt.prblm$par.init) < scope))
  eig = eigen(hs(x), symmetric = T, only.values = T)$values
  sqr.inv.det <- 1/sqrt(prod(pmax(eig, HESSIAN.SINGVAL.LOWBD)))
  sqr.inv.det.scoped <- sqr.inv.det / (2^num.corners)
  volume <- prod(funPkg$par.upper - c(0,0))
  sqrtLoss <- sqrt(opt.prblm$val / len.x)
  p.L.D <- gen.pld(funPkg = funPkg, opt.par = opt.prblm$par.init)
  pld.Lap.raw <- (2*pi) * sqr.inv.det.scoped * exp(-sqrtLoss^2) / volume
  return(list(
    pld.imptntSamp.raw = p.L.D$pld, pld.imptntSamp = p.L.D$pld,
    pld.prod.raw = p.L.D$const / volume, pld.prod = p.L.D$const / volume,
    pld.Lap.raw = pld.Lap.raw, pld.Lap = pld.Lap.raw,
    eig = eig, sqr.inv.det = sqr.inv.det, sqrtLoss = sqrtLoss,
    volume = volume, num.extrem = num.corners,
    sqr.inv.det.scoped = sqr.inv.det.scoped,
    gamma = opt.prblm$par.init[1], beta = opt.prblm$par.init[2]
  ))
}
tgtFree.tasks <- gen.tgtFree.tasks(tgtFree.sortedRegIndSets)
forms.splited <- lapply(strsplit(tgtFree.tasks[,"forms"], split = ",",
    fixed = T), as.integer)
dims <- unlist(lapply(forms.splited, length)) - 1
num.n.k <- max(NUMBERS.of.COMBINATION)
num.alpha <- max.blk.num.used
k.max <- unlist(lapply(regulator.set, function(a)max(level.data[,a])))
k.min <- unlist(lapply(regulator.set, function(a)min(level.data[,a])))
################################################################################
summProg.set <- list()
#  all output must be data.frame
#  no column should be list
summProg.set$logic <- function(lem.oneTgt){
  #gives: Logic
  col1 <- unlist(lapply(lem.oneTgt, function(a)a$reg.ref.ind))
  col2 <- as.character(unlist(lapply(lem.oneTgt, function(a)
    tgtFree.tasks[a$reg.ref.ind, "exprs"])))
  output <- cbind(col1, col2)
  colnames(output) <- c("ref.ind", "Logic")
  return(output)
}

summProg.set$sqrtLoss <- function(lem.oneTgt){
  # gen: sqrtLoss, pst.sqrtLoss, and plot pst.sqrtLoss as the side effect!
  col1 <- unlist(lapply(lem.oneTgt, function(a)a$opt.val))
  reg.ref.ind <- unlist(lapply(lem.oneTgt, function(a)a$reg.ref.ind))
  col2 <- unlist(lapply(1:length(lem.oneTgt), function(i0){
    #CAUTIOUS! There would be one bug if in future
    #combined regulations are not allowed but their parents
    #are. Like one kills "r(A) * a(B)" but allows "r(A)" and "a(B)".
    p <- parents[[ lem.oneTgt[[i0]]$reg.ref.ind ]]
    if(1 %in% p) return(THE.ROOT$sqrtLoss - col1[i0])
    return(min(col1[reg.ref.ind %in% p]) - col1[i0])
  }))
  col3 <- unlist(lapply(lem.oneTgt, function(i0){
    return(mean( ((i0$predict.curv - level.data[,CURRENT.TARGET])^2)/
      (level.data[,CURRENT.TARGET]) ))
  }))
  output <- cbind(col1, col2, col3)
  colnames(output) <- c("sqrtLoss", "pst.sqrtLoss", "bestChi2")
  ### PLOT ############################################################
  # the.order <- order(col1, decreasing = F)
  # lapply(c(30,100,300,Inf), FUN = plot.plem, loss = col1[the.order],
  #   ploss = col2[the.order], dims = dims[reg.ref.ind][the.order],
  #   target = CURRENT.TARGET)
  #####################################################################
  return(output)
}

summProg.set$timing <- function(lem.oneTgt){
  col1 <- as.double(unlist(lapply(lem.oneTgt, function(a)
    sum(a$running.time[c("user.self", "sys.self", "user.child", "sys.child")]))))
  col2 <- as.double(unlist(lapply(lem.oneTgt, function(a)
    a$running.time["elapsed"])))
  #output <- matrix(col1, ncol = 1); colnames(output) <- "timing"
  output <- cbind(col1, col2);  colnames(output) <- c("user.n.child", "elapsed")
  return(output)
}

summProg.set$pars <- function(lem.oneTgt){
  par.template <- rep("", length.out = 2 * (2 + num.n.k * 2 + num.alpha))
  output <- do.call(rbind, lapply(lem.oneTgt, function(i0){
    the.regs <- forms.splited[[i0$reg.ref.ind]]
    my.dim <- length(the.regs)-1
    my.logic <- the.regs[length(the.regs)]
    the.regs <- sortAndPermut(obj = the.regs[1:my.dim], logicInd = my.logic)
    temp.par <- par.template
    stopifnot(sum(inflation[i0$reg.ref.ind,]) == length(i0$par))
    stopifnot(sum(inflation[i0$reg.ref.ind, num.n.k + (1:num.n.k)]) == length(the.regs))
    temp <- fastTestfunGenerator(Data = level.data, target = CURRENT.TARGET,
      regulator.set = regulator.set[the.regs], logic.ind = my.logic, gxM = gxM)
    temp.par[rep(inflation[i0$reg.ref.ind,], times = 2)] <- c(i0$par,
      (i0$par - temp$par.lower) * 100 / (temp$par.upper - temp$par.lower))
    return(temp.par)
  }))
  temp.cn <- c(paste0("n", 1:num.n.k), paste0("k", 1:num.n.k), "gamma", "beta", paste0("alpha", 1:num.alpha))
  colnames(output) <- c(temp.cn, paste0(temp.cn, ".scale,%"))
  return(output)
}

summProg.set$hessian <- function(lem.oneTgt){
  eps <- 1e-4
  ## THIS SHOULD BE CHANGED WITH THE OTHER 1e-4 IN THIS CODE!!
  output <- do.call(rbind, lapply(lem.oneTgt, function(obj){
    the.regs <- forms.splited[[obj$reg.ref.ind]]
    my.dim <- length(the.regs) - 1
    my.logic <- the.regs[length(the.regs)]
    the.regs <- sortAndPermut(obj = the.regs[1:my.dim], logicInd = my.logic)
    temp <- fastTestfunGenerator(Data = level.data, target = CURRENT.TARGET,
      regulator.set = regulator.set[the.regs], logic.ind = my.logic, gxM = gxM)
    H <- do.call(cbind, lapply(1:length(obj$par), function(i0){
      ei <- 0 * obj$par; ei[i0] = eps
      return((temp$gr(obj$par + ei) - temp$gr(obj$par - ei)) / (2 * eps))
    }))
    H <- (H + t(H)) / 2 / nrow(level.data)
    eig <- eigen(H, symmetric = T, only.values = T)$values
    sqr.inv.det <- 1/sqrt(prod(pmax(eig, HESSIAN.SINGVAL.LOWBD)))
    scope <- (temp$par.upper - temp$par.lower) * eps
    num.corners <- sum(((obj$par - temp$par.lower) < scope) | ((temp$par.upper - obj$par) < scope))
    sqr.inv.det.scoped <- sqr.inv.det / (2^num.corners)
    pld.imptntSamp.raw <- obj$pld
    pld.Lap.raw <- (2*pi)^(length(obj$par)/2) * sqr.inv.det.scoped * exp(-obj$opt.val^2) / obj$volume
    pld.prod.raw <- obj$pld.prd.raw
    return(c(pld.imptntSamp.raw, pld.Lap.raw, pld.prod.raw,
      pld.imptntSamp.raw, pld.Lap.raw, pld.prod.raw,
      pld.Lap.raw/pld.imptntSamp.raw, pld.Lap.raw-pld.imptntSamp.raw,
      eig, rep(NA, length.out = max(NUMBERS.of.COMBINATION) * 2
      + 2 + max.blk.num.used - length(eig)), obj$volume, num.corners, sqr.inv.det,
      sqr.inv.det.scoped))
  }))
  colnames(output) <- c("pld.imptntSamp", "pld.Lap", "pld.prod",
    "pld.imptntSamp.raw", "pld.Lap.raw", "pld.prod.raw", "ratioOfRawpld.Lap.imptntSamp", "diffOfRawpld.Lap.imptntSamp",
    paste0("eig,",1:(max(NUMBERS.of.COMBINATION) * 2
      + 2 + max.blk.num.used)), "volume", "num.extrem", "sqr.inv.det",
      "sqr.inv.det.scoped")
  return(output)
}
# TO DO: TTV, REP, NUM.PAR, HESSIAN,
################################################################################
plot.plem <- function(m.cut, loss, ploss, dims, target){
  setEPS()
  postscript(file = paste0(CURRENT.TARGET, "-", m.cut, ".eps"))
  my.length <- min(m.cut, length(loss))
  my.colors <- c("red", "blue", "yellow", "green", "black")
  x <- 1:my.length # sqrtLoss
  y <- loss[x]
  x.ploss <- lapply(1:5, function(i0)x[dims[x] == i0])
  y.ploss <- lapply(1:5, function(i0)ploss[x][dims[x] == i0])
  x.range <- range(x); y.range <- range(c(y, ploss[x]))
  plot(x = x.range, y = y.range, xlab = paste0(my.colors[NUMBERS.of.COMBINATION],
    ":", NUMBERS.of.COMBINATION, "reg", collapse = ", "),
    main = paste0(CURRENT.TARGET, "#.reg <= ", m.cut), type = "n")
  lines(x = x, y = y, type = "l", col = "black")
  lines(x = x, y = ploss[x], type = "l", col = "red")
  for(i0 in sort(NUMBERS.of.COMBINATION, decreasing = T)){
    lines(x = x.ploss[[i0]], y = y.ploss[[i0]], type = "p",
      cex = 1.7, pch = 20, col = my.colors[i0])
  }
  dev.off()
}
make.ROOT <- function(x, THE.ROOT){
  x <- rbind(x, rep(NA, times = ncol(x)))
  n <- nrow(x)
  if("sqrtLoss"           %in% colnames(x)) x[n, "sqrtLoss"] <- THE.ROOT$sqrtLoss
  if("eig,1"              %in% colnames(x)) x[n, "eig,1"] <- THE.ROOT$eig[1]
  if("eig,2"              %in% colnames(x)) x[n, "eig,2"] <- THE.ROOT$eig[2]
  if("pst.sqrtLoss"       %in% colnames(x)) x[n, "pst.sqrtLoss"] <- Inf
  if("pld.imptntSamp"     %in% colnames(x)) x[n, "pld.imptntSamp"] <- THE.ROOT$pld.imptntSamp
  if("pld.Lap"            %in% colnames(x)) x[n, "pld.Lap"] <- THE.ROOT$pld.Lap
  if("pld.prod"           %in% colnames(x)) x[n, "pld.prod"] <- THE.ROOT$pld.prod
  if("pld.imptntSamp.raw" %in% colnames(x)) x[n, "pld.imptntSamp.raw"] <- THE.ROOT$pld.imptntSamp.raw
  if("pld.Lap.raw"        %in% colnames(x)) x[n, "pld.Lap.raw"] <- THE.ROOT$pld.Lap.raw
  if("pld.prod.raw"       %in% colnames(x)) x[n, "pld.prod.raw"] <- THE.ROOT$pld.prod.raw
  if("volume"             %in% colnames(x)) x[n, "volume"] <- THE.ROOT$volume
  if("Logic"              %in% colnames(x)) x[n, "Logic"] <- "ROOT"
  if("ref.ind"            %in% colnames(x)) x[n, "ref.ind"] <- 1
  if("num.extrem"         %in% colnames(x)) x[n, "num.extrem"] <- THE.ROOT$num.extrem
  if("sqr.inv.det"        %in% colnames(x)) x[n, "sqr.inv.det"] <- THE.ROOT$sqr.inv.det
  if("sqr.inv.det.scoped" %in% colnames(x)) x[n, "sqr.inv.det.scoped"] <- THE.ROOT$sqr.inv.det.scoped
  if("gamma"              %in% colnames(x)) x[n, "gamma"] <- THE.ROOT$gamma
  if("beta"               %in% colnames(x)) x[n, "beta"] <- THE.ROOT$beta
  if("user.n.child"       %in% colnames(x)) x[n, "user.n.child"] <- NA
  if("elapsed"            %in% colnames(x)) x[n, "elapsed"] <- NA
  if("pld.Lap"            %in% colnames(x)) x[n, "pld.Lap"] <- 0
  for(i in 1:10){
    item <- paste0("n", i)
    if(item %in% colnames(x)) x[n, item] <- ""
    item <- paste0("k", i)
    if(item %in% colnames(x)) x[n, item] <- ""
    item <- paste0("k.scale,%", i)
    if(item %in% colnames(x)) x[n, item] <- NA
    item <- paste0("alpha", i)
    if(item %in% colnames(x)) x[n, item] <- ""
  }
  return(x)
}

#"logic", "sqrtLoss","hessian", "timing", "pars"
request.test <- c("logic", "sqrtLoss", "hessian", "timing", "pars")
for(nm in target.set){
  CURRENT.TARGET <- nm
  lem.oneTgt <- NULL; rm(lem.oneTgt)
  load(paste0("lem.", nm, ".SUPER"))
  THE.ROOT <- compRoot(level.data[,nm])
  output <- make.ROOT(do.call(cbind, lapply(request.test, function(the.fun){
    as.data.frame(summProg.set[[the.fun]](lem.oneTgt), stringsAsFactors = F)
    })),# one may remove the make.ROOT coat if ROOT is not necessary.
    THE.ROOT = THE.ROOT)
  output[ ,"pld.imptntSamp"] <- output[ ,"pld.imptntSamp"] / sum(output[ ,"pld.imptntSamp"])
  output[ ,"pld.Lap"] <- output[ ,"pld.Lap"] / sum(output[ ,"pld.Lap"])
  output[ ,"pld.prod"] <- output[ ,"pld.prod"] / sum(output[ ,"pld.prod"])
  pld <- output[ ,SORTACCORDINGTO]
  reg.ref.ind <- as.integer(output[,"ref.ind"])
  pld.raw <- output[ ,paste0(SORTACCORDINGTO, ".raw")]
  save(pld, reg.ref.ind, pld.raw, tgtFree.tasks, file = paste0("lem.", CURRENT.TARGET, ".pld"))
  the.order <- order(output[ ,SORTACCORDINGTO], decreasing = T)
  write.table(output[the.order,, drop = F], file = paste0(nm, ".txt"), quote = F,
    sep = "\t", col.names = T, row.names = F); rm(lem.oneTgt)
}
#system('echo "$PWD done! Go handle it!" | mailx -s "make.excel $(date)" xg20@stat.duke.edu')
