### GLOBAL PARAMETERS, DO NOT CHANGE.
source("basic.settings.R")
gxMAXIT <- 3000
TASKS.MAX.NUMBER <- 100
NUM.LOGICS <- c(2, 5, 18, 52, 203)
COMMON.RAND.SEED <- 12345
if(SORTACCORDINGTO == "pld.imptntSamp"){
  IMPORTANT.SAMPLING.SAMPSIZE <- 10000
  IMPORTANT.SAMPLING.DIVIDE <- 1000
}else{
  IMPORTANT.SAMPLING.SAMPSIZE <- 1
  IMPORTANT.SAMPLING.DIVIDE <- 1
}
if(USE.EMPIRICAL.PRIOR){
  GAMMA.FACTOR.UPPER.BOUND <- 0.03
  BETA.FACTOR.UPPER.BOUND <- 2
  ALPHA.FACTOR.UPPER.BOUND <- 10
}else{
  GAMMA.FACTOR.UPPER.BOUND <- 0.3 * LEVEL.BOX.SIZE / TIME.BOX.SIZE
  BETA.FACTOR.UPPER.BOUND <- 1 * 100 / TIME.BOX.SIZE
  ALPHA.FACTOR.UPPER.BOUND <- 100 * LEVEL.BOX.SIZE / TIME.BOX.SIZE
}
################################################################################
### LOADING DATA
source("permu.R")
temp <- list.files(pattern = "\\.DATA$"); stopifnot(length(temp) == 1)
load(temp)
myFolder.name <- sub(pattern = "\\.DATA$", replacement = "", x = temp, fixed = F)
################################################################################
level.data <- get(myFolder.name); rm(list = myFolder.name)
stopifnot(all(level.data[,-1] > 0))
level.data[,"time"] <- level.data[,"time"] - min(level.data[,"time"])
sorted.names <- sort(colnames(level.data)[-1], decreasing = F)
stopifnot(all(c("time",sorted.names) == colnames(level.data)))
target.set <- sorted.names
regulator.set <- sorted.names
level.max <- unlist(lapply(sorted.names, function(a)max(level.data[,a])))
level.min <- unlist(lapply(sorted.names, function(a)min(level.data[,a])))
names(level.max) <- names(level.min) <- sorted.names
################################################################################

gen.tgtFree.sortedRegIndSets <- function(){
  return(do.call(c, lapply(NUMBERS.of.COMBINATION, function(i0){
    combn(x = 1:length(regulator.set), m = i0, simplify = F,
      FUN = sort, decreasing = F)
  })))
}

gen.tgtFree.tasks <- function(tgtFree.sortedRegIndSets){
  forms <- c("0", unlist(lapply(tgtFree.sortedRegIndSets, function(reg.set){
    paste(paste0(reg.set, collapse = ","), 1:(NUM.LOGICS[length(reg.set)]), sep = ",")
  })))
  exprs <- c("ROOT", unlist(lapply(tgtFree.sortedRegIndSets, function(reg.set){
    unlist(lapply(1:(NUM.LOGICS[length(reg.set)]), function(i0){
      return(get.expr(vars.unSorted = regulator.set[reg.set], logicInd = i0))
    }))
  })))
  return(cbind(forms, exprs))
}

gen.parents <- function(tgtFree.tasks){
  Ind <- nrow(tgtFree.tasks)
  output <- list(); length(output) <- Ind
  splited <- lapply(strsplit(tgtFree.tasks[,"forms"], split = ",", fixed = T), as.integer)
  num.regs <- -1 + unlist(lapply(splited, FUN = length))
  output[num.regs <= 1] <- 1
  output[num.regs >= 2] <- lapply((1:Ind)[num.regs >= 2], function(i0){
    #reg.sorted <- as.integer(strsplit(tgtFree.tasks[i0,"forms"],
    #  split = ",", fixed = T)[[1]])
    len <- length(splited[[i0]])
    logic.ind <- splited[[i0]][len]
    parent.M.column <- parent.M[[num.regs[i0]]][,logic.ind]
    reg.sorted <- splited[[i0]][-len]
    parents <- unlist(lapply(1:(num.regs[i0]), function(i1){
      paste0(c(reg.sorted[-i1], parent.M.column[i1]), collapse = ",")
    }))
    return(which(tgtFree.tasks[,"forms"] %in% parents))#this changes some order.
  })
  return(output)
}
################################################################################
gen.mask <- function(tgtFree.tasks){
  global.badRegs <- if(USE.BLACKLIST) c(# data from Anastasia "1118"
  #modeling_meeting/bio_data/yeastcellcycle_info/yeast_genes_of_interest_20131118.txt
  "a(ASH1)", "a(SFG1)", "a(NRM1)", "a(WHI5)", "a(YHP1)", "a(YOX1)", "a(DIG1)",
  "a(DIG2)", "a(GAL80)", "a(HIR2)", "a(IXR1)", "a(MIG1)", "a(RGM1)", "a(SKO1)",
  "a(SPT21)", "a(SUM1)", "a(TUP1)", "a(UME6)", "a(WTM1)", "a(WTM2)", "a(XBP1)",
  "r(ACE2)", "r(HCM1)", "r(MBP1)", "r(NDD1)", "r(PLM2)", "r(SWI4)", "r(SWI5)",
  "r(SWI6)", "r(TOS4)", "r(ADR1)", "r(FHL1)", "r(ARR1)", "r(CST6)", "r(GAT1)",
  "r(GLN3)", "r(HAP1)", "r(HAP2)", "r(HAP5)", "r(KAR4)", "r(MET4)", "r(MGA2)",
  "r(MSN2)", "r(NOT3)", "r(PHD1)", "r(PHO2)", "r(PUT3)", "r(RDS2)", "r(REB1)",
  "r(RLM1)", "r(SFP1)", "r(SPT23)", "r(STB5)", "r(TAF2)", "r(TEC1)", "r(UPC2)",
  "r(YAP1)", "r(YIL154C)", "a(CDC20)", "a(CIN8)", "a(CLB2)", "a(CLN2)",
  "a(CTS1)", "a(KIN3)", "a(KIP1)", "a(MCM3)", "a(PCL1)", "a(RNR1)", "a(SIC1)",
  "r(CDC20)", "r(CIN8)", "r(CLB2)", "r(CLN2)", "r(CTS1)", "r(KIN3)",
  "r(KIP1)", "r(MCM3)", "r(PCL1)", "r(RNR1)", "r(SIC1)") else NULL
  global.badRegs <- c(global.badRegs, "ROOT")
  temp <- lapply(global.badRegs, function(i0){
    grepl(pattern = i0, x = tgtFree.tasks[,"exprs"], fixed = T)
  })
  global.crit1 <- T
  for(i in 1:length(global.badRegs)){
    global.crit1 <- global.crit1 & (!temp[[i]])
  }
  mask <- lapply(1:length(target.set), function(i0)which(global.crit1))
  return(mask)
}
max.blk.num.used <- c(1,2,3,4,6)[max(NUMBERS.of.COMBINATION)]

### FUNCTIONS BELOW NEED dyn.load("newHS.so") AND library(nloptr)
fastTestfunGenerator <- function(Data, target, regulator.set, logic.ind, gxM){
  # numOfRegs    max#logic      #    3           18
  #         1            2      #    4           52
  #         2            5      #    5          203
  #  IT IS A GOOD HABIT TO EXECUTE EVERY ARGUMENT WHEN WRITING A
  #  FUNCTION WHICH OUTPUTS FUNCTIONS.
  Data; target; regulator.set; logic.ind; gxM
  numOfRegs <- length(regulator.set)
  func.pointer <- getNativeSymbolInfo(name = paste0("ag_",
    get.form.name(numOfRegs = numOfRegs, logicInd = logic.ind)),
    PACKAGE = "newHS")$address

  stopifnot(typeof(Data) == "double")
  stopifnot(typeof(gxM) == "double")

  var.list <- sortAndPermut(obj = regulator.set, logicInd = logic.ind)
  Data.use <- as.double(Data[,c(target, var.list)])
  Rrow <- as.integer(nrow(Data)); stopifnot(Rrow >= 2)
  expr <- get.expr(vars.unSorted = var.list, logicInd = logic.ind)

  numOfAlphas.4code <- get.numOfAlphas.4code(numOfRegs = numOfRegs,
    logicInd = logic.ind)
  par.lower <- c(rep(1, times = numOfRegs),
    pmax(0.001, rep(K.FACTOR.LOWER.BOUND, times = length(var.list))),
    rep(0, times = 2 + numOfAlphas.4code))
  if(USE.EMPIRICAL.PRIOR){
    max.dydt <- max(diff(Data[, target]) / diff(Data[, "time"]))
    max.M.dydt.over.y <- max( - diff(Data[, target]) * 2 / diff(Data[, "time"]) /
      (Data[-1, target] + Data[-nrow(Data), target]))
    par.upper <- c(rep(10, times = numOfRegs),
      rep(K.FACTOR.UPPER.BOUND, times = length(var.list)),
      GAMMA.FACTOR.UPPER.BOUND * max.dydt,
      BETA.FACTOR.UPPER.BOUND * max.M.dydt.over.y,
      rep(ALPHA.FACTOR.UPPER.BOUND * max.dydt, times = numOfAlphas.4code))
  }else{
    par.upper <- c(rep(10, times = numOfRegs),
      rep(K.FACTOR.UPPER.BOUND, times = length(var.list)),
      GAMMA.FACTOR.UPPER.BOUND,
      BETA.FACTOR.UPPER.BOUND,
      rep(ALPHA.FACTOR.UPPER.BOUND, times = numOfAlphas.4code))
  }
  gr.output.ind <- 2:(3 + 2 * numOfRegs + numOfAlphas.4code)
  return(list(
    fn = function(par){
      return(.C(func.pointer,
        Data = Data.use,
        Rrow = Rrow,
        needGradient = 0L,
        par = as.double(par),
        workSpace = double(40 * Rrow),
        output = double(1), #5+5+5+2+1
        gxM = gxM,
	target.predict = double(Rrow),
        DUP = F
        )$output[1])
      },
    slam.fn = function(par){
      return(.C(func.pointer,
        Data = Data.use,
        Rrow = Rrow,
        needGradient = 0L,
        par = as.double(par),
        workSpace = double(40 * Rrow),
        output = double(1), #5+5+5+2+1
        gxM = gxM,
	target.predict = double(Rrow),
        DUP = F
        )[c("output", "target.predict")])
      },
    gr = function(par){
      return(.C(func.pointer,
        Data = Data.use,
        Rrow = Rrow,
        needGradient = 1L,
        par = as.double(par),
        workSpace = double(40 * Rrow),
        output = double(19), #5+5+5+2+1 + 1
        gxM = gxM,
	target.predict = double(Rrow),
        DUP = F
      )$output[gr.output.ind])
      },
    expr = expr, par.lower = par.lower, par.upper = par.upper, var.list = var.list))
}

gxGetInt <- function(t){
  qdrt <- c(unlist(lapply(1:(length(t) - 1), FUN = function(i){
    return(seq(t[i], t[i+1], length = 4)[-4]) })), t[length(t)])
  E <- diag(nrow = length(t))
  gxint <- function(i){
    g <- spline(x = t, y = E[ ,i], method = "natural", xout = qdrt)$y
    h <- rep(0, length = length(t) - 1)
    h[1] <- (t[2] - t[1]) / 8 * (g[1] + g[4] + 3 * (g[2] + g[3]))
    for(i in 2:length(h)){
      i3 <- 3 * i
      h[i] <- h[i-1] + (t[i+1] - t[i]) / 8  * (g[i3 - 2] + g[i3 + 1] + 3 * (g[i3 - 1] + g[i3]))
    }
    return(h)
  }
  return(do.call(cbind, lapply(1:length(t), FUN = gxint)))
}
gxGetInt2 <- function(t){
  # LINEAR INTERPOLATION
  b <- diag(diff(t), nrow = length(t) - 1)
  a <- rep(0, times = nrow(b))
  b <- (cbind(b,a) + cbind(a,b))/2
  return(apply(b,2,cumsum))
}
#gxM <- gxGetInt(level.data[,"time"])
gxM <- gxGetInt2(level.data[,"time"])
rm(gxGetInt); rm(gxGetInt2)

gen.pld <- function(funPkg, opt.par, num.samp = IMPORTANT.SAMPLING.SAMPSIZE){
  the.dim <- length(funPkg$par.upper)
  opt.val <- funPkg$fn(opt.par)
  deploy <- function(a, b, divided, resolution){
    R <- 1/(resolution^(1/divided))
    fac <- (b-a) / (1 - 1/resolution)
    return(a + fac - R^(0:divided) * fac)
  }
  deploy.c <- function(a, p, b, divided = IMPORTANT.SAMPLING.DIVIDE, resolution = 200000){
    return(unique(pmax(a, pmin(b, cummax(c(deploy(a, p, divided, resolution),
      rev(deploy(b, p, divided, resolution))[-1]))))))
  }
  pi.meshes <- Map(deploy.c, funPkg$par.lower, opt.par, funPkg$par.upper)
  funs <- lapply(1:the.dim, function(i){
    i; opt.par; return(Vectorize(function(t){opt.par[i] <- t;
      return(funPkg$fn(opt.par))
  }))}) # KEEP THE ORIGINAL FORM OF FN!
  coo.intv.probs <- lapply(1:the.dim, function(i){
    y <- exp(pmin(0, (opt.val - funs[[i]](pi.meshes[[i]]))) / nrow(level.data))
    return((y[-1] + y[-length(y)]) * diff(pi.meshes[[i]]))
  })
  the.C <- prod(unlist(lapply(coo.intv.probs, FUN = sum))/2)
  the.volume <- prod(funPkg$par.upper-funPkg$par.lower)
  pars <- do.call(cbind, lapply(1:the.dim, function(i){
    samp.ind <- sample.int(length(coo.intv.probs[[i]]), size = num.samp,
      replace = T, prob = coo.intv.probs[[i]])
    samp.t <- pi.meshes[[i]][samp.ind] + (pi.meshes[[i]][samp.ind+1] -
      pi.meshes[[i]][samp.ind]) * runif(length(samp.ind))
    return(samp.t)
  }))
  l.values <- pmax(opt.val, apply(pars, 1, funPkg$fn))
  pre.pld <- exp((Reduce("+", lapply(1:the.dim, function(i){
    return(funs[[i]](pars[ ,i]) - opt.val)
  })) - l.values) / nrow(level.data))
  if(sum(!is.finite(pre.pld)) > max(10, num.samp/10)) warning("gen.pld manyInfinitiesPleasePayAttention")
  pre.pld <- pre.pld[is.finite(pre.pld)]; if(length(pre.pld) == 0) pre.pld <- 0
  pld <- mean(pre.pld) * the.C / the.volume
  return(list(pld=pld, const = the.C, volume = the.volume))
}
################################################################################
# optimization tools
optim.L.BFGS.B <- function(pb){
  optimed <- optim(par = pb$par.init, fn = pb$fn, gr = pb$gr,
    method = "L-BFGS-B", lower = pb$par.lower, upper = pb$par.upper,
    control = list(maxit = gxMAXIT, lmm = 20, factr = 1e4))
  pb$info <- paste(pb$info, "|", optimed$message, optimed$convergence, "cOuNtS:",
    paste0(optimed$counts, collapse = ", "), sep = ", ")
  pb$par.init <- pmin(pb$par.upper, pmax(pb$par.lower, optimed$par))
  pb$val <- optimed$value
  return(pb)
}
optim.LD.SLSQP <- function(pb){
  optimed <- nloptr(x0 = pb$par.init, eval_f = pb$fn, eval_grad_f = pb$gr,
    lb = pb$par.lower, ub = pb$par.upper,
    opts = list(algorithm = "NLOPT_LD_SLSQP", xtol_rel = 1e-5, maxeval = gxMAXIT))
  pb$info <- paste0(pb$info, "|", optimed$message, ",", optimed$iterations)
  pb$par.init <- pmin(pb$par.upper, pmax(pb$par.lower, optimed$solution))
  pb$val <- optimed$objective
  return(pb)
}
optim.COR.SRCH <- function(pb, division = 100){
  par.record <- pb$par.init
  val.record <- pb$val
  this.info <- ""
  for(k in 1:length(pb$par.init)){
    grids <- seq(pb$par.lower[k], pb$par.upper[k], length.out = division)
    vals <- mapply(function(t){
      temp.par <- pb$par.init
      temp.par[k] <- t
      return(pb$fn(temp.par))
    }, grids)
    if(min(vals) < val.record){
      val.record <- min(vals)
      par.record <- pb$par.init
      par.record[k] <- grids[which(vals == val.record)[1]]
      this.info <- "*"
    }
  }
  pb$info <- paste0(pb$info, "|", this.info)
  if(this.info == "*"){
    pb$par.init <- pmin(pb$par.upper, pmax(pb$par.lower, par.record))
    pb$val <- pb$fn(pb$par.init)
  }
  return(pb)
}
