# DanLing
# Copyright (C) 2022-Present  DanLing

# This file is part of DanLing.

# DanLing is free software: you can redistribute it and/or modify
# it under the terms of the following licenses:
# - The Unlicense
# - GNU Affero General Public License v3.0 or later
# - GNU General Public License v2.0 or later
# - BSD 4-Clause "Original" or "Old" License
# - MIT License
# - Apache License 2.0

# DanLing is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
# See the LICENSE file for more details.

import torch
from torch import optim

from danling.optim import LRScheduler

# fmt: off
LR_LINEAR_NUMERICAL_100 = [0.198, 0.392, 0.582, 0.768, 0.95, 0.9401, 0.9301, 0.9201, 0.9101, 0.9001, 0.8901, 0.8801, 0.8701, 0.8601, 0.8501, 0.8402, 0.8302, 0.8202, 0.8102, 0.8002, 0.7902, 0.7802, 0.7702, 0.7602, 0.7502, 0.7403, 0.7303, 0.7203, 0.7103, 0.7003, 0.6903, 0.6803, 0.6703, 0.6603, 0.6503, 0.6404, 0.6304, 0.6204, 0.6104, 0.6004, 0.5904, 0.5804, 0.5704, 0.5604, 0.5504, 0.5405, 0.5305, 0.5205, 0.5105, 0.5005, 0.4905, 0.4805, 0.4705, 0.4605, 0.4505, 0.4406, 0.4306, 0.4206, 0.4106, 0.4006, 0.3906, 0.3806, 0.3706, 0.3606, 0.3506, 0.3407, 0.3307, 0.3207, 0.3107, 0.3007, 0.2907, 0.2807, 0.2707, 0.2607, 0.2507, 0.2408, 0.2308, 0.2208, 0.2108, 0.2008, 0.1813, 0.1627, 0.1452, 0.1287, 0.1131, 0.0986, 0.0851, 0.0725, 0.061, 0.0505, 0.0409, 0.0324, 0.0248, 0.0183, 0.0127, 0.0082, 0.0046, 0.0021, 0.0005, 0.0]  # noqa
LR_LINEAR_PERCENTILE_100 = [0.1867, 0.3484, 0.4877, 0.6069, 0.7079, 0.6607, 0.6166, 0.5754, 0.537, 0.5012, 0.4677, 0.4365, 0.4074, 0.3802, 0.3548, 0.3311, 0.309, 0.2884, 0.2692, 0.2512, 0.2344, 0.2188, 0.2042, 0.1905, 0.1778, 0.166, 0.1549, 0.1445, 0.1349, 0.1259, 0.1175, 0.1096, 0.1023, 0.0955, 0.0891, 0.0832, 0.0776, 0.0724, 0.0676, 0.0631, 0.0589, 0.055, 0.0513, 0.0479, 0.0447, 0.0417, 0.0389, 0.0363, 0.0339, 0.0316, 0.0295, 0.0275, 0.0257, 0.024, 0.0224, 0.0209, 0.0195, 0.0182, 0.017, 0.0158, 0.0148, 0.0138, 0.0129, 0.012, 0.0112, 0.0105, 0.0098, 0.0091, 0.0085, 0.0079, 0.0074, 0.0069, 0.0065, 0.006, 0.0056, 0.0052, 0.0049, 0.0046, 0.0043, 0.004, 0.0035, 0.0031, 0.0028, 0.0024, 0.0021, 0.0018, 0.0016, 0.0014, 0.0012, 0.001, 0.0008, 0.0007, 0.0006, 0.0005, 0.0004, 0.0003, 0.0002, 0.0001, 0.0001, 0.0]  # noqa
LR_COSINE_NUMERICAL_100 = [0.2, 0.3996, 0.5987, 0.7968, 0.9939, 0.9912, 0.988, 0.9843, 0.9802, 0.9756, 0.9705, 0.9649, 0.9589, 0.9525, 0.9456, 0.9382, 0.9304, 0.9222, 0.9136, 0.9046, 0.8952, 0.8854, 0.8752, 0.8646, 0.8537, 0.8424, 0.8308, 0.8189, 0.8066, 0.7941, 0.7813, 0.7681, 0.7548, 0.7411, 0.7273, 0.7132, 0.6989, 0.6844, 0.6697, 0.6549, 0.6399, 0.6247, 0.6095, 0.5941, 0.5786, 0.5631, 0.5475, 0.5319, 0.5162, 0.5005, 0.4848, 0.4691, 0.4535, 0.4379, 0.4224, 0.4069, 0.3915, 0.3763, 0.3611, 0.3461, 0.3313, 0.3166, 0.3021, 0.2878, 0.2737, 0.2599, 0.2462, 0.2329, 0.2197, 0.2069, 0.1944, 0.1821, 0.1702, 0.1586, 0.1473, 0.1364, 0.1258, 0.1156, 0.1058, 0.0964, 0.083, 0.0709, 0.06, 0.0502, 0.0416, 0.034, 0.0274, 0.0216, 0.0168, 0.0127, 0.0094, 0.0067, 0.0046, 0.003, 0.0018, 0.001, 0.0005, 0.0002, 0.0001, 0.0]  # noqa
LR_COSINE_PERCENTILE_100 = [0.1997, 0.3973, 0.5909, 0.7785, 0.9584, 0.9407, 0.9202, 0.8972, 0.8718, 0.8445, 0.8153, 0.7846, 0.7527, 0.7198, 0.6863, 0.6523, 0.6182, 0.5841, 0.5503, 0.517, 0.4844, 0.4527, 0.4219, 0.3922, 0.3636, 0.3364, 0.3104, 0.2858, 0.2626, 0.2408, 0.2204, 0.2013, 0.1835, 0.167, 0.1517, 0.1376, 0.1247, 0.1128, 0.1019, 0.0919, 0.0829, 0.0747, 0.0672, 0.0604, 0.0543, 0.0488, 0.0438, 0.0393, 0.0352, 0.0316, 0.0284, 0.0255, 0.0228, 0.0205, 0.0184, 0.0166, 0.0149, 0.0134, 0.0121, 0.0109, 0.0098, 0.0089, 0.008, 0.0073, 0.0066, 0.006, 0.0055, 0.005, 0.0045, 0.0042, 0.0038, 0.0035, 0.0032, 0.003, 0.0028, 0.0026, 0.0024, 0.0022, 0.0021, 0.0019, 0.0017, 0.0015, 0.0014, 0.0012, 0.0011, 0.001, 0.0009, 0.0008, 0.0007, 0.0006, 0.0005, 0.0004, 0.0004, 0.0003, 0.0003, 0.0002, 0.0002, 0.0001, 0.0001, 0.0]  # noqa
LR_CONSTANT_100 = [0.2, 0.4, 0.6, 0.8, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 0.95, 0.9, 0.85, 0.8, 0.75, 0.7, 0.65, 0.6, 0.55, 0.5, 0.45, 0.4, 0.35, 0.3, 0.25, 0.2, 0.15, 0.1, 0.05, 0.0]  # noqa
# fmt: on


class Test:
    optimizer = optim.SGD([{"params": torch.tensor([0])}], lr=1, momentum=0.9)

    def _get_lrs(self, method, scaling, total_steps: int = 100, final_lr_ratio: float = 0.001):
        lrs = []
        scheduler = LRScheduler(
            self.optimizer,
            total_steps=total_steps,
            final_lr_ratio=final_lr_ratio,
            method=method,
            scaling=scaling,
        )
        for _ in range(100):
            lrs.append(scheduler.get_lr()[0])
            scheduler.step()
        return [round(lr, 4) for lr in lrs]

    def test_cosine(self):
        assert self._get_lrs("cosine", "percentile") == LR_COSINE_PERCENTILE_100
        assert self._get_lrs("cosine", "numerical") == LR_COSINE_NUMERICAL_100

    def test_linear(self):
        assert self._get_lrs("linear", "percentile") == LR_LINEAR_PERCENTILE_100
        assert self._get_lrs("linear", "numerical") == LR_LINEAR_NUMERICAL_100

    def test_constant(self):
        assert self._get_lrs("constant", "percentile") == LR_CONSTANT_100
        assert self._get_lrs("constant", "numerical") == LR_CONSTANT_100
