# OpenCV with Python Blueprints

This repository contains all up-to-date source code for the following book:

> M. Beyeler (2015). "OpenCV with Python Blueprints: Design and develop advanced computer vision projects using OpenCV
> with Python". Packt Publishing Ltd., London, England, 230 pages, ISBN 978-178528269-0.

All code was tested with OpenCV 2.4.9 and Python 2.7 on Ubuntu 14.04, and is available from:
https://github.com/mbeyeler/opencv-python-blueprints.

## Software Requirements
All projects can run on Windows, Mac, or Linux, and require the following software packages:
* OpenCV 2.4.9 or later: Recent 32-bit and 64-bit versions as well as installation instructions are available at
http://opencv.org/downloads.html. Platform-specific installation instructions can be found at
http://docs.opencv.org/doc/tutorials/introduction/table_of_content_introduction/table_of_content_introduction.html.
* Python 2.7 or later: Recent 32-bit and 64-bit installers are available at https://www.python.org/downloads. The
installation instructions can be found at https://wiki.python.org/moin/BeginnersGuide/Download.
* NumPy 1.9.2 or later: This package for scientific computing officially comes in 32-bit format only, and can be
obtained from http://www.scipy.org/scipylib/download.html. The installation instructions can be found at 
http://www.scipy.org/scipylib/building/index.html#building.
* wxPython 2.8 or later: This GUI programming toolkit can be obtained from http://www.wxpython.org/download.php.
Its installation instructions are given at http://wxpython.org/builddoc.php.

In addition, some chapters require the following free Python modules:
* SciPy 0.16.0 or later (Chapter 1): This scientific Python library officially comes in 32-bit only, and can be obtained
from http://www.scipy.org/scipylib/download.html. The installation instructions can be found at
http://www.scipy.org/scipylib/building/index.html#building.
* matplotlib 1.4.3 or later (Chapters 4 to 7): This 2D plotting library can be obtained from
http://matplotlib.org/downloads.html. Its installation instructions can be found by going to
http://matplotlib.org/faq/installing_faq.html#how-to-install.
* libfreenect 0.5.2 or later (Chapter 2): The libfreenect module by the OpenKinect project (http://www.openkinect.org)
provides drivers and libraries for the Microsoft Kinect hardware, and can be obtained from
https://github.com/OpenKinect/libfreenect. Its installation instructions can be found at
http://openkinect.org/wiki/Getting_Started.

Furthermore, the use of iPython (http://ipython.org/install.html) is highly recommended as it provides a flexible,
interactive console interface.

## License
The software is released under the GNU General Public License (GPL), which is the most commonly used free software
license according to Wikipedia. GPL allows for commercial use, distribution, modification, patent use, and private use.

The GPL is a copyleft license, which means that derived works can only be distributed under the same license terms.
For more information, please see the license file.