# Functional Test

The purpose of this functional test is to ensure that all combinations of software are capable of running without compatibility issues. I intend to employ this functional test between updates to Rocketchip's software to identify possible bugs in the software or software intercompatibiity problems. 

## Test Data Set

This functional test uses a small set of synthetic data, as the purpose of the test is not to assess biological outputs, but rather the ability of the tools to coherently work together. The sequence was generated by `seq_data/datasynth`, a program written by Alan Zhang and Ian Korf to model ChIP-seq data. A CSV file, `seq_data/to_generate.csv`, was made that contained the parameters for each generated set of data. `seq_data/generate.py` reads in `seq_data/to_generate.csv` and generates the ChIP-seq data using the specified parameters using `seq_data/datasynth`. This creates a log, `seq_data/log` that documents each command used in datasynth. Upon generation and completion, we packaged it into `seqdata.tar.gz` for distrubution and storage purposes. The data was generated by running the following:

```
python3 generate.py ./datasynth 2> log
```

If you are interested in obtaining or using this data, you may do so by creating a directory called `seq_data/` and running the following to download and unzip `seqdata.tar.gz`:

```
wget https://data.cyverse.org/dav-anon/iplant/home/vhaghani26/Rocketchip_Data/seqdata.tar.gz
tar -xvzf seqdata.tar.gz
mv seqdata/* .
rm -rf seqdata/
```

Once you have done so, run the following to organize the data into the appropriate folders:

```
mkdir paired_broad paired_narrow single_broad single_narrow

for dir in paired_broad_*; do
    new_name="test_$(echo "$dir" | sed 's/paired_broad_//')"
    mv "$dir" "paired_broad/$new_name"
done

for dir in paired_narrow_*; do
    new_name="test_$(echo "$dir" | sed 's/paired_narrow_//')"
    mv "$dir" "paired_narrow/$new_name"
done

for dir in single_broad_*; do
    new_name="test_$(echo "$dir" | sed 's/single_broad_//')"
    mv "$dir" "single_broad/$new_name"
done

for dir in single_narrow_*; do
    new_name="test_$(echo "$dir" | sed 's/single_narrow_//')"
    mv "$dir" "single_narrow/$new_name"
done
```

## Running the Test

Go back to the `functional_test/` directory and open `functional_test.py` in a text editor of your choice. In the "Import Modules" section, go to the "User-specific variables" section and change the working directory and authors variable to your working directory (do not put a `/` at the end of the directory name) and name. Additionally, change the output path to the path/name of the CSV file you would like to output. This CSV file stores the peak count information after all the tests are run. Save and close the file.

Now, run the script. This will trigger the creation of all project files, creation of all snakefiles, execute the snakefiles to conduct the analysis, and count the peaks per test. Please note this will take a long time due to the amount of tests. If you would like to run it, simply run the following after you have made the appropriate changes:

```
python3 functional_test.py
```