# Rocketchip Supplementary Data Files

This repository contains the supplementary figures and tables associated with the Rocketchip manuscript:

- [**Supplementary Table 1.**](https://github.com/vhaghani26/rocketchip_tests/blob/main/Extended_Data/Supplementary%20Table%201%20-%20Peak%20Counts.csv) Peak Counts for all Software Combinations. ChIP-seq data from Namani et al. 2019 and Rube et al. 2016 were run through all software combinations in Rocketchip three times each. The “File Name” column corresponds to the full name of the Snakefile used to generate the peak counts. “Project” defines whether the entry corresponds to the Rube or Namani project data. “Control” delineates whether a control (“with_control”) or no control (“no_control”) was used during peak-calling. “Peak Type” defines whether the analysis was run modeling a “narrow” or “broad” peak pattern. “Aligner” notes which aligner was used for the analysis. “Peak Caller” notes which peak caller was used in the analysis. “Deduplicator” notes which deduplicator, including none (“no_deduplication”), was used in the analysis. “Test” represents the trial number, with “test1” being the first, “test2” being the second, and “test3” being the third trial for that test. “Peak Counts” documents the total peak number identified in the analysis. These results were plotted as a heatmap in Figure 2.
- [**Supplementary Table 2.**](https://github.com/vhaghani26/rocketchip_tests/blob/main/Extended_Data/Supplementary%20Table%202%20-%20Deep%20Dive%20Into%20Variation.xlsx) Deep Dive into Variation in Called Peaks. ChIP-seq data from Rube et al. 2016 was run through all software combinations in Rocketchip 100 times each. This table depicts all combinations of software and data in which peak counts were not replicated perfectly each of the three runs, exhibiting variation in peak-calling. “Project” details the source of the data set. “Control” refers to whether a control was used or excluded during peak-calling. “Aligner”, “Peak Caller”, and “Deduplicator” correspond to the sequence aligner, peak caller, and deduplicator tool used for the Rocketchip run, respectively. “Difference in Range of Called Peaks” represents the range between the minimum and maximum peak counts, highlighting the magnitude of variation in peak-calling across each of the 100 trial runs.