Require Import Basic.
Require Import ImpDefs SecurityDefs Trace.
Require Import Tactics.
Require Import BasicTheories ImpTheories.

From Coq Require Import Equality List.

Import ListNotations.

Module Type TraceTheories (B : Basic) (ID : ImpDefs) (TD : TraceDefs B ID) (SD : SecurityDefs B ID TD)
   (Tac : SimpleTactics B ID TD SD) (BT : BasicTheories B) (IT : ImpTheories B ID TD SD Tac BT).
  Import B ID TD Tac IT.

  Open Scope imp_scope.

  Lemma lst_prefix_stream_prefix : forall lst0 lst1, Prefix lst0 lst1 -> forall st, EvtPrefix lst1 st -> EvtPrefix lst0 st.
    intros lst0 lst1 LstPfx. induction LstPfx ; intros st EvtPfx ; [| inversion EvtPfx] ; eauto using EvtPrefix.
  Qed.

  Lemma pfx_of_prod : forall pfx0 pfx1 t, pfx0 <=, pfx1 -> pfx1 <=| t -> pfx0 <=| t.
    intros ? ? ? PfxOfPfx Prod.
    inversion PfxOfPfx ; subst ; inversion Prod ; subst.
    eauto using LeTrace_intro, lst_prefix_stream_prefix.
  Qed.

  Lemma prefix_of_same : forall lst0 st, EvtPrefix lst0 st -> forall lst1, EvtPrefix lst1 st -> (Prefix lst0 lst1 \/ Prefix lst1 lst0).
    intros lst0 st EvtPfx0. induction EvtPfx0 as [| a lst0 st] ; intros lst1 EvtPfx1 ; auto.
    inversion EvtPfx1 as [| ? lst1'] ; subst ; auto.
    assert (Prefix lst0 lst1' \/ Prefix lst1' lst0) as [|] by auto ; auto.
  Qed.

  Lemma prefix_of_prepend : forall lst0 lst1 t, Prefix lst0 lst1 -> EvtPrefix lst0 (prepend lst1 t).
    intros lst0 lst1 t Pfx. induction Pfx ; simpl ; auto using EvtPrefix.
  Qed.

  Lemma prepend_to_prefix : forall lst' lst t, EvtPrefix lst t -> EvtPrefix (lst' ++ lst) (prepend lst' t).
    induction lst' ; simpl ; intros lst t Pfx ; auto using EvtPrefix.
  Qed.

  Lemma delete_from_prefix : forall lst' lst t, EvtPrefix (lst' ++ lst) (prepend lst' t) -> EvtPrefix lst t.
    induction lst' ; simpl ; intros lst t Pfx ; [| inversion Pfx] ; auto.
  Qed.

  Lemma prefix_of_prepend_inv : forall lst1 lst0 t, EvtPrefix lst0 (prepend lst1 t)
      -> Prefix lst0 lst1 \/ exists lst0', lst0 = lst1 ++ lst0' /\ EvtPrefix lst0' t.
    induction lst1 ; intros lst0 t EvtPfx ; inversion EvtPfx ; subst ; simpl in *
    ; try (specialize (IHlst1 lst t H1) as [? | (lst0' & ? & ?)] ; subst) ; eauto using Prefix_some.
  Qed.

  Lemma pfx_from_same_trace_leq_help : forall lst0 lst1 st, EvtPrefix lst0 st
      -> EvtPrefix lst1 st
      -> Prefix lst0 lst1 \/ Prefix lst1 lst0.
    induction lst0 ; induction lst1 ; intros st EvtPfx0 EvtPfx1 ; auto.
    inversion EvtPfx0 ; subst ; inversion EvtPfx1 ; subst.
    assert (Prefix lst0 lst1 \/ Prefix lst1 lst0) as [|] by eauto ; auto.
  Qed.

  Lemma pfx_from_same_trace_leq : forall pfx0 pfx1 t, pfx0 <=| t -> pfx1 <=| t -> (pfx0 <=, pfx1 \/ pfx1 <=, pfx0).
    intros pfx0 pfx1 [s st] Pfx0LeT Pfx1LeT.
    inversion Pfx0LeT as [? lst0 ? EvtPfx0] ; subst.
    inversion Pfx1LeT as [? lst1 ? EvtPfx1] ; subst.
    assert (Prefix lst0 lst1 \/ Prefix lst1 lst0) as [|] by eauto using pfx_from_same_trace_leq_help ; auto using LePfx_intro.
  Qed.

  Import ImpNotations.

  Lemma evt_prefix_prod_both : forall lst st0, EvtPrefix lst st0 -> forall c s st1, Produces c s st0 -> Produces c s st1 -> EvtPrefix lst st1.
    intros lst st0 EvtPfx. induction EvtPfx ; intros c s st1 Prod0 Prod1 ; auto using EvtPrefix_empty.
    inversion Prod0 ; inversion Prod1 ; subst ; subst_eq_steps ; [| handle_simple_contradict].
    eauto using EvtPrefix_some.
  Qed.

  Lemma pfx_prod_both : forall pfx s st0, pfx <=| (s, st0) -> forall c st1, Produces c s st0 -> Produces c s st1 -> pfx <=| (s, st1).
    intros pfx s st0 PfxOf0 c st1 Prod0 Prod1.
    inversion PfxOf0 as [? lst ? EvtPfx] ; subst.
    eauto using LeTrace_intro, evt_prefix_prod_both.
  Qed.

  Lemma prod_mstep : forall c s cs lst, (c, s) ==>*[lst] cs -> forall st, Produces c s st
      -> exists st', Produces c s (prepend lst st').
    intros c s cs lst MStep. dependent induction MStep ; intros st Prod ; eauto.
    destruct cs1 as [c1 s1].
    inversion Prod ; subst ; [subst_eq_steps | handle_simple_contradict].
    assert (exists st', Produces c1 s1 (prepend lst st')) as [st' ?] by eauto.
    eauto using Produces_step.
  Qed.

  Lemma prod_prepend_mstep : forall c s c' s' lst, (c, s) ==>*[lst] (c', s')
      -> forall st, Produces c s (prepend lst st) -> Produces c' s' st.
    intros c s c' s' lst MStep. dependent induction MStep ; intros st ProdPrepend ; auto.
    destruct cs1 as [c1 s1].
    simpl in ProdPrepend ; inversion ProdPrepend ; subst ; subst_eq_steps.
    eauto.
  Qed.

  Lemma prod_prefix_mstep : forall lst c s st, Produces c s st
      -> EvtPrefix lst st
      -> exists cs, (c, s) ==>*[lst] cs.
    induction lst ; intros c s st Prod Pfx ; eauto using MultiStep_refl.
    inversion Pfx ; subst.
    inversion Prod ; subst.
    assert (exists cs, (c', s') ==>*[lst] cs) as [? ?] by eauto.
    eauto using MultiStep.
  Qed.

  Lemma prod_mstep_prefix : forall lst c s st cs, Produces c s st
      -> (c, s) ==>*[lst] cs
      -> EvtPrefix lst st.
    induction lst ; intros c s st cs Prod MStep ; eauto using EvtPrefix_empty.
    inversion MStep ; subst ; inversion Prod ; subst ; try handle_simple_contradict.
    destruct cs1 as [c1 s1] ; subst_eq_steps.
    eauto using EvtPrefix_some.
  Qed.

  Lemma prod_conv_prefix : forall lst st, EvtPrefix lst st
      -> forall c s s' lst', (c, s) ==>*[lst'] (Stop, s')
      -> Produces c s st
      -> Prefix lst lst'.
    intros lst st EvtPfx. induction EvtPfx ; intros c s s' lst' Conv Prod ; auto.
    inversion Prod ; subst ; inversion Conv ; subst ; [handle_simple_contradict | subst_eq_steps].
    eauto.
  Qed.

  Lemma prod_nstuck : forall c s st, Produces c s st -> never_stuck c s.
    unfold never_stuck.
    intros c s st Prod c' s' lst MStep.
    assert (exists st', Produces c s (prepend lst st')) as [st' ?] by eauto using prod_mstep.
    assert (Produces c' s' st') as Prod' by eauto using prod_prepend_mstep.
    destruct Prod' ; eauto.
  Qed.

  Section ExistTrace.

    Local Notation "'[' p ']' '<--' e1 '|' e2" := (match e1 with | Some p => e2 | None => None end) (at level 90, right associativity, p pattern).

    Fixpoint take_step c s : option (Cmd * Store * Event) :=
      match c with
        | Stop => None
        | Skip => Some (Stop, s, StopEvt)
        | (Seq Skip c') => Some (c', s, NoEvt)
        | (Seq c1 c2) => [(c1', s', a)] <-- take_step c1 s |
                         if (cmd_stop_dec c1') then
                            None
                         else
                            Some (Seq c1' c2, s', a)
        | (Assign x e) => [n] <-- evalExpr e s |
                          Some (Skip, fun y => if (eq_dec x y) then Some n else (s y), AssignEvt x n)
        | (If e c1 c2) => [n] <-- evalExpr e s |
                          match n with
                          | 0 => Some (c2, s, NoEvt)
                          | S _ => Some (c1, s, NoEvt)
                          end
        | (While e c') => Some (If e (Seq c' (While e c')) Skip, s, NoEvt)
        | (ProgDown l Skip) => Some (Skip, s, PDownEvt l)
        | (ProgDown l c') => [(c'', s', a)] <-- take_step c' s |
                             if (cmd_stop_dec c'') then
                                None
                             else
                                Some (ProgDown l c'', s', a)
      end.

    Ltac unfold_take_step :=
      repeat lazymatch goal with
        | [H : (if ?expr then None else _) = Some _ |- _] => destruct (expr) ; [discriminate |]
        | [H : match ?expr with | Some _ => _ | None => None end = Some _ |- _] => destruct_with_eqn (expr) ; [| discriminate]
        | [H : match ?n with | 0 => _ | S _ => _ end = Some _ |- _] => destruct_with_eqn (n)
        | [H : (let (_, _) := ?p in _) = Some _ |- _] => destruct p
        | [H : Some _ = Some _ |- _] => injection H ; intros ; subst ; clear H
      end.

    Lemma step_iff_take_step : forall {c s a c' s'}, (c, s) -->[a] (c', s') <-> take_step c s = Some (c', s', a).
      intros c s a c' s'. split.
      * intro Step.
        dependent induction Step ; simpl
        ; repeat lazymatch goal with
          | [H : ?P = _ |- context[match ?P with | None => None | Some _ => _ end]] => rewrite -> H ; clear H
        end
        ; auto
        ; lazymatch goal with
          | [c'NotStop : ?c' <> Stop,
            Step : (?c, ?s) -->[?a] (?c', ?s'),
            IH : forall _ _ _ _, (?c, ?s) = _ -> (?c', ?s') = _ -> _ |- _]
            => specialize (IH c s c' s' eq_refl eq_refl)
              ; rewrite -> IHStep
              ; induction c ; try solve [destruct (cmd_stop_dec c') ; [exfalso |] ; auto]
              ; contradiction c'NotStop ; subst ; inversion Step ; reflexivity
        end.
      * intro.
        dependent induction c ; simpl in *
        ; unfold_take_step
        ; try discriminate
        ; try (lazymatch goal with
          | [H : match ?c with Skip => _ | _ => _ end = Some _ |- _]
            => destruct_with_eqn (take_step c s) ; induction c ; try discriminate ; simpl in *
        end ; unfold_take_step)
        ; eauto using OneStep.
    Qed.

    CoInductive NeverStuck : Cmd -> Store -> Set :=
      | NStuckTerm : forall s, NeverStuck Stop s
      | NStuckStep : forall c s c' s' a, (c, s) -->[a] (c', s') -> NeverStuck c' s' -> NeverStuck c s.

    Lemma nstuck_nostep_stop : forall c s, never_stuck c s -> take_step c s = None -> c = Stop.
      intros c s NStuck TakeStepNone.
      destruct (NStuck c s [] (MultiStep_refl (c, s))) as [| ([] & ? & Step)] ; [assumption |].
      apply step_iff_take_step in Step.
      rewrite -> Step in TakeStepNone.
      discriminate.
    Qed.

    Lemma nstuck_coNstuck : forall c s, never_stuck c s -> NeverStuck c s.
      cofix nstuck_coNstuck.
      intros c s NStuck.
      destruct (take_step c s) as [[[c' s'] a] |] eqn:StepVal.
      * apply step_iff_take_step in StepVal.
        apply NStuckStep with c' s' a ; eauto using never_stuck_step.
      * assert (c = Stop) by eauto using nstuck_nostep_stop ; subst.
        apply NStuckTerm.
    Qed.

    CoFixpoint build_stream c s (nstuck : NeverStuck c s) : EvtStream :=
      match nstuck with
        | NStuckTerm _ => TermEvtSt
        | NStuckStep _ _ c' s' a _ nstuck' => ConsEvt a (build_stream c' s' nstuck')
      end.

    (* This is necessary as a stupid rewrite to handle coinductive functions. *)
    Definition frob (s : EvtStream) : EvtStream :=
      match s with
        | ConsEvt a st => ConsEvt a st
        | TermEvtSt => TermEvtSt
      end.

    Lemma frob_eq : forall s, s = frob s.
      destruct s ; reflexivity.
    Qed.

    Lemma build_stream_prod : forall c s (nstuck : NeverStuck c s), Produces c s (build_stream c s nstuck).
      cofix build_stream_prod.
      intros c s nstuck.
      rewrite -> frob_eq.
      destruct nstuck as [| ? ? c' s'] ; simpl.
      * apply Produces_term.
      * apply Produces_step with c' s' ; auto.
    Qed.

    Lemma nstuck_ex_stream : forall {c s}, never_stuck c s -> exists st, Produces c s st.
      intros c s nstuck.
      exists (build_stream c s (nstuck_coNstuck c s nstuck)).
      apply build_stream_prod.
    Qed.

    Proposition wt_ex_stream : forall {G pc c nt s}, G;; pc |- c -| nt -> dom_subset G s -> exists st, Produces c s st.
      eauto using type_soundness, nstuck_ex_stream.
    Qed.

    Lemma diverge_prod_under_seq: forall c1 c2 s st, Produces (Seq c1 c2) s st -> diverge c1 s -> Produces c1 s st.
      cofix divg_prod.
      unfold diverge. intros c1 c2 s st Prod Divg.
      inversion Prod as [? ? ? cProd' ? ? Step |] ; subst.
      inversion Step as [| ? c' | | | | | | |] ; subst.
      * apply Produces_step with c' s' ; eauto using diverge_step.
      * assert (exists cs a, (Stop, s') -->[a] cs) as (? & ? & ?) by eauto using MultiStep, StopE.
        handle_simple_contradict.
    Qed.

    Lemma diverge_prod_under_pdown: forall c l s st, Produces (ProgDown l c) s st -> diverge c s -> Produces c s st.
      cofix divg_prod.
      unfold diverge. intros c l s st Prod Divg.
      inversion Prod as [? ? ? cProd' ? ? Step |] ; subst.
      inversion Step as [| | | | | | | ? c' |] ; subst.
      * apply Produces_step with c' s' ; eauto using diverge_step.
      * assert (exists cs a, (Stop, s') -->[a] cs) as (? & ? & ?) by eauto using MultiStep, StopE.
        handle_simple_contradict.
    Qed.

  End ExistTrace.

End TraceTheories.
