Require Import Basic.
Require Import ImpDefs SecurityDefs Trace.
Require Import Tactics.
Require Import BasicTheories ImpTheories TraceTheories SecurityTheories.
Require Import ConvergeDiverge.
Require Import Containment BridgeStep.

From Coq Require Import Program.Wf Wf_nat PeanoNat Equality List Ensembles.

Import ListNotations.

Module Type Noninterference (B : Basic) (ID : ImpDefs) (TD : TraceDefs B ID) (SD : SecurityDefs B ID TD)
    (Tac : SimpleTactics B ID TD SD) (BT : BasicTheories B) (IT : ImpTheories B ID TD SD Tac BT) (TT : TraceTheories B ID TD SD Tac BT IT)
    (ST : SecurityTheories B ID TD SD Tac BT IT TT) (CD : ConvergeDiverge B ID TD SD Tac BT IT)
    (Con : Containment B ID TD SD Tac BT IT TT ST CD) (BStep : BridgeStep B ID TD SD Tac BT IT TT ST CD Con).
  Import B ID TD SD Tac BT IT TT ST Con BStep.
  Import ImpNotations.

  Open Scope imp_scope.

  Section HyperPropertyRelations.

    Context (G : Varname -> option Label) (D : Ensemble Label) `{DecD : DecideIn Label D}.

    Lemma psni_impl_pini : forall (P : TracePfx -> Prop) t0 t1,
        (forall pfx0, pfx0 <=| t0 -> P pfx0 -> exists pfx1, (pfx1 <=| t1) /\ pfx0 =[G, D] pfx1)
        -> forall pfx0 pfx1, pfx0 <=| t0 -> pfx1 <=| t1 -> P pfx0 -> (pfx0 <=[G, D] pfx1 \/ pfx1 <=[G, D] pfx0).
      intros ? ? t1 InPsni ? ? ? ? ?.
      assert (exists pfx1', (pfx1' <=| t1 /\ pfx0 =[G, D] pfx1')) as (pfx1' & ? & ?) by eauto using InPsni.
      assert (pfx1 <=, pfx1' \/ pfx1' <=, pfx1) as [|] by eauto using pfx_from_same_trace_leq
      ; [right ; apply pfx_deq_impl_dle with pfx1' | unfold dle_pfx] ; eauto with deq.
    Qed.

    Lemma psni_impl_lfp : forall (P : TracePfx -> Prop) t0 t1,
        (forall pfx0, pfx0 <=| t0 -> P pfx0 -> exists pfx1, (pfx1 <=| t1) /\ pfx0 =[G, D] pfx1)
        -> forall pfx0 pfx1, pfx0 <=| t0 -> pfx1 <=| t1 -> pfx1 <[G, D] pfx0 -> P pfx0 -> progress G D pfx1 t1.
      intros ? t0 ? InPsni ? ? ? ? [? NDEqp0p1] ?.
      assert (exists pfx1', (pfx1' <=| t1 /\ pfx0 =[G, D] pfx1')) as (pfx1' & ? & ?) by eauto using InPsni.
      exists pfx1'. split ; [assumption |].
      assert (pfx1 <=, pfx1' \/ pfx1' <=, pfx1) as [|] by eauto using pfx_from_same_trace_leq.
      - split ; [apply pfx_deq_impl_dle with pfx1' | intro ; contradict NDEqp0p1 ; transitivity pfx1'] ; auto with deq.
      - contradict NDEqp0p1. apply dle_pfx_antisym ; try unfold dle_pfx ; eauto.
    Qed.

    Program Fixpoint progress_ind lst lst' (P : list Event -> Prop)
        (PEmpty : P lst')
        (PAdvance : forall lst0, P lst0
          -> length (erase_evt_lst G D lst0) < length (erase_evt_lst G D lst)
          -> exists lst1, P lst1 /\ length (erase_evt_lst G D lst0) < length (erase_evt_lst G D lst1))
        {measure (length (erase_evt_lst G D lst) - length (erase_evt_lst G D lst'))}
        : exists lst0, P lst0 /\ length (erase_evt_lst G D lst) <= length (erase_evt_lst G D lst0) :=
      let eraseLst := erase_evt_lst G D lst in
      let eraseLst' := erase_evt_lst G D lst' in
      match le_or_gt (length eraseLst) (length eraseLst') with
      | left Lst'Long =>
        ex_intro (fun lst0 => P lst0 /\ length (erase_evt_lst G D lst) <= length (erase_evt_lst G D lst0))
                lst' (conj PEmpty Lst'Long)
      | right Lst'Short =>
        let IHres := PAdvance lst' PEmpty Lst'Short in
        match IHres with
        | ex_intro _ lst1 (conj PLst1 _) => progress_ind lst lst1 P PLst1 PAdvance
        end
      end.
    Next Obligation.
      apply lt_minus_lt ; assumption.
    Defined.

    Lemma prefix_len_leq : forall {A} (lst0 lst1 : list A), (Prefix lst0 lst1 \/ Prefix lst1 lst0)
        -> length lst0 < length lst1
        -> PropPrefix lst0 lst1.
      intros ? lst0 lst1 PfxOrPfx LenLt.
      destruct PfxOrPfx as [Pfx01 | Pfx10]
      ; [split ; auto ; intro ; subst
        | apply prefix_length in Pfx10
          ; assert (length lst0 < length lst0) as BadLe by (unfold lt ; transitivity (length lst1) ; auto)]
      ; try lazymatch goal with
        | [H : ?n < ?n |- _] => generalize H ; clear ; unfold lt ; intro ; induction n ; [inversion H | auto using le_S_n]
      end.
    Qed.

    Lemma pini_lfp_impl_psni : forall (P : TracePfx -> Prop) t0 t1,
        deq_store G D (t_input t0) (t_input t1)
        -> (forall pfx0 pfx1, pfx0 <=| t0 -> pfx1 <=| t1 -> P pfx0 -> pfx0 <=[G, D] pfx1 \/ pfx1 <=[G, D] pfx0)
        -> (forall pfx0 pfx1, pfx0 <=| t0 -> pfx1 <=| t1 -> pfx1 <[G, D] pfx0 -> P pfx0 -> progress G D pfx1 t1)
        -> forall pfx0, pfx0 <=| t0 -> P pfx0
        -> exists pfx1, pfx1 <=| t1 /\ pfx0 =[G, D] pfx1.
      intros ? [s0 st0] [s1 st1] ? InPini InLfp ? Pfx0OfT0 ?.
      inversion Pfx0OfT0 as [? lst0 ? ?] ; subst.
      enough (exists lst1, EvtPrefix lst1 st1
                           /\ length (erase_evt_lst G D lst0) <= length (erase_evt_lst G D lst1))
        as (lst1 & ? & ?).
      * assert ((s0, lst0) <=[G, D] (s1, lst1) \/ (s1, lst1) <=[G, D] (s0, lst0)) as PfxPini by auto using LeTrace_intro.
        destruct PfxPini as [PfxShort | PfxShort] ; unfold dle_pfx in PfxShort
        ; destruct PfxShort as (pfx' & PrefixPfx' & DEq).
        - inversion PrefixPfx' as [lst1'] ; subst.
          exists (s1, lst1'). eauto using LeTrace_intro, lst_prefix_stream_prefix.
        - inversion PrefixPfx' as [lst0' ? PrefixLst0] ; subst.
          apply prefix_erase with G D DecD lst0' lst0 in PrefixLst0.
          inversion DEq as [? ? ? ? DEqStore DEqEvtLst] ; subst.
          apply deq_impl_erase_lst with G D DecD lst1 lst0' in DEqEvtLst.
          assert (length (erase_evt_lst G D lst0) = length (erase_evt_lst G D lst1)) as LenEq
            by (apply le_antisym ; [| transitivity (length (erase_evt_lst G D lst0'))
                                    ; [rewrite -> DEqEvtLst | apply prefix_length]] ; auto).
          rewrite <- DEqEvtLst in PrefixLst0.
          assert (erase_evt_lst G D lst1 = erase_evt_lst G D lst0) as EraseLstEq by (apply prefix_eq_len ; auto).
          exists (s1, lst1). eauto using LeTrace_intro, DEqPfx_intro, erase_lst_impl_deq.
      * apply progress_ind with [] ; [apply EvtPrefix_empty |].
        intros lst1 EvtPfx1 LenLt.
        assert ((s0, lst0) <=[G, D] (s1, lst1) \/ (s1, lst1) <=[G, D] (s0, lst0)) as DLeOrDLe by eauto using LeTrace_intro with deq.
        assert (progress G D (s1, lst1) (s1, st1)) as Prog1
          by (apply InLfp with (s0, lst0) ; auto using LeTrace_intro with deq
              ; apply erase_prop_prefix_dlt_pfx with DecD ; auto with deq
              ; apply prefix_len_leq ; destruct DLeOrDLe ; eauto using dle_pfx_erase_prefix).
        destruct Prog1 as (? & Pfx1'OfT1 & ?).
        inversion Pfx1'OfT1 as [? lst1'] ; subst.
        exists lst1'. eauto using prop_prefix_length, dlt_pfx_erase_prefix.
    Qed.

    Theorem psni_is_pini_lfp : Same_set Property (PsniD G D) (Intersection Property (PiniD G D) (LfpD G D)).
      unfold Same_set, Included, PsniD, PiniD, LfpD. split.
      * intros. apply Intersection_intro ; unfold In in * ; intros t0 t1 ? ? ? ; [intro |] ; intros pfx1 Pfx0OfT0 Pfx1OfT1.
        - apply psni_impl_pini with (fun x => True) t0 t1 ; eauto with deq.
        - intros.
          assert (deq_store G D (t_input t0) (t_input t1)) by (inversion Pfx0OfT0 ; inversion Pfx1OfT1 ; subst ; eauto using dlt_impl_input_deq).
          apply psni_impl_lfp with (fun x => True) t1 pfx1 ; eauto with deq.
      * intros ? [] t0 ; intros. unfold In in *.
        apply pini_lfp_impl_psni with (fun x => True) t0 ; eauto with deq.
    Qed.

  End HyperPropertyRelations.

  Section ImpNI.

    Lemma pini_traces : forall G D `(LowSet D) lst0 pc c nt, G;; pc |- c -| nt
        -> forall s0 s1, deq_store G D s0 s1
        -> never_stuck c s1
        -> forall lst1 cs0 cs1, (c, s0) ==>*[lst0] cs0
        -> (c, s1) ==>*[lst1] cs1
        -> Prefix (erase_evt_lst G D lst0) (erase_evt_lst G D lst1) \/ Prefix (erase_evt_lst G D lst1) (erase_evt_lst G D lst0).
      intros G D DecD LowD lst0.
      remember (erase_evt_lst G D lst0) as lst ; generalize dependent lst0.
      induction lst as [| a lst] ; auto ; intros lst0 Heqlst pc c nt WTc s0 s1 DEqStore NStuck1 lst1 cs0 cs1 MStep0 MStep1.
      pose proof (wt_bstep_erase G D WTc MStep0 Heqlst)
        as ([c' s0'] & n0 & lst0' & BStep0 & MStep0' & LstVal).
      assert (exists (_ : CmdTypeProof G pc c nt), True) as [Pfc ?] by auto using wt_impl_proof.
      pose proof (matching_bridge_step G D Pfc BStep0 DEqStore NStuck1)
        as [(s1' & n1 & BStep1 & DEqStore') | [SilentC1 ?]] ; [| right].
      * pose proof (bstep_split_mstep G D MStep1 BStep1)
          as [[DEqLst1Nil ?] | (lst1F & lst1R & Lst1Val & DEqLst1F & ?)]
        ; [right ; apply deq_impl_erase_lst with G D DecD lst1 [] in DEqLst1Nil ; rewrite -> DEqLst1Nil ; simpl ; auto |].
        rewrite -> Lst1Val in * ; clear Lst1Val.
        apply deq_impl_erase_lst with G D DecD lst1F [] in DEqLst1F ; simpl in DEqLst1F.
        rewrite -> erase_app_distr. rewrite -> DEqLst1F. rewrite -> app_nil_l.
        rewrite -> non_erase_low ; [| eauto using bstep_low_a].
        destruct (bstep_type_preservation G D WTc BStep0) as [| WTc'].
        - subst.
          inversion MStep0' ; subst ; simpl ; auto ; handle_simple_contradict.
        - assert (Prefix lst (erase_evt_lst G D lst1R) \/ Prefix (erase_evt_lst G D lst1R) lst) as [|]
            by eauto using bstep_nstuck
          ; auto using Prefix_some.
      * unfold silent in SilentC1.
        assert (erase_evt_lst G D lst1 = erase_evt_lst G D []) as Lst1EraseNil by (eauto using deq_impl_erase_lst).
        rewrite -> Lst1EraseNil. simpl. apply Prefix_empty.
    Qed.

    Theorem wt_pini_d : forall G pc c nt, G;; pc |- c -| nt -> forall D `(LowSet D), In Property (PiniD G D) (behavior c).
      unfold PiniD, In, behavior.
      intros ? ? c ? ? D DecD ? ? ? Produces0 Produces1 ? ? ? Pfx0OfT0 Pfx1OfT1.
      inversion Pfx0OfT0 as [s0 lst0 ? ?] ; inversion Pfx1OfT1 as [s1 lst1 ? ?] ; subst.
      simpl in *.
      assert (never_stuck c s1) as NStuck1 by eauto using prod_nstuck.
      eapply prod_prefix_mstep in Produces0 ; eauto ; destruct Produces0.
      eapply prod_prefix_mstep in Produces1 ; eauto ; destruct Produces1.
      assert (Prefix (erase_evt_lst G D lst0) (erase_evt_lst G D lst1)
              \/ Prefix (erase_evt_lst G D lst1) (erase_evt_lst G D lst0)) as [|]
        by (eauto using pini_traces)
      ; eauto using erase_prefix_dle_pfx with deq.
    Qed.

    Lemma psni_traces : forall G D `(LowSet D) lst0 pc c nt (Pf : CmdTypeProof G pc c nt),
        In Label D nt
        -> ~ HasDowngrade D Pf
        -> forall s0 s1, deq_store G D s0 s1
        -> never_stuck c s1
        -> forall cs0, (c, s0) ==>*[lst0] cs0
        -> exists cs1 lst1, (c, s1) ==>*[lst1] cs1 /\ deq_evt_lst G D lst1 lst0.
      intros G D DecD LowD.
      intro lst0. remember (erase_evt_lst G D lst0) as lst ; generalize dependent lst0.
      induction lst as [| a lst] ; eauto using MultiStep_refl, erase_lst_impl_deq
      ; intros lst0 EqLstErase pc c nt Pf LowNt NoDown s0 s1 DEqStore NStuck1 cs0 MStep0.
      assert (G;; pc |- c -| nt) as WTc by auto using wt_proof_impl_prop.
      pose proof (wt_bstep_erase G D WTc MStep0 EqLstErase)
        as ([c' s0'] & n0 & lst0' & BStep0 & MStep0' & ?).
      pose proof (matching_bridge_step G D Pf BStep0 DEqStore NStuck1)
        as [(s1' & n1 & BStep1 & DEqStore') | [? [(? & HighNt) | (? & ? & ?)]]]
      ; [| contradict HighNt | contradict NoDown] ; auto.
      destruct (cmd_stop_dec c') as [| c'NotStop].
      * subst.
        assert (lst0' = []) by (inversion MStep0' as [| ? ? ? ? ? Step] ; [auto | inversion Step]) ; subst.
        assert (exists lst1, (c, s1) ==>*[lst1 ++ [a]] (Stop, s1') /\ deq_evt_lst G D lst1 []) as (lst1 & ? & DEqLst1Nil)
          by (apply mstep_lst_from_bstep with n1 ; auto).
        exists (Stop, s1'). exists (lst1 ++ [a]). split ; [assumption |].
        apply erase_lst_impl_deq with DecD. rewrite -> erase_app_distr.
        apply deq_impl_erase_lst with G D DecD lst1 [] in DEqLst1Nil.
        rewrite -> non_erase_low ; eauto using bstep_low_a. rewrite -> EqLstErase. rewrite -> DEqLst1Nil. auto.
      * assert (exists lst0Fst, (c, s0) ==>*[lst0Fst ++ [a]] (c', s0')) as [? ?] by eauto using mstep_from_bstep.
        assert (exists (Pf' : CmdTypeProof G pc c' nt), forall D', HasDowngrade D' Pf' -> HasDowngrade D' Pf)
          as [Pfc' ?] by eauto using mstep_type_pres_with_downgrade.
        assert (exists cs1 lst1, (c', s1') ==>*[lst1] cs1 /\ deq_evt_lst G D lst1 lst0') as (cs1 & lst1 & ? & ?)
          by (apply IHlst with pc nt Pfc' s0' cs0 ; eauto using bstep_nstuck).
        assert (exists lst1', (c, s1) ==>*[lst1' ++[a]] (c', s1') /\ deq_evt_lst G D lst1' []) as (lst1' & ? & DEqLst1'Nil)
          by (eapply mstep_lst_from_bstep ; eauto).
        exists cs1. exists ((lst1' ++ [a]) ++ lst1). split.
        - apply step_concat with (c', s1') ; auto.
        - apply erase_lst_impl_deq with DecD.
          do 2 rewrite -> erase_app_distr.
          rewrite -> non_erase_low ; eauto using bstep_low_a.
          apply deq_impl_erase_lst with G D DecD lst1' [] in DEqLst1'Nil.
          rewrite -> DEqLst1'Nil. simpl. rewrite <- EqLstErase.
          apply f_equal. subst. auto using deq_impl_erase_lst.
    Qed.

    Lemma wt_no_pc_flow_any_nt : forall {G pc c nt}, G;; pc |- c -| nt -> flows_to pc nt \/ forall nt' D , exists Pf : CmdTypeProof G pc c nt', ~ HasDowngrade D Pf.
      intros G pc c nt WTc. induction WTc
      ; repeat lazymatch goal with
        | [IH : flows_to _ _ \/ (forall _ _, _) |- _] => destruct IH
      end
      ; try (left ; auto
        ; lazymatch goal with
          | [H0 : flows_to ?pc ?l, H2 : flows_to ?l ?nt |- flows_to ?pc ?nt] => transitivity l 
          | [H0 : flows_to ?pc ?l0, H1 : flows_to ?l0 ?l1, H2 : flows_to ?l1 ?nt |- flows_to ?pc ?nt] => transitivity l0 ; [| transitivity l1]
        end ; assumption)
      ; try (right ; intros
            ; try eexists (SkipTPf G _ _) ; try eexists (AssignTPf G _ _ _ _ _ _)
            ; intro HasDown ; inversion HasDown)
      ; right
      ; let nt' := fresh "nt" in intros nt' D
      ; repeat lazymatch goal with
        | [H1 : forall nt D, exists Pf : CmdTypeProof G pc ?c1 nt, ~ HasDowngrade D Pf,
           H2 : forall nt D, exists Pf : CmdTypeProof G ?pc' ?c2 nt, ~ HasDowngrade D Pf
           |- exists _ : CmdTypeProof G pc (Seq ?c1 ?c2) nt', _] =>
            let nt'' := fresh "nt" in
              destruct (e_lower_bound nt' pc') as (nt'' & ? & ?)
              ; destruct (H1 nt'' D) ; destruct (H2 nt' D)
              ; clear H1 H2
        | [H : forall nt D, exists Pf, ~ HasDowngrade D Pf |- _] => destruct (H nt' D) ; clear H
      end
      ; lazymatch goal with
        | [|- exists _ : CmdTypeProof G pc (If ?e ?c1 ?c2) nt', _] => eexists (IfTPf G pc e c1 c2 nt' _ _ _)
        | [Pfc1 : CmdTypeProof G pc ?c1 ?nt1 |- exists _ : CmdTypeProof G pc (Seq ?c1 ?c2) nt', _] => eexists (SeqTPf G pc _ c1 c2 nt' nt1 _ _ _ _ _)
        | [WTc : G;; ?pc' |- c -| _, NoDown : ~ HasDowngrade D _ |- exists _ : CmdTypeProof G pc c nt', _]
            => eexists (VarianceTPf G pc pc' c nt' nt' _ _ (flows_to_refl nt')) ; intro HasDown ; apply NoDown ; revert HasDown ; clear
      end ; intro HasDown ; dependent induction HasDown ; eauto.
      Unshelve. all: assumption.
    Qed.

    Lemma high_pc_low_nt_impl_nodown_possible : forall P T `(Attacker P T) G pc c nt, G;; pc |- c -| nt
        -> ~ In Label P pc -> In Label T nt
        -> exists (Pf : CmdTypeProof G pc c nt), ~ HasDowngrade T Pf.
      intros P T DecP LowP DecT LowT AtkPT G pc c nt WTc SecPc TrustNt.
      dependent induction WTc ; subst.
      * exists (SkipTPf G pc nt). intro Pf. inversion Pf.
      * exists (AssignTPf G x e l nt H H0). intro Pf. inversion Pf.
      * assert (exists (Pf1 : CmdTypeProof G pc c1 nt), ~ HasDowngrade T Pf1) as [Pf1 ?] by auto.
        assert (exists (Pf2 : CmdTypeProof G pc c2 nt), ~ HasDowngrade T Pf2) as [Pf2 ?] by auto.
        exists (IfTPf G pc e c1 c2 nt H Pf1 Pf2). intro Pf. dependent destruction Pf ; auto.
      * assert (exists (Pf1 : CmdTypeProof G pc c1 nt'), ~ HasDowngrade T Pf1) as [Pf1 ?] by eauto using (LowT.(down_closed)).
        assert (exists (Pf2 : CmdTypeProof G pc' c2 nt), ~ HasDowngrade T Pf2) as [Pf2 ?] by eauto using high_set_up_closed.
        exists (SeqTPf G pc pc' c1 c2 nt nt' Pf1 H H0 Pf2 H1). intro Pf. dependent destruction Pf ; auto.
      * assert (exists (Pfc : CmdTypeProof G pc c pc), ~ HasDowngrade T Pfc) as [Pfc ?] by auto.
        exists (WhileTPf G pc e c H Pfc). intro Pf. dependent destruction Pf ; auto.
      * destruct (wt_no_pc_flow_any_nt WTc) as [| HasNoDownPf].
        - assert (In Label T nt)
            by (assert (In Label (Union Label P T) nt) as InUnion by eauto using AtkPT.(non_compromised_low)
                ; inversion InUnion ; [contradict SecPc |] ; eauto using LowP.(down_closed)).
          assert (exists Pf : CmdTypeProof G pc c nt, ~ HasDowngrade T Pf) as [Pfc ?] by eauto.
          exists (ProgDownTPf G pc c nt l Pfc H H0). intro Pf. dependent destruction Pf ; auto.
        - destruct (e_lower_bound l nt) as (nt' & ? & ?).
          destruct (HasNoDownPf nt' T) as [Pfc ?].
          assert (flows_to nt' (reflect nt')) as FlowsNt'Refl by eauto using reflect_homomorphism, flows_to_trans.
          exists (ProgDownTPf G pc c nt' l Pfc FlowsNt'Refl H0).
          intro Pf. dependent destruction Pf; eauto using LowT.(down_closed).
      * assert (exists (Pfc : CmdTypeProof G pc' c nt'), ~ HasDowngrade T Pfc) as [Pfc ?] by eauto using high_set_up_closed, LowT.(down_closed).
        exists (VarianceTPf G pc pc' c nt nt' Pfc H H0).
        intro Pf. dependent destruction Pf ; auto.
    Qed.

    Theorem nodown_psni : forall G D `(LowSet D) pc c nt (WTc : CmdTypeProof G pc c nt),
        In Label D nt
        -> ~ HasDowngrade D WTc
        -> In Property (PsniD G D) (behavior c).
      unfold PsniD, In, behavior.
      intros G D DecD ? ? c ? ? ? ? ? [s1 ?] Produces0 Produces1 ? ? Pfx0OfT0.
      simpl in *.
      inversion Pfx0OfT0 as [? lst0 ? EvtPfx0] ; subst.
      eapply prod_prefix_mstep in Produces0 ; eauto. destruct Produces0 as [cs0 MStep0].
      assert (exists cs1 lst1, (c, s1) ==>*[lst1] cs1 /\ deq_evt_lst G D lst1 lst0) as (? & ? & ? & ?)
          by eauto using psni_traces, prod_nstuck.
      eauto 7 using LeTrace_intro, prod_mstep_prefix, DEqPfx_intro with deq.
    Qed.

    Proposition high_pc_low_nt_psni : forall P T `(Attacker P T) G pc c nt, G;; pc |- c -| nt
        -> ~ In Label P pc -> In Label T nt -> In Property (PsniD G T) (behavior c).
      intros P T DecP LowP DecT LowT ? G pc c nt WTc SecPc TrustNt.
      assert (exists (Pf : CmdTypeProof G pc c nt), ~ HasDowngrade T Pf) as [Pf ?]
        by (apply high_pc_low_nt_impl_nodown_possible with P DecP LowP DecT LowT ; auto).
      apply nodown_psni with DecT pc nt Pf ; auto.
    Qed.

    Lemma deq_high_tail : forall G D lst0 lst1 a, ~ deq_evt G D a NoEvt -> deq_evt_lst G D (lst0 ++ [a]) lst1
        -> exists lst1' lst1'', lst1 = lst1' ++ [a] ++ lst1'' /\ deq_evt_lst G D lst1'' [].
      intros G D lst0 lst1 a LowA DEq.
      apply deq_lst_iff_rev in DEq. dependent induction DEq
      ; try lazymatch goal with
        | [H : [] = _ ++ [_] |- _] => apply app_cons_not_nil in H ; inversion H
        | [H : _ ++ [_] = _ ++ [_] |- _] => apply app_inj_tail in H ; destruct H ; intros ; subst
      end ; try handle_simple_contradict.
      * eexists. exists []. auto with deq.
      * pose proof (IHDEq lst0 a LowA eq_refl) as (lst0' & lst0'' & ? & ?) ; subst.
        exists lst0'. exists (lst0'' ++ [a0]).
        split ; [repeat rewrite <- app_assoc ; reflexivity |].
        apply deq_evt_lst_append_high_l ; auto.
    Qed.

    Lemma conv_progress : forall G pc c nt s, G;; pc |- c -| nt
        -> converge c s
        -> forall c' s' lst, c' <> Stop
        -> (c, s) ==>*[lst] (c', s')
        -> forall st, Produces c s st
        -> forall D, DecideIn D -> progress G D (s, lst) (s, st).
      unfold converge.
      intros G pc c nt s WTc (lstF & sF & MStepF) c' s' lst c'NotStop MStep st ProdCS D DecD.
      unfold progress, dlt_pfx, dle_pfx.
      exists (s, lstF).
      repeat split ; [eauto using prod_mstep_prefix | exists (s, lst) ; split ; auto with deq |].
      * apply LePfx_intro.
        pose proof (mstep_prefix (c, s) (c', s') lst MStep (Stop, sF) lstF MStepF) as [[lst0 ?] | [lst0 ?]]
        ; apply prefix_as_append ; exists lst0
        ; [| inversion H as [| ? ? ? ? ? Step]; [rewrite -> app_nil_r | inversion Step] ; subst]
        ; lazymatch goal with
          | [H : (?c, ?s) ==>*[?lstF] (Stop, ?sF) |- ?lst1 = ?lstF]
            => assert ((c, s) ==>*[lst1] (Stop, sF)) as MStepConcat by eauto using step_concat
              ; eapply desterministic_conv_trace ; eauto
        end.
      * intro DEq. contradict c'NotStop. inversion DEq ; subst.
        pose proof (wt_mstep_stop_lst WTc MStepF) as [lstF' ?] ; subst.
        assert (exists lst' lst'', lst = lst' ++ [StopEvt] ++ lst'' /\ deq_evt_lst G D lst'' []) as (lst' & lst'' & ? & ?)
          by (apply deq_high_tail with lstF' ; [intro BadDEq ; inversion BadDEq | auto with deq]) ; subst.
        apply mstep_split in MStep ; destruct MStep as (? & ? & MStep).
        inversion MStep as [| ? [c1 s1] ? ? ? ? MStepRst] ; assert (c1 = Stop) by eauto using step_stop_evt_impl_stop ; subst.
        inversion MStepRst as [| ? ? ? ? ? Step] ; [| inversion Step] ; subst ; reflexivity.
    Qed.

    Lemma conv_lfp : forall G pc c nt s0 s1, G;; pc |- c -| nt -> converge c s0
        -> forall st0 lst0, Produces c s0 st0 -> EvtPrefix lst0 st0
        -> forall st1 lst1, Produces c s1 st1 -> EvtPrefix lst1 st1
        -> forall D, DecideIn D -> (s0, lst0) <[G, D] (s1, lst1) -> progress G D (s0, lst0) (s0, st0).
      unfold converge.
      intros G pc c nt s0 s1 WTc (lst0F & s0F & MStep0F)
             st0 lst0 Prod0 Pfx0 st1 lst1 Prod1 Pfx1 D DecD [(pfx1' & PfxOfPfx & DEqPfx1) NDEq].
      inversion PfxOfPfx as [lst1'] ; subst ; inversion DEqPfx1 ; subst.
      assert (exists cs, (c, s0) ==>*[lst0] cs) as [[c0 s0'] ?] by eauto using prod_prefix_mstep.
      assert (exists cs, (c, s1) ==>*[lst1] cs) as [? MStep1] by eauto using prod_prefix_mstep.
      apply conv_progress with pc c nt c0 s0' ; try unfold converge ; eauto.
      intro ; subst ; contradict NDEq.
      apply DEqPfx_intro ; auto.
      assert (exists lst0', lst0 = lst0' ++ [StopEvt]) as [lst0' ?] by eauto using wt_mstep_stop_lst ; subst.
      assert (exists lst2 lst2', lst1' = lst2 ++ [StopEvt] ++ lst2' /\ deq_evt_lst G D lst2' []) as (lst2 & lst2' & ? & ?)
        by (apply deq_high_tail with lst0' ; [intro BadDEq ; inversion BadDEq | assumption]) ; subst.
      apply prefix_as_append in H. destruct H ; subst.
      repeat rewrite <- app_assoc in MStep1.
      apply mstep_split in MStep1.
      destruct MStep1 as ([c2 s2] & MStep2 & MStep2').
      inversion MStep2' as [| ? [cStop sStop] ? ? ? Step MStep2Rst] ; subst.
      assert (cStop = Stop) by eauto using step_stop_evt_impl_stop ; subst.
      inversion MStep2Rst as [| ? ? ? ? ? BadStep] ; [| inversion BadStep].
      lazymatch goal with
        | [H : [] = _ ++ _ |- _] => symmetry in H ; apply app_eq_nil in H ; destruct H ; subst ; repeat rewrite -> app_nil_r in *
      end.
      assumption.
    Qed.

    Lemma pini_one_converge : forall G D `(LowSet D) c s0 s1, deq_store G D s0 s1
        -> (forall cs0 cs1 lst0 lst1, (c, s0) ==>*[lst0] cs0 -> (c, s1) ==>*[lst1] cs1
            -> (s0, lst0) <=[G, D] (s1, lst1) \/ (s1, lst1) <=[G, D] (s0, lst0))
        -> forall cs0 lst0, (c, s0) ==>*[lst0] cs0
        -> forall s1' lst1, (c, s1) ==>*[lst1 ++ [StopEvt]] (Stop, s1')
        -> (s0, lst0) <=[G, D] (s1, lst1 ++ [StopEvt]).
      intros G D DecD LowD c s0 s1 DEqStore InPini [c0 s0'] lst0 MStepS0 s1' lst1 MStepS1.
      pose proof (InPini (c0, s0') (Stop, s1') lst0 (lst1 ++ [StopEvt]) MStepS0 MStepS1) as [| (? & Pfx0OfLst0 & DEqPfx)] ; [assumption |].
      inversion Pfx0OfLst0 as [lst0' ? Pfx0'] ; subst ; inversion DEqPfx ; subst.
      assert (exists lst0'', lst0' = lst0'' ++ [StopEvt]) as [lst0'' ?]
        by (assert (exists cs, (c, s0) ==>*[lst0'] cs) as [] by eauto using prefix_mstep
            ; eauto using deq_mstep_stop with deq)
      ; subst.
      invert_tail mstep_iff_msteptl MStepS0.
      * inversion Pfx0'. apply app_cons_not_nil in H0 ; inversion H0.
      * assert (a = StopEvt \/ a <> StopEvt) as [|] by (destruct a ; auto ; right ; discriminate).
        - subst. assert (c0 = Stop) by eauto using step_stop_evt_impl_stop ; subst.
          destruct cs1 as [c1 ?].
          assert (lst0'' = lst)
            by (assert (c1 <> Stop) by (intro ; subst ; handle_simple_contradict)
                ; apply prefix_tail_eq with StopEvt ; eauto using stop_evt_at_conv)
          ; subst.
          unfold dle_pfx.
          eauto with deq.
        - assert (~ List.In StopEvt (lst ++ [a])) as NotInLst
            by (intro BadIn ; apply in_app_or in BadIn as [| BadIn]
                ; [contradiction mstep_only_last_stop with (c, s0) (c0, s0') lst a
                  | unfold List.In in BadIn ; destruct BadIn ; auto]).
          contradict NotInLst.
          eauto using prefix_in.
    Qed.

    Lemma pini_one_converge_skip : forall G D `(LowSet D) c s0 s1, deq_store G D s0 s1
        -> (forall cs0 cs1 lst0 lst1, (c, s0) ==>*[lst0] cs0 -> (c, s1) ==>*[lst1] cs1
            -> (s0, lst0) <=[G, D] (s1, lst1) \/ (s1, lst1) <=[G, D] (s0, lst0))
        -> forall c' s0' lst0, (c, s0) ==>*[lst0] (c', s0')
        -> forall s1' lst1, (c, s1) ==>*[lst1] (Skip, s1')
        -> c' <> Stop
        -> (s0, lst0) <=[G, D] (s1, lst1).
      intros G D DecD LowD c s0 s1 DEqStore InPini c' s0' lst0 MStep0 s1' lst1 MStep1 c'NotStop.
      assert ((s0, lst0) <=[G, D] (s1, lst1 ++ [StopEvt])) as DLeStop by eauto using mstep_append, StopE, pini_one_converge.
      destruct (deq_or_dle G D DLeStop) ; [| assumption].
      assert (exists lst0', lst0 = lst0' ++ [StopEvt]) as [lst0' ?] by eauto using deq_mstep_stop ; subst.
      contradict c'NotStop.
      eauto using mstep_to_stop_evt.
    Qed.

    Theorem pini_impl_traditional_tini : forall G D `(LowSet D) c s0 s1, deq_store G D s0 s1
        -> (forall cs0 cs1 lst0 lst1, (c, s0) ==>*[lst0] cs0 -> (c, s1) ==>*[lst1] cs1
            -> (s0, lst0) <=[G, D] (s1, lst1) \/ (s1, lst1) <=[G, D] (s0, lst0))
        -> forall s0' lst0 s1' lst1, (c, s0) ==>*[lst0 ++ [StopEvt]] (Stop, s0')
        -> (c, s1) ==>*[lst1 ++ [StopEvt]] (Stop, s1')
        -> deq_evt_lst G D lst0 lst1.
      intros G D DecD LowD c s0 s1 DEqStore InPini s0' lst0 s1' lst1 MSteps0 MSteps1.
      invert_tail mstep_iff_msteptl MSteps0.
      invert_tail mstep_iff_msteptl MSteps1.
      repeat lazymatch goal with
      | [H : _ -->[StopEvt] (Stop, _) |- _] => inversion H ; subst ; clear H
      end.
      apply erase_lst_impl_deq with DecD.
      pose proof (InPini (Stop, s0') (Stop, s1') (lst0 ++ [StopEvt]) (lst1 ++ [StopEvt]) MSteps0 MSteps1) as [PiniRes | PiniRes]
      ; eapply dle_pfx_erase_prefix in PiniRes
      ; repeat rewrite -> erase_app_distr in PiniRes ; simpl in PiniRes
      ; (destruct (deq_evt_dec G D StopEvt) ; [handle_simple_contradict |])
      ; [set (lst := lst1) | symmetry ; set (lst := lst0)]
      ; apply prefix_tail_eq with StopEvt ; auto
      ; assert (~ List.In StopEvt lst) as NotInLst by (eapply stop_evt_at_conv ; eauto ; discriminate)
      ; intro ; contradict NotInLst ; eauto using erase_no_add.
    Qed.

    Lemma pini_conv_lst : forall D `(LowSet D) G pc c nt, G;; pc |- c -| nt
        -> forall s0 lst0 s0' s1 lst1 s1', deq_store G D s0 s1
        -> (c, s0) ==>*[lst0] (Stop, s0')
        -> (c, s1) ==>*[lst1] (Stop, s1')
        -> deq_evt_lst G D lst0 lst1.
      intros D DecD LowD G pc c nt WTc s0 lst0 s0' s1 lst1 s1' DEqStore ConvS0 ConvS1.
      invert_tail mstep_iff_msteptl ConvS0.
      invert_tail mstep_iff_msteptl ConvS1.
      do 2 match goal with
      | [H : _ ==>*[_ ++ [?a]] (Stop, _) |- _]
          => lazymatch a with | StopEvt => fail | _ => idtac end
             ; assert (a = StopEvt) by eauto using wt_mstep_to_stop ; subst
      end.
      apply deq_evt_lst_append_same.
      eapply pini_impl_traditional_tini ; eauto.
      intros.
      assert (In Property (PiniD G D) (behavior c)) as InPini by eauto using wt_pini_d.
      unfold PiniD, behavior, In in InPini.
      assert (exists st0, Produces c s0 st0) as [st0 ?] by (apply nstuck_ex_stream ; apply converge_impl_never_stuck ; unfold converge ; eauto).
      assert (exists st1, Produces c s1 st1) as [st1 ?] by (apply nstuck_ex_stream ; apply converge_impl_never_stuck ; unfold converge ; eauto).
      apply InPini with (s0, st0) (s1, st1) ; eauto using LeTrace_intro, prod_mstep_prefix.
    Qed.

    Lemma pini_conv_store : forall D `(LowSet D) G pc c nt, G;; pc |- c -| nt
        -> forall s0 lst0 s0' s1 lst1 s1', deq_store G D s0 s1
        -> (c, s0) ==>*[lst0] (Stop, s0')
        -> (c, s1) ==>*[lst1] (Stop, s1')
        -> deq_store G D s0' s1'.
      eauto using deq_traces_stores, DEqPfx_intro, pini_conv_lst.
    Qed.

    Lemma loops_lst_store_deq : forall D `(LowSet D) n G pc e c nt, G;; pc |- While e c -| nt
        -> forall s0 s0' s1 s1', deq_store G D s0 s1
        -> forall lst0, LoopsNLst e c s0 s0' lst0 n
        -> forall lst1, LoopsNLst e c s1 s1' lst1 n
        -> deq_store G D s0' s1'.
      intros D DecD LowD. induction n ; intros G pc e c nt WTc s0 s0' s1 s1' DEqStore lst0 Loops0 lst1 Loops1
      ; inversion Loops0 as [| ? ? ? s0'' ? lst0Hd lst0Tl ? ? Loops0']
      ; inversion Loops1 as [| ? ? ? s1'' ? lst1Hd lst1Tl ? ? Loops1']
      ; subst ; auto with deq.
      apply pini_conv_store with DecD pc c nt s0'' (lst0Tl ++ [StopEvt]) s1'' (lst1Tl ++ [StopEvt])
        ; eauto using while_cmd_type_inv, mstep_append, StopE.
    Qed.

    Lemma loops_store_deq : forall D `(LowSet D) n G pc e c nt, G;; pc |- While e c -| nt
        -> forall s0 s0' s1 s1', deq_store G D s0 s1
        -> LoopsN e c s0 s0' n
        -> LoopsN e c s1 s1' n
        -> deq_store G D s0' s1'.
      intros ? ? ? ? ? ? ? ? ? ? ? ? ? ? ? Loops0%loopsn_loopsnlst Loops1%loopsn_loopsnlst.
      destruct Loops0 ; destruct Loops1.
      eauto using loops_lst_store_deq.
    Qed.

    Lemma loops_lst_deq : forall D `(LowSet D) n G pc e c nt, G;; pc |- While e c -| nt
        -> forall s0 s0' s1 s1', deq_store G D s0 s1
        -> forall lst0, LoopsNLst e c s0 s0' lst0 n
        -> forall lst1, LoopsNLst e c s1 s1' lst1 n
        -> deq_evt_lst G D lst0 lst1.
      intros D DecD LowD. induction n ; intros G pc e c nt WTc s0 s0' s1 s1' DEqStore lst0 Loops0 lst1 Loops1
      ; inversion Loops0 as [| ? ? ? s0'' ? lst0Hd lst0Tl ? ? Loops0']
      ; inversion Loops1 as [| ? ? ? s1'' ? lst1Hd lst1Tl ? ? Loops1']
      ; subst ; auto with deq.
      pose proof (IHn G pc e c nt WTc s0 s0'' s1 s1'' DEqStore lst0Hd Loops0' lst1Hd Loops1') as LstHdDEq.
      repeat rewrite -> app_comm_cons.
      repeat apply deq_app ; repeat apply DEqSame ; auto with deq.
      apply deq_app_same_inv with StopEvt.
      apply pini_conv_lst with DecD pc c nt s0'' s0' s1'' s1'
      ; eauto using while_cmd_type_inv, loops_lst_store_deq, mstep_append, StopE.
    Qed.

    Lemma infinite_loop_psni : forall D `(LowSet D) G pc e c nt, G;; pc |- While e c -| nt
        -> forall s0 s1, deq_store G D s0 s1
        -> (forall n, exists s0' s1', LoopsN e c s0 s0' n /\ LoopsN e c s1 s1' n)
        -> forall st0 st1, Produces (While e c) s0 st0 -> Produces (While e c) s1 st1
        -> forall pfx0, pfx0 <=| (s0, st0)
        -> exists pfx1, pfx1 <=| (s1, st1) /\ pfx0 =[G, D] pfx1.
      intros D DecD LowD G pc e c nt WTc s0 s1 DEqStore InfLoops st0 st1 Prod0 Prod1 pfx0 Pfx0OfT0.
      inversion Pfx0OfT0 as [? lst0 ? EvtPfx01] ; subst.
      destruct (InfLoops (length lst0)) as (s0' & s1' & Loops0%loopsn_loopsnlst & Loops1%loopsn_loopsnlst).
      destruct Loops0 as [lst0' ?] ; destruct Loops1 as [lst1' ?].
      assert (exists cs, (While e c, s0) ==>*[lst0] cs) as [? ?] by eauto using prod_prefix_mstep.
      assert ((s0, lst0) <=[G, D] (s1, lst1')) as (? & PfxOf & ?).
      * apply pfx_deq_impl_dle with (s0, lst0') ; eauto using DEqPfx_intro, loops_lst_deq.
        apply LePfx_intro.
        assert (Prefix lst0 lst0' \/ Prefix lst0' lst0) as [|] by eauto using mstep_prefix_lst, loops_lst_step ; auto.
        enough (lst0' = lst0) by (subst ; reflexivity).
        apply prefix_eq_len ; [| apply le_antisym] ; eauto using prefix_length, loops_lst_len.
      * inversion PfxOf as [lst1] ; subst.
        exists (s1, lst1).
        eauto 6 using LeTrace_intro, lst_prefix_stream_prefix, prod_mstep_prefix, loops_lst_step.
    Qed.

    Lemma pc_flow_or_lfp : forall G pc c nt, G;; pc |- c -| nt -> flows_to pc nt \/ In Property (Lfp G) (behavior c).
      intros G pc c nt WTc.
      pose proof (termination_bound G pc c nt WTc) as [| ConvWTs] ; [left ; assumption | right].
      unfold Lfp, LfpD, behavior, In.
      intros ? ? ? [? ?] [? ?] ? ? ? ? Pfx0OfT0 Pfx1OfT1 ?.
      inversion Pfx0OfT0 ; inversion Pfx1OfT1 ; subst.
      eapply conv_lfp ; eauto using prod_nstuck.
    Qed.

    Lemma pc_flow_or_psni : forall G pc c nt, G;; pc |- c -| nt -> flows_to pc nt \/ In Property (Psni G) (behavior c).
      unfold Psni, Lfp, In. intros G pc c nt WTc.
      pose proof (pc_flow_or_lfp G pc c nt WTc) as [|] ; [left ; assumption | right ; intros].
      apply psni_is_pini_lfp ; eauto using wt_pini_d, Intersection_intro.
    Qed.

  End ImpNI.

End Noninterference.
