Require Import Basic.
Require Import ImpDefs SecurityDefs Trace.
Require Import Tactics.
Require Import BasicTheories ImpTheories TraceTheories SecurityTheories.
Require Import ConvergeDiverge.
Require Import Containment BridgeStep Noninterference.

From Coq Require Import Equality List Ensembles PeanoNat Compare.

Import ListNotations.

Module Type NMIF (B : Basic) (ID : ImpDefs) (TD : TraceDefs B ID) (SD : SecurityDefs B ID TD)
    (Tac : SimpleTactics B ID TD SD) (BT : BasicTheories B) (IT : ImpTheories B ID TD SD Tac BT) (TT : TraceTheories B ID TD SD Tac BT IT)
    (ST : SecurityTheories B ID TD SD Tac BT IT TT) (CD : ConvergeDiverge B ID TD SD Tac BT IT)
    (Con : Containment B ID TD SD Tac BT IT TT ST CD) (BStep : BridgeStep B ID TD SD Tac BT IT TT ST CD Con)
    (NI : Noninterference B ID TD SD Tac BT IT TT ST CD Con BStep).
  Import B ID TD SD Tac BT IT TT ST CD Con BStep NI.
  Import ImpNotations.

  Open Scope imp_scope.

  Section HyperPropertyRelations.

    Variable G : Varname -> option Label.

    Proposition pini_in_pird : forall P T, Included Property (PiniD G P) (PiRdA G P T).
      unfold Included, PiniD, PiRdA, In.
      intros ; lazymatch goal with | [H : nmif_input_match _ _ _ _ _ _ _ _ |- _] => destruct H end ; eauto with deq.
    Qed.

    Proposition lfp_in_rpl : forall P T, Included Property (LfpD G P) (RplA G P T).
      unfold Included, LfpD, RplA, In.
      intros ; lazymatch goal with | [H : nmif_input_match _ _ _ _ _ _ _ _ |- _] => destruct H end ; eauto with deq.
    Qed.

    Proposition psni_in_psrd : forall P T, Included Property (PsniD G P) (PsRdA G P T).
      unfold PsniD, PsRdA, Included, In.
      intros ; lazymatch goal with | [H : nmif_input_match _ _ _ _ _ _ _ _ |- _] => destruct H end ; eauto with deq.
    Qed.

    Proposition psni_rpl : forall P T, DecideIn P -> Included Property (PsniD G P) (RplA G P T).
      unfold Included. intros ? ? ? t_set InPsni.
      apply lfp_in_rpl. unfold PsniD, LfpD, In in *.
      intros ? ? ? ? ? ? Pfx0OfT0 Pfx1OfT1 ?.
      assert (deq_store G P (t_input t0) (t_input t1)) by (inversion Pfx0OfT0 ; inversion Pfx1OfT1 ; subst ; eauto using dlt_impl_input_deq).
      eauto using psni_impl_lfp with deq.
    Qed.

    Lemma nmif_input_match_dual : forall P T t_set t00 t01 t10 t11, nmif_input_match G P T t_set t00 t01 t10 t11
        -> nmif_input_match G T P t_set t00 t10 t01 t11.
      intros ? ? ? ? ? ? ? []. auto using NmifInput_intro.
    Qed.

    Proposition pi_rd_te_dual : forall P T, Same_set Property (PiRdA G P T) (PiTeA G T P).
      unfold Same_set, Included, PiRdA, PiTeA, In.
      intros P T. split ; intros t_set InTSet ? ? ? ? ? ; apply InTSet ; apply nmif_input_match_dual ; assumption.
    Qed.

    Proposition rpl_tpc_dual : forall P T, Same_set Property (RplA G P T) (TpcA G T P).
      unfold Same_set, Included, RplA, TpcA, In.
      intros P T. split ; intros t_set InTSet ? ? ? ? ? ; apply InTSet ; apply nmif_input_match_dual ; assumption.
    Qed.

    Proposition ps_rd_te_dual : forall P T, Same_set Property (PsRdA G P T) (PsTeA G T P).
      unfold Same_set, Included, PsRdA, PsTeA, In.
      intros P T. split ; intros t_set InTSet ? ? ? ? ? ; apply InTSet ; apply nmif_input_match_dual ; assumption.
    Qed.

    Theorem psrd_is_pird_rpl : forall P T, DecideIn P -> DecideIn T
        -> Same_set Property (PsRdA G P T) (Intersection Property (PiRdA G P T) (RplA G P T)).
      unfold Same_set, Included, PsRdA, PiRdA, RplA, In. intros P T ? ? ; split.
      * intros. apply Intersection_intro ; unfold In ; intros.
        - apply psni_impl_pini with (deq_pfx G T pfx) t01 t11 ; eauto.
        - apply psni_impl_lfp with (deq_pfx G T pfx) t01 pfx0 ; eauto.
      * intros ? [? InPiRd InRpl] t00 t01 t10 t11 [] pfx. intros.
        unfold In in *.
        apply pini_lfp_impl_psni with (deq_pfx G T pfx) t01 ; auto ; [intros | intros pfx1 ? ? ? ? ?]
        ; [apply InPiRd with t00 t01 t10 t11 pfx | apply InRpl with t00 t01 t10 pfx pfx1]
        ; auto using NmifInput_intro.
    Qed.

    Theorem pste_is_pite_tpc : forall P T, DecideIn P -> DecideIn T
        -> Same_set Property (PsTeA G P T) (Intersection Property (PiTeA G P T) (TpcA G P T)).
    unfold Same_set, Included, In. intros P T ? ? ; split.
    * intros ? InPsTe. apply ps_rd_te_dual in InPsTe.
      apply psrd_is_pird_rpl in InPsTe as [] ; auto.
      apply Intersection_intro ; [apply pi_rd_te_dual | apply rpl_tpc_dual] ; assumption.
    * intros ? [InPiTe InTpc].
      apply ps_rd_te_dual.
      apply psrd_is_pird_rpl ; auto.
      apply Intersection_intro ; [apply pi_rd_te_dual | apply rpl_tpc_dual] ; assumption.
    Qed.

  End HyperPropertyRelations.

  Ltac rewrite_eq_expr_evals s0' s1' :=
    lazymatch goal with
      | [Loops0 : LoopsN ?e ?c ?s0 s0' ?n,
          Loops1 : LoopsN ?e ?c ?s1 s1' ?n,
          DEqStore : deq_store ?G ?D ?s0 ?s1 |- _]
        => assert (evalExpr e s0' = evalExpr e s1') as EvalEq
            by (eapply deq_expr_eval with G D _ _ ; eauto using loops_store_deq, WhileT)
          ; rewrite <- EvalEq in *
    end.

  Ltac handle_loop_cnt_contradict :=
    repeat match goal with
      | [Loops0 : LoopsN ?e ?c _ _ ?n, Loops1 : LoopsN ?e ?c _ _ (S ?n) |- _]
        => inversion Loops1 ; subst ; clear Loops1
      | [Loops0 : LoopsN ?e ?c ?s0 ?s0' ?n,
          Loops1 : LoopsN ?e ?c ?s1 ?s1' ?n,
          DEqStore : deq_store _ ?D ?s0 ?s1,
          Eval0 : evalExpr ?e ?s0' = Some ?m0,
          Eval1 : evalExpr ?e ?s1' = Some ?m1 |- _]
        => lazymatch m0 with
          | 0 => match m1 with | 0 => fail | S _ => idtac end
          | S _ => match m1 with | 0 => idtac | S _ => fail end
          end
          ; rewrite_eq_expr_evals s0' s1' ; handle_simple_contradict
    end.

  Section NmifUtilities.

    Lemma while_pair_trilemma : forall {G pc e c}, ExprType G e pc -> G;; pc |- c -| pc
        -> forall {s0 s1}, never_stuck (While e c) s0 -> never_stuck (While e c) s1
        -> forall D `(LowSet D), In Label D pc -> deq_store G D s0 s1
        -> (converge (While e c) s0 /\ converge (While e c) s1)
          \/ (forall n, exists s0' s1', LoopsN e c s0 s0' n /\ LoopsN e c s1 s1' n)
          \/ (exists n s0' s1' m, LoopsN e c s0 s0' n /\ LoopsN e c s1 s1' n
                /\ evalExpr e s0' = Some (S m) /\ (diverge c s0' \/ diverge c s1')).
      intros G pc e c WTe WTc s0 s1 NStuck0 NStuck1 D DecD LowD LowPc DEqStore.
      set (WTwhile := WhileT G pc e c WTe WTc).
      destruct (never_stuck_while_trilemma NStuck0) as [ConvS0 | [(n0 & s0' & m0 & ? & ? & ?) | DivgS0]].
      * destruct (never_stuck_conv_or_divg (While e c) s1 NStuck1) as [| DivgS1] ; auto.
        apply conv_while_fin_loops in ConvS0 as (n0 & s0' & ? & ?).
        destruct (divg_while_options DivgS1 (S n0)) as [[] | (n1 & s1' & ? & ? & ? & ? & LtN)]
        ; [handle_loop_cnt_contradict |].
        assert (exists s, LoopsN e c s0 s n1) as [s0'' ?] by eauto using loops_lt, le_S_n.
        right ; right ; rewrite_eq_expr_evals s0'' s1' ; eauto 9.
      * destruct (never_stuck_while_trilemma NStuck1) as [ConvS1 | [(n1 & s1' & m1 & ? & ? & DivgS1) | DivgS1]].
        - apply conv_while_fin_loops in ConvS1 as (n1 & ? & ? & ?).
          destruct (le_dec n1 n0) as [N1LeN0 | N0LtN1].
          + destruct N1LeN0 as [| n0]
            ; [| assert (exists s'', LoopsN e c s0 s'' (S n1)) as [? Loops0'] by eauto using loops_lt, le_n_S ; inversion Loops0']
            ; handle_loop_cnt_contradict.
          + inversion N0LtN1 ; subst ; [handle_loop_cnt_contradict |].
            assert (exists s'', LoopsN e c s1 s'' n0) as [] by eauto using loops_lt.
            right ; right ; eauto 9.
        - destruct (le_dec n0 n1)
          ; [assert (exists s'', LoopsN e c s1 s'' n0) as [? ?] by eauto using loops_lt
            | assert (exists s'', LoopsN e c s0 s'' n1) as [s0'' ?] by eauto using loops_lt
              ; rewrite_eq_expr_evals s0'' s1']
          ; right ; right ; eauto 9.
        - destruct (DivgS1 n0).
          right ; right ; eauto 9.
      * destruct (never_stuck_while_trilemma NStuck1) as [ConvS1 | [(n1 & s1' & ? & Loops1 & ? & DivgS1) | DivgS1]].
        - apply conv_while_fin_loops in ConvS1 as (n1 & ? & ? & ?).
          destruct (DivgS0 (S n1)) as [? LoopS0] ; handle_loop_cnt_contradict.
        - destruct (DivgS0 n1) as [s0' ?].
          rewrite_eq_expr_evals s0' s1'.
          right ; right ; eauto 9.
        - right ; left ; intro n.
          destruct (DivgS0 n) ; destruct (DivgS1 n) ; eauto.
    Qed.

    Lemma psni_conv : forall G pc c nt, G;; pc |- c -| nt
        -> forall s0 s1, converge c s0
        -> forall st0 st1, Produces c s0 st0 -> Produces c s1 st1
        -> forall D, (forall pfx0, pfx0 <=| (s0, st0) -> exists pfx1, pfx1 <=| (s1, st1) /\ pfx0 =[G, D] pfx1)
        -> converge c s1.
      unfold converge.
      intros G pc c nt WTc s0 s1 (lst0 & s0' & MStep0) st0 st1 Prod0 Prod1 D PsniProp.
      dependent induction MStep0 using mstep_rev_ind ; [handle_simple_contradict |].
      destruct cs1 as [c0 s0''].
      assert (G;; pc |- c0 -| nt) by (eapply mstep_type_pres_not_stop ; eauto ; intro ; subst ; handle_simple_contradict).
      assert (a = StopEvt) by eauto using wt_step_to_stop_impl_stop_evt ; subst.
      assert (exists pfx1, pfx1 <=| (s1, st1) /\ (s0, lst ++ [StopEvt]) =[G, D] pfx1) as (? & Pfx1OfT1 & DEqPfx)
        by (apply PsniProp ; apply LeTrace_intro
            ; eapply prod_mstep_prefix with c s0 (Stop, s0') ; eauto using mstep_append).
      inversion Pfx1OfT1 as [? lst1] ; subst.
      assert (exists cs, (c, s1) ==>*[lst1] cs) as [[c1 s1'] ?] by eauto using prod_prefix_mstep.
      assert (exists lst1', lst1 = lst1' ++ [StopEvt]) as [lst1' ?]
        by (inversion DEqPfx ; subst ; eauto using deq_mstep_stop with deq) ; subst.
      assert (c1 = Stop) by eauto using mstep_to_stop_evt ; subst.
      eauto.
    Qed.

    Definition trc_prpnd (pfx : TracePfx) (tr : Trace) := (fst pfx, prepend (snd pfx) (snd tr)).

    Lemma trace_prepend_cons : forall s a s' st, (s, ConsEvt a st) = trc_prpnd (s, [a]) (s', st).
      auto.
    Qed.

    Lemma converge_c1_prod_under_seq : forall c1 c2 s lst s', (c1, s) ==>*[lst] (Skip, s')
        -> forall st, Produces (Seq c1 c2) s st
        -> exists st', Produces c2 s' st'.
      intros c1 c2 s lst s' MStep.
      dependent induction MStep ; intros st Prod
      ; inversion Prod as [? ? ? ? ? st' Step |] ; subst.
      * inversion Step as [| ? ? ? ? ? ? c'NotStop Step' | | | | | | |] ; subst
        ; [inversion Step' ; subst ; contradict c'NotStop |] ; eauto.
      * destruct cs1 as [c1' s''].
        assert ((Seq c1 c2, s) -->[a] (Seq c1' c2, s''))
          by (apply SeqCE ; auto ; intro ; subst ; inversion MStep ; handle_simple_contradict).
        subst_eq_steps.
        apply IHMStep with c1' s'0 st' ; auto.
    Qed.

    Lemma ctx_prod_c_deq : forall D `(LowSet D) G pc c nt, G;; pc |- c -| nt
        -> forall E, EvalCtx E
        -> forall s0 s1 st0 st1 st1', Produces c s0 st0 -> Produces (E c) s1 st1 -> Produces c s1 st1'
        -> forall pfx0 pfx1, pfx0 <=| (s0, st0) -> pfx1 <=| (s1, st1)
        -> pfx0 =[G, D] pfx1
        -> exists pfx1', pfx1' <=| (s1, st1') /\ pfx0 =[G, D] pfx1'.
      intros D DecD LowD G pc c nt WTc E CtxE s0 s1 st0 st1 st1' Prod0 Prod1 Prod1'
        pfx0 pfx1 Pfx0OfT0 Pfx1OfT1 DEqPfx.
      inversion Pfx0OfT0 as [? lst0] ; inversion Pfx1OfT1 as [? lst1] ; subst.
      inversion DEqPfx ; subst.
      enough (exists lst1' cs, (c, s1) ==>*[lst1'] cs /\ deq_evt_lst G D lst0 lst1') as (lst1' & ? & ? & ?)
        by eauto 6 using DEqPfx_intro, LeTrace_intro, prod_mstep_prefix.
      assert (exists cs, (E c, s1) ==>*[lst1] cs) as [[] MStep] by eauto using prod_prefix_mstep.
      inversion CtxE ; subst
      ; [destruct (mstep_seq_inv MStep) as [(? & ? & ?) | (lst1Fin & ? & s1' & ? & ? & ?)]
        | destruct (mstep_pdown_inv MStep) as [(? & ? & ?) | (lst1Fin & ? & ?)]]
      ; eauto
      ; assert ((s0, lst0) <=[G, D] (s1, lst1Fin ++ [StopEvt])) as (? & PfxOfT1 & DEqPfx')
          by (assert (exists cs, (c, s0) ==>*[lst0] cs) as [] by eauto using prod_prefix_mstep
              ; assert (In Property (PiniD G D) (behavior c)) as InPini by eauto using wt_pini_d ; unfold PiniD, In in InPini
              ; eapply pini_one_converge ; eauto using mstep_append, StopE
              ; intros
              ; apply InPini with (s0, st0) (s1, st1') ; try unfold behavior, In ; eauto using LeTrace_intro, prod_mstep_prefix)
      ; inversion PfxOfT1 as [lst1'] ; subst ; inversion DEqPfx' ; subst
      ; assert (exists cs, (c, s1) ==>*[lst1'] cs) as [] by eauto using prefix_mstep, mstep_append, StopE
      ; eauto.
    Qed.

    Lemma deq_around : forall D `(LowSet D) G pc c nt, G;; pc |- c -| nt
        -> forall s0 s1 c' lst0, c' <> Stop -> (exists s0', (c, s0) ==>*[lst0] (c', s0'))
        -> forall lstTerm, (exists s0', (c, s0) ==>*[lstTerm] (Skip, s0'))
        -> forall lst1, (exists s1', (c, s1) ==>*[lst1] (Skip, s1'))
        -> forall lst1', (s0, lst0) =[G, D] (s1, lst1 ++ lst1')
        -> (s0, lst0) =[G, D] (s0, lstTerm).
      intros D DecD ? G pc c nt WTc s0 s1 c' lst0 c'NotStop [s0' MStep0] lstTerm [s0Term MStepTerm0] lst1 [? MStepTerm1] lst1' DEqPfx.
      apply dle_pfx_antisym.
      * exists (s0, lst0) ; split ; [apply LePfx_intro | auto with deq].
        assert (exists lst0', (c', s0') ==>*[lst0'] (Stop, s0Term) /\ lst0 ++ lst0' = lstTerm ++ [StopEvt]) as (? & MStep0' & LstVal)
          by eauto using mstep_prefix_stop, mstep_append, StopE.
        invert_tail mstep_iff_msteptl MStep0'.
        - rewrite -> app_assoc in LstVal ; apply app_inj_tail in LstVal as [] ; subst.
          rewrite -> prefix_as_append ; eauto.
      * apply deq_dle_pfx with (s1, lst1 ++ lst1') ; auto with deq.
        exists (s1, lst1) ; split.
        - apply LePfx_intro.
          rewrite -> prefix_as_append ; eauto.
        - inversion DEqPfx ; subst.
          apply DEqPfx_intro ; auto.
          apply deq_app_same_inv with StopEvt.
          eauto using pini_conv_lst, mstep_append, StopE.
    Qed.

  End NmifUtilities.

  Section PsRdProof.

    Context (G : Varname -> option Label).
    Context (P T : Ensemble Label).
    Context {DecP : DecideIn P} {LowP : LowSet P}.
    Context {DecT : DecideIn T} {LowT : LowSet T}.
    Context {AtkPT : Attacker P T}.

    Theorem untrusted_pc_psrd : forall pc c nt, G;; pc |- c -| nt
        -> In Label (Union Label P T) nt -> ~ In Label T pc -> In Property (PsRdA G P T) (behavior c).
      intros pc c nt WTc LowNt UntrustPc.
      apply psni_in_psrd.
      destruct (pc_flow_or_psni G pc c nt WTc) as [FTpcnt |].
      * assert (~ In Label T nt) by eauto using high_set_up_closed.
        destruct LowNt as [nt PubNt |] ; [| exfalso ; auto].
        eauto using high_pc_low_nt_psni, attacker_symmetry.
      * unfold Psni, In in *. eauto.
    Qed.

    Theorem untrusted_pc_rpl : forall {pc c nt}, G;; pc |- c -| nt
        -> In Label (Union Label P T) nt -> ~ In Label T pc -> In Property (RplA G P T) (behavior c).
      intros pc c nt WTc LowNt UntrustPc.
      pose proof (untrusted_pc_psrd pc c nt WTc LowNt UntrustPc) as InPsRd.
      apply psrd_is_pird_rpl in InPsRd ; [destruct InPsRd | |] ; assumption.
    Qed.

    Theorem secret_pc_rpl : forall pc c nt, G;; pc |- c -| nt
        -> In Label (Union Label P T) nt -> ~ In Label P pc -> In Property (RplA G P T) (behavior c).
      intros pc c nt WTc LowNt SecretPc.
      destruct (pc_flow_or_lfp G pc c nt WTc) as [FTpcnt |].
      * assert (~ In Label P nt) by eauto using high_set_up_closed.
        destruct LowNt as [| nt TrustNt] ; [exfalso ; auto |].
        unfold RplA, In.
        intros [s00 st00] [s01 st01] [s10 st10] [s11 st11]
               [Prod00 Prod01 Prod10 Prod11 ? ? ? ?]
               pfx PfxOfT00 ? pfx0 pfx1 Pfx0OfT01 Pfx1OfT11 TEqPfxPfx0 PLtPfx.
        inversion PfxOfT00 as [? lst] ; inversion Pfx0OfT01 as [? lst0] ; inversion Pfx1OfT11 as [? lst1] ; subst.
        unfold In, behavior in * ; simpl in *.
        assert (never_stuck c s00) as NStuck00 by eauto using prod_nstuck.
        assert (never_stuck c s01) as NStuck01 by eauto using prod_nstuck.
        assert (never_stuck c s10) as NStuck10 by eauto using prod_nstuck.
        assert (never_stuck c s11) as NStuck11 by eauto using prod_nstuck.
        pose proof (mstep_containment G P pc c nt s11 WTc NStuck11 SecretPc) as [| (? & ? & ? & ?)]
        ; [| apply conv_lfp with pc c nt s01 st01 lst0 ; try unfold converge ; eauto].
        contradiction not_dlt_empty with G P lst0 (s11, lst1) s01.
        pose proof (mstep_containment G P pc c nt s01 WTc NStuck01 SecretPc) as [| (lst01 & ? & ? & PEqPfx01Nil)]
        ; [assert (exists cs, (c, s01) ==>*[lst0] cs) as [? ?] ; eauto using prod_prefix_mstep |].
        assert (In Property (PsniD G T) (behavior c)) as InPsni by (apply high_pc_low_nt_psni with P DecP LowP DecT LowT pc nt ; auto).
        unfold PsniD, In in InPsni.
        pose proof (mstep_containment G P pc c nt s00 WTc NStuck00 SecretPc) as [| (lst00 & ? & ? & ?)]
        ; pose proof (mstep_containment G P pc c nt s10 WTc NStuck10 SecretPc) as [Silent10 | (? & ? & ? & ?)]
        ; assert (deq_store G T s01 s00) by auto with deq
        ; try lazymatch goal with
          | [Conv : (?c, ?s0) ==>*[_] _, Silent : silent G P ?c ?s1,
            Prod0 : Produces ?c ?s0 ?st0, Prod1 : Produces ?c ?s1 ?st1,
            H : deq_store G T ?s0 ?s1 |- _]
            => contradiction converge_impl_not_diverge with c s1
                ; [apply psni_conv with G pc nt s0 st0 st1 T ; try unfold converge ; eauto
                    ; apply InPsni ; unfold behavior ; simpl ; auto with deq
                  | apply wt_silent_impl_diverge with P G pc nt ; auto]
        end.
        enough (Prefix lst0 lst01) as Prefix0Of01
          by (inversion PEqPfx01Nil as [? ? ? ? ? PEqLst01Nil] ; subst
              ; eapply prefix_erase in Prefix0Of01
              ; eapply deq_impl_erase_lst in PEqLst01Nil
              ; rewrite -> PEqLst01Nil in Prefix0Of01
              ; inversion Prefix0Of01 ; eauto using erase_lst_impl_deq).
        assert (lst0 = lst01 ++ [StopEvt] \/ Prefix lst0 lst01) as [|] by (apply eq_or_prefix ; eauto using prod_conv_prefix)
        ; [| assumption].
        assert (exists pfx1, pfx1 <=| (s10, st10) /\ (s00, lst) =[G, P] pfx1) as (? & Pfx1Of10 & PEqPfx1) by eauto with deq.
        inversion Pfx1Of10 ; subst.
        inversion PEqPfx1 as [? ? ? ? ? PEqLst] ; inversion TEqPfxPfx0 as [? ? ? ? ? TEqLst] ; subst.
        assert (exists lst', lst = lst' ++ [StopEvt]) as [lst' ?]
          by (assert (exists cs, (c, s00) ==>*[lst] cs) as [cs ?] by eauto using prod_prefix_mstep
              ; apply deq_mstep_stop with G T c s00 cs lst01 ; auto) ; subst.
        contradiction app_cons_not_nil with Event (erase_evt_lst G P lst') [] StopEvt ; symmetry.
        rewrite <- erase_nil with G P DecP.
        rewrite <- non_erase_low ; [| intro ; handle_simple_contradict].
        rewrite <- erase_app_distr.
        apply deq_impl_erase_lst.
        assert (exists cs, (c, s10) ==>*[lst2] cs) as [? ?] by eauto using prod_prefix_mstep.
        transitivity lst2 ; eauto.
      * apply lfp_in_rpl. unfold Lfp, In in *. eauto.
    Qed.

    Theorem secret_pc_psrd : forall pc c nt, G;; pc |- c -| nt
        -> In Label (Union Label P T) nt -> ~ In Label P pc -> In Property (PsRdA G P T) (behavior c).
      intros. apply psrd_is_pird_rpl ; auto ; apply Intersection_intro.
      * apply pini_in_pird. eauto using wt_pini_d.
      * eauto using secret_pc_rpl.
    Qed.

    (* This proof is a mess and has a bunch of duplicated tactics that can probably be cleaned up. *)
    Lemma prepend_equiv : forall t00 t01 t10 t11,
        deq_store G P (t_input t00) (t_input t10) -> deq_store G T (t_input t00) (t_input t01)
        -> deq_store G P (t_input t01) (t_input t11) -> deq_store G T (t_input t10) (t_input t11)
        -> (forall pfx, pfx <=| t00
          -> (forall pfx0, pfx0 <=| t00 -> pfx =[G, T] pfx0 -> exists pfx1, pfx1 <=| t10 /\ pfx0 =[G, P] pfx1)
          -> (forall pfx0, pfx0 <=| t01 -> pfx =[G, T] pfx0 -> exists pfx1, pfx1 <=| t11 /\ pfx0 =[G, P] pfx1))
        -> forall p00 p01 p10 p11, p00 =[G, P] p10 -> p00 =[G, T] p01 -> p01 =[G, P] p11 -> p10 =[G, T] p11
        -> forall pfx, pfx <=| (trc_prpnd p00 t00)
        -> (forall pfx0, pfx0 <=| (trc_prpnd p00 t00) -> pfx =[G, T] pfx0 -> exists pfx1, pfx1 <=| (trc_prpnd p10 t10) /\ pfx0 =[G, P] pfx1)
        -> (forall pfx0, pfx0 <=| (trc_prpnd p01 t01) -> pfx =[G, T] pfx0 -> exists pfx1, pfx1 <=| (trc_prpnd p11 t11) /\ pfx0 =[G, P] pfx1).
      intros [s00' st00] [s01' st01] [s10' st10] [s11' st11] ? ? ? ? InPsRd [s00 lst00] [s01 lst01] [s10 lst10] [s11 lst11].
      intros ? ? ? ? pfx PfxOfTrc.
      intros PsNi0 pfx0 Pfx0OfT01 TEquiv.
      unfold trc_prpnd in * ; simpl in *.
      inversion Pfx0OfT01 as [? lst0 ? EvtPfx01] ; subst.
      destruct (prefix_of_prepend_inv lst01 lst0 st01 EvtPfx01) as [| (lst0' & ? & ?)].
      * assert ((s01, lst0) <=[G, P] (s11, lst11)) as (? & Pfx1'Of11 & ?) by eauto using pfx_deq_impl_dle, LePfx_intro.
        inversion Pfx1'Of11 as [lst1] ; subst.
        eauto using LeTrace_intro, prefix_of_prepend.
      * inversion PfxOfTrc as [? lst ? EvtPfx] ; subst.
        enough (exists pfx1, (pfx1 <=| (s11', st11) /\ (s01', lst0') =[G, P] pfx1)) as (? & Pfx1OfT11 & ?)
          by (inversion Pfx1OfT11 as [? lst1'] ; subst
              ; repeat lazymatch goal with
                | [H : _ =[G, P] _ |- _] => inversion H ; clear H
              end ; subst
              ; exists (s11, lst11 ++ lst1')
              ; auto using LeTrace_intro, DEqPfx_intro, prepend_to_prefix, deq_app).
        destruct (prefix_of_prepend_inv lst00 lst st00 EvtPfx) as [| (lst0'' & ? & ?)].
        - assert (deq_evt_lst G T lst0' []) by
            (apply deq_app_nil with lst lst01 ; try apply pfx_deq_inv_list with s00 s01 ; try assumption
              ; apply dle_pfx_antisym
                ; [apply pfx_deq_impl_dle with (s00, lst00)
                  | assert (exists lst', Prefix lst' lst /\ deq_evt_lst G T lst' lst01) as (lst' & ? & ?)
                      by eauto using pfx_deq_inv_list, deq_app_opt_inv
                    ; inversion TEquiv ; exists (s00, lst')]
                ; auto using LePfx_intro, DEqPfx_intro with deq).
          apply InPsRd with (s00', []) ; auto using LeTrace_intro, EvtPrefix_empty, DEqPfx_intro with deq.
          intros ? Pfx0Of00 TEqPfx0Nil. inversion Pfx0Of00 as [? lst0 ? EvtPfx00] ; subst.
          assert (exists pfx1, pfx1 <=| (s10, prepend lst10 st10) /\ (s00, lst00 ++ lst0) =[G, P] pfx1) as (? & NewPfxOf10 & ?)
            by (apply PsNi0
                ; [auto using LeTrace_intro, prepend_to_prefix
                  | apply DEqPfx_intro ; auto with deq
                    ; inversion TEqPfx0Nil ; subst
                    ; rewrite <- app_nil_r with Event lst
                    ; apply deq_app ; auto
                    ; transitivity lst01 ; eauto using pfx_deq_inv_list with deq
                    ; apply deq_app_nil_r with lst0' ; eauto using pfx_deq_inv_list]).
          inversion NewPfxOf10 as [? ? ? EvtPfxOfPrepend] ; subst.
          destruct (prefix_of_prepend_inv lst10 lst1 st10 EvtPfxOfPrepend) as [| (? & ? & ?)]
          ; subst
          ; [exists (s10', []) ; split ; try apply DEqPfx_intro ; auto using LeTrace_intro, EvtPrefix_empty
            | eauto 8 using LeTrace_intro, DEqPfx_intro, deq_app_inv, pfx_deq_inv_list].
          apply deq_app_nil with lst1 lst00 ; try apply pfx_deq_inv_list with s10 s00 ; auto with deq.
          apply dle_pfx_antisym
          ; [apply pfx_deq_impl_dle with (s10, lst10)
            | apply deq_dle_pfx with (s00, lst00 ++ lst0)]
          ; auto using LePfx_intro with deq.
          unfold dle_pfx. exists (s00, lst00) ; split ; try (apply LePfx_intro ; apply prefix_as_append) ; eauto with deq.
        - subst.
          apply InPsRd with (s00', lst0'') ; eauto using LeTrace_intro, DEqPfx_intro, delete_from_prefix, deq_app_inv, pfx_deq_inv_list.
          intros ? Pfx0Of00 TEqPfx0Nil. inversion Pfx0Of00 as [? lst0 ? EvtPfx00] ; subst.
          assert (exists pfx1, pfx1 <=| (s10, prepend lst10 st10) /\ (s00, lst00 ++ lst0) =[G, P] pfx1) as (? & NewPfxOf10 & ?)
            by (apply PsNi0
                ; [auto using LeTrace_intro, prepend_to_prefix
                  | apply DEqPfx_intro ; auto with deq ; inversion TEqPfx0Nil ; subst ; apply deq_app ; auto with deq]).
          inversion NewPfxOf10 as [? lst1 ? EvtPfxOfPrepend] ; subst.
          pose proof (prefix_of_prepend_inv lst10 lst1 st10 EvtPfxOfPrepend) as [| (lst1' & ? & ?)]
          ; subst
          ; [exists (s10', []) ; split ; try apply DEqPfx_intro ; auto using LeTrace_intro, EvtPrefix_empty
            | exists (s10', lst1') ; eauto 8 using LeTrace_intro, DEqPfx_intro, deq_app_inv, pfx_deq_inv_list].
          apply deq_app_nil with lst1 lst00 ; try apply pfx_deq_inv_list with s10 s00 ; auto with deq.
          apply dle_pfx_antisym
          ; [apply pfx_deq_impl_dle with (s10, lst10)
            | apply pfx_deq_impl_dle with (s00, lst00 ++ lst0)
              ; try (apply LePfx_intro ; apply prefix_as_append)]
          ; eauto using LePfx_intro, DEqPfx_intro with deq.
    Qed.

    Lemma psrd_not_one_conv : forall pc c nt, G;; pc |- c -| nt
        -> In Property (PsRdA G P T) (behavior c)
        -> forall s00 s01 s10 s11, deq_store G P s00 s10 -> deq_store G T s00 s01 -> deq_store G P s01 s11 -> deq_store G T s10 s11
        -> forall st00 st01 st10 st11, Produces c s00 st00 -> Produces c s01 st01 -> Produces c s10 st10 -> Produces c s11 st11
        -> converge c s00 -> converge c s01 -> converge c s10
        -> converge c s11.
      unfold PsRdA, In, converge.
      intros pc c nt WTc InPsRd s00 s01 s10 s11 ? ? ? ? st00 st01 st10 st11 ? ? ? ?
        (lst00 & s00' & MStep00) (lst01 & s01' & MStep01) (lst10 & s10' & MStep10).
      assert (exists pfx1, pfx1 <=| (s11, st11) /\ (s01, lst01) =[G, P] pfx1) as (? & PfxOfT11 & DEqPfx).
      * apply InPsRd with (s00, st00) (s01, st01) (s10, st10) (s00, lst00) ; eauto using LeTrace_intro, prod_mstep_prefix.
        - apply NmifInput_intro ; try unfold behavior, In ; simpl ; auto.
        - intros. apply pini_lfp_impl_psni with (fun pfx => True) (s00, st00) ; auto.
          + assert (In Property (PiniD G P) (behavior c)) as InPini by eauto using wt_pini_d ; unfold PiniD, In in InPini.
            intros. apply InPini with (s00, st00) (s10, st10) ; try unfold behavior ; auto.
          + intros ? ? PfxOf00 PfxOf10 ? ?.
            inversion PfxOf00 ; inversion PfxOf10 ; subst.
            eapply conv_lfp with pc c nt s00 st00 ?[lst] ; try unfold converge ; eauto.
        - intros. apply DEqPfx_intro ; auto.
          apply pini_conv_lst with DecT pc c nt s00 s00' s01 s01' ; auto.
      * inversion PfxOfT11 as [s11' lst11] ; subst.
        pose proof (wt_mstep_stop_lst WTc MStep01) as [lst01' ?] ; subst.
        inversion DEqPfx as [? ? ? ? ? DEqLst] ; subst.
        assert (exists cs, (c, s11) ==>*[lst11] cs) as [[c11 s11'] MStep11] by eauto using prod_prefix_mstep.
        assert (exists lst11', lst11 = lst11' ++ [StopEvt]) as [lst11' ?] by eauto using mstep_deq_stop ; subst.
        assert (c11 = Stop) by eauto using mstep_to_stop_evt ; subst.
        eauto.
    Qed.

    Lemma ctx_psrd_s01_from_c1 : forall pc c1 nt, G;; pc |- c1 -| nt
        -> In Property (PsRdA G P T) (behavior c1)
        -> forall E, EvalCtx E
        -> forall t00 s01 st01 t10 t11, nmif_input_match G P T (behavior (E c1)) t00 (s01, st01) t10 t11
        -> forall pfx, pfx <=| t00
        -> (forall pfx0, pfx0 <=| t00 -> pfx =[G, T] pfx0 -> exists pfx1, pfx1 <=| t10 /\ pfx0 =[G, P] pfx1)
        -> forall lst0 c1' s01', (c1, s01) ==>*[lst0] (c1', s01')
        -> c1' <> Stop
        -> pfx =[G, T] (s01, lst0)
        -> exists pfx1, pfx1 <=| t11 /\ (s01, lst0) =[G, P] pfx1.
      intros pc c1 nt WTc1 InPsRdC1 E CtxE
        [s00 st00] s01 st01 [s10 st10] [s11 st11]
        [Prod00 Prod01 Prod10 Prod11 ? ? ? ?]
        pfxRaw ? ? lst0 c1' s01' MStep01 c1'NotStop ? ; unfold In, behavior in * ; simpl in *.
      assert (exists st00', Produces c1 s00 st00') as [st00' ?] by eauto using nstuck_ex_stream, never_stuck_ctx, prod_nstuck.
      assert (exists st01', Produces c1 s01 st01') as [st01' ?] by eauto using nstuck_ex_stream, never_stuck_ctx, prod_nstuck.
      assert (exists st10', Produces c1 s10 st10') as [st10' ?] by eauto using nstuck_ex_stream, never_stuck_ctx, prod_nstuck.
      assert (exists st11', Produces c1 s11 st11') as [st11' ?] by eauto using nstuck_ex_stream, never_stuck_ctx, prod_nstuck.
      assert ((s01, lst0) <=| (s01, st01')) by eauto using LeTrace_intro, prod_mstep_prefix.
      assert (exists pfx, pfx <=| (s00, st00') /\ (s01, lst0) =[G, T] pfx) as (pfx & PfxOfT00 & DEqPfx0Pfx)
        by (apply ctx_prod_c_deq with DecT pc c1 nt E s01 st01' st00 pfxRaw ; eauto with deq).
      inversion PfxOfT00 as [? lst] ; subst.
      assert (exists pfx1, pfx1 <=| (s11, st11') /\ (s01, lst0) =[G, P] pfx1) as (pfx1 & Pfx1OfT11 & DEqLst).
      * unfold PsRdA, In in InPsRdC1.
        apply InPsRdC1 with (s00, st00') (s01, st01') (s10, st10') (s00, lst)
        ; try apply NmifInput_intro ; try unfold behavior, In ; auto with deq.
        intros pfx0 Pfx0OfT00 TEqPfx.
        assert (pfx0 <=| (s00, st00)).
        - inversion Pfx0OfT00 as [? lst00] ; subst.
          assert (exists cs, (c1, s00) ==>*[lst00] cs) as [[c1'' s00'] ?] by eauto using prod_prefix_mstep.
          apply LeTrace_intro.
          apply prod_mstep_prefix with (E c1) s00 (E c1'', s00') ; auto.
          apply step_under_ctx ; auto.
          (* We've now reduced this to a proof that c1'' <> Stop.
             For that, we assume the equality holds and use that to show that pfx0 ends in StopEvt,
             so lst does too, meaning lst0 ends in StopEvt,
             and thus c1' = Stop, contradicting an assumption. *)
          intro ; subst.
          assert (exists lst00', lst00 = lst00' ++ [StopEvt]) as [lst00' ?] by eauto using wt_mstep_stop_lst ; subst.
          inversion TEqPfx ; subst.
          assert (exists lst', lst = lst' ++ [StopEvt]) as [lst' ?]
            by (assert (exists cs, (c1, s00) ==>*[lst] cs) as [] by eauto using prod_prefix_mstep
                ; eauto using deq_mstep_stop) ; subst.
          assert (exists lst0', lst0 = lst0' ++ [StopEvt]) as [lst0' ?]
            by (inversion DEqPfx0Pfx
                ; eauto using deq_mstep_stop) ; subst.
          contradict c1'NotStop.
          eauto using mstep_to_stop_evt.
        - assert (pfxRaw =[G, T] pfx0) by (transitivity (s00, lst) ; [transitivity (s01, lst0) |] ; auto with deq).
          assert (exists pfx1, pfx1 <=| (s10, st10) /\ pfx0 =[G, P] pfx1) as (pfx1 & ? & ?) by eauto.
          apply ctx_prod_c_deq with DecP pc c1 nt E s00 st00' st10 pfx1 ; auto.
      * exists pfx1.
        inversion Pfx1OfT11 as [? lst1] ; subst.
        split ; [apply LeTrace_intro | assumption].
        assert (exists cs, (c1, s11) ==>*[lst1] cs) as [[c1'' s11'] MStep11] by eauto using prod_prefix_mstep.
        apply prod_mstep_prefix with (E c1) s11 (E c1'', s11') ; [assumption |].
        apply step_under_ctx ; auto.
        (* To prove that c1'' <> Stop, we need to show that, if it does, lst0 ends in StopEvt, so c1' = Stop. *)
        intro ; subst.
        assert (exists lst1', lst1 = lst1' ++ [StopEvt]) as [lst1' ?] by eauto using wt_mstep_stop_lst ; subst.
        assert (exists lst0', lst0 = lst0' ++ [StopEvt]) as [lst0' ?]
          by (inversion DEqLst ; subst ; eauto using mstep_deq_stop with deq) ; subst.
        contradict c1'NotStop.
        eauto using mstep_to_stop_evt.
    Qed.

    Lemma diverge_c1_s00_seq_psrd : forall pc c1 nt' pc' c2 nt, G;; pc |- c1 -| nt'
        -> flows_to nt' pc' -> flows_to pc pc'
        -> G;; pc' |- c2 -| nt
        -> flows_to nt' nt
        -> In Label (Union Label P T) nt
        -> In Property (PsRdA G P T) (behavior c1)
        -> forall t00 s01 st01 t10 t11, nmif_input_match G P T (behavior (Seq c1 c2)) t00 (s01, st01) t10 t11
        -> diverge c1 (t_input t00)
        -> forall pfx, pfx <=| t00
        -> (forall pfx0, pfx0 <=| t00 -> pfx =[G, T] pfx0 -> exists pfx1, pfx1 <=| t10 /\ pfx0 =[G, P] pfx1)
        -> forall lst01 lst01' s01Mid cs01, (c1, s01) ==>*[lst01'] (Skip, s01Mid)
        -> (c2, s01Mid) ==>*[lst01] cs01
        -> pfx =[G, T] (s01, lst01' ++ NoEvt :: lst01)
        -> exists pfx1, pfx1 <=| t11 /\ (s01, lst01' ++ NoEvt :: lst01) =[G, P] pfx1.
      intros pc c1 nt' pc' c2 nt WTc1 ? ? WTc2 ? LowNt InPsRdC1
        [s00 st00] s01 st01 [s10 st10] [s11 st11]
        [Prod00 Prod01 Prod10 Prod11 ? ? ? ?]
        DivgS00 pfx PfxOfT00 ? lst01 lst01' s01Mid ? ? ? ? ; unfold In, behavior in * ; simpl in *.
      assert (Produces c1 s00 st00) by eauto using diverge_prod_under_seq.
      inversion PfxOfT00 as [? lst] ; subst.
      assert (exists st01', Produces c1 s01 st01') as [st01' ?] by eauto using nstuck_ex_stream, never_stuck_seq_c1, prod_nstuck.
      (* First prove that lst is T-equivalent to lst01', which is all (c1, s01) does before terminating. *)
      assert ((s00, lst) =[G, T] (s01, lst01')).
      * (* This uses antisymmetry of <=[T]. *)
        apply dle_pfx_antisym
        (* One direction is trivial, the other is not. *)
        ; [| apply pfx_deq_impl_dle with (s01, lst01' ++ NoEvt :: lst01)
            ; [apply LePfx_intro ; apply prefix_as_append |] ; eauto with deq].
        assert (exists cs, (c1, s00) ==>*[lst] cs) as [[c1' ?] MStepLst] by eauto using prod_prefix_mstep.
        (* Use Pini to prove that lst <=[T] lst01' ++ [StopEvt]. *)
        assert ((s00, lst) <=[G, T] (s01, lst01')) as (? & PfxLe01 & DEqPfx).
        - assert (In Property (PiniD G T) (behavior c1)) as InPini by eauto using wt_pini_d ; unfold PiniD, In in InPini.
          eapply pini_one_converge_skip with DecT c1 _ _ _ ; eauto using mstep_append, StopE
          ; [intros ; apply InPini with (s00, st00) (s01, st01')
              ; try unfold behavior, In ; simpl ; eauto using LeTrace_intro, prod_mstep_prefix
            | intro ; subst ; apply DivgS00 in MStepLst as (? & ? & ?) ; handle_simple_contradict].
        (* Now use the fact that (c1, s00) diverges to prove that it can't be equal. *)
        - inversion PfxLe01 as [lst01''] ; subst ; inversion DEqPfx ; subst.
          unfold dle_pfx. eauto using LePfx_intro, DEqPfx_intro.
      * (* Use conv_divg_deq to prove that nt' \notin T *)
        assert (~ In Label T nt') as UntrustNt'
          by (eapply conv_divg_deq with G DecT lst01' pc c1 s01 s00 _ lst
              ; eauto using mstep_append, StopE, prod_prefix_mstep, prod_nstuck, never_stuck_seq_c1 with deq).
        assert (In Label P nt') as PubNt'
          by (assert (In Label (Union Label P T) nt') as LowNt' by (apply (low_set_union_inst P T).(down_closed) with nt ; assumption)
              ; destruct LowNt' ; [| exfalso] ; auto).
        (* Now split depending on whether (c1, s11) converges or diverges*)
        assert (never_stuck c1 s11) as NStuckC1 by eauto using prod_nstuck, never_stuck_seq_c1.
        destruct (never_stuck_conv_or_divg c1 s11 NStuckC1) as [(lst11Fin & s11Mid & MStep11) |].
        - (* When (c1, s11) converges, show that lst11' =[P] lst01' by Pini. *)
          assert (exists lst11', lst11Fin = lst11' ++ [StopEvt]) as [lst11' ?] by eauto using wt_mstep_stop_lst ; subst.
          assert (deq_evt_lst G P lst01' lst11') as DEqC1Lsts
            by (apply deq_app_same_inv with StopEvt
                ; apply pini_conv_lst with DecP pc c1 nt' s01 s01Mid s11 s11Mid
                ; eauto using mstep_append, StopE).
          (* Now use the fact that nt' \notin T to prove that (behav G c2) \in (PsniD P). *)
          assert (In Property (PsniD G P) (behavior c2)) as InPsniC2
            by (eapply high_pc_low_nt_psni ; eauto using attacker_symmetry, high_set_up_closed
                ; destruct LowNt as [| nt]
                ; [assumption | contradict UntrustNt' ; eauto using LowT.(down_closed)])
          ; unfold PsniD, In in InPsniC2.
          (* Derive an lst11 that corresponds to lst01 from that. *)
          assert (exists st, Produces c2 s01Mid st) as [st01c2 ?] by eauto using converge_c1_prod_under_seq.
          invert_tail mstep_iff_msteptl MStep11.
          repeat lazymatch goal with
            | [H : _ -->[StopEvt] (Stop, _) |- _] => inversion H ; subst ; clear H
          end.
          assert (exists st, Produces c2 s11Mid st) as [st11c2 ?] by eauto using converge_c1_prod_under_seq.
          assert (exists pfx1, pfx1 <=| (s11Mid, st11c2) /\ (s01Mid, lst01) =[G, P] pfx1) as (? & Pfx1OfT11c2 & DEqLstc2)
            by (apply InPsniC2 with (s01Mid, st01c2) ; try unfold behavior, In ; simpl
                ; eauto using LeTrace_intro, prod_mstep_prefix
                ; eapply pini_conv_store with DecP pc c1 nt' s01 _ s11 _
                ; eauto using mstep_append, StopE)
          ; inversion Pfx1OfT11c2 as [? lst11] ; subst.
          exists (s11, lst11' ++ NoEvt :: lst11).
          split.
          + assert (exists cs, (c2, s11Mid) ==>*[lst11] cs) as [cs11 ?] by eauto using prod_prefix_mstep.
            eauto 6 using LeTrace_intro, prod_mstep_prefix, step_concat, MultiStep_some, SeqSkipE, step_under_seq_skip.
          + inversion DEqLstc2 ; subst.
            apply DEqPfx_intro ; [assumption |].
            apply deq_app ; auto using DEqSame.
        - (* When (c1, s11) diverges, we will derive a contradiction. *)
          (* First show that there is some pfx1 <=| t11 wuch that pfx1 =[P] (s01, lst01'). *)
          assert (exists st10', Produces c1 s10 st10') as [st10' ?] by eauto using nstuck_ex_stream, never_stuck_seq_c1, prod_nstuck.
          assert (exists st11', Produces c1 s11 st11') as [st11' ?] by eauto using nstuck_ex_stream, never_stuck_seq_c1, prod_nstuck.
          assert (exists pfx1, pfx1 <=| (s11, st11) /\ (s01, lst01') =[G, P] pfx1) as (? & Pfx1OfT11 & DEqPfx)
            by (apply ctx_psrd_s01_from_c1 with pc c1 nt' (fun c => Seq c c2) (s00, st00) st01 (s10, st10) (s00, lst) Skip s01Mid
                ; auto using SeqCtx
                ; [apply NmifInput_intro ; try unfold behavior, In ; simpl ; auto | discriminate]).
          inversion Pfx1OfT11 as [? lst11'] ; subst.
          (* Then use that to contradict the fact that nt' \in P. *)
          assert (Produces c1 s11 st11) by eauto using diverge_prod_under_seq.
          contradiction conv_divg_deq with G P DecP lst01' pc c1 nt' s01 s11 s01Mid lst11'
          ; eauto using mstep_append, StopE, prod_prefix_mstep, prod_nstuck.
    Qed.

    Lemma restricted_psni_shorter : forall t0 t1 pfx, pfx <=| t0
        -> (forall pfx0, pfx0 <=| t0 -> pfx =[G, T] pfx0 -> exists pfx1, pfx1 <=| t1 /\ pfx0 =[G, P] pfx1)
        -> forall pfx', pfx' <=| t0 -> pfx' <=[G, T] pfx
        -> forall pfx0, pfx0 <=| t0 -> pfx' =[G, T] pfx0 -> exists pfx1, pfx1 <=| t1 /\ pfx0 =[G, P] pfx1.
      intros t0 t1 pfx PfxOfT0 Longer pfx' Pfx'OfT0 TEqPfxPfx' pfx0 Pfx0OfT0 TEqPfx0.
      assert (pfx0 =[G, T] pfx \/ pfx0 <=, pfx) as [|]
        by (apply prefix_dle_eq_or_pfxle ; eauto using pfx_from_same_trace_leq
            ; apply dle_pfx_trans with pfx' ; try unfold dle_pfx ; eauto using LePfx_intro with deq)
      ; eauto with deq.
      assert (exists pfx1, pfx1 <=| t1 /\ pfx =[G, P] pfx1) as (pfx1 & ? & ?) by eauto with deq.
      assert (pfx0 <=[G, P] pfx1) as (? & ? & ?) by eauto using pfx_deq_impl_dle.
      eauto using pfx_of_prod.
    Qed.

    (* This is the hardest case, where T00 and T01 both converge, but T10 and T11 both diverge. *)
    Lemma conv_s00_s01_divg_s10_s11_psrd : forall pc c1 nt' pc' c2 nt, G;; pc |- c1 -| nt'
        -> flows_to nt' pc' -> flows_to pc pc'
        -> G;; pc' |- c2 -| nt
        -> flows_to nt' nt
        -> In Label (Union Label P T) nt
        -> In Property (PsRdA G P T) (behavior c1)
        -> forall t00 s01 st01 t10 t11, nmif_input_match G P T (behavior (Seq c1 c2)) t00 (s01, st01) t10 t11
        -> converge c1 (t_input t00)
        -> diverge c1 (t_input t10)
        -> diverge c1 (t_input t11)
        -> forall pfx, pfx <=| t00
        -> (forall pfx0, pfx0 <=| t00 -> pfx =[G, T] pfx0 -> exists pfx1, pfx1 <=| t10 /\ pfx0 =[G, P] pfx1)
        -> forall lst01 lst01' s01Mid cs01, (c1, s01) ==>*[lst01'] (Skip, s01Mid)
        -> (c2, s01Mid) ==>*[lst01] cs01
        -> pfx =[G, T] (s01, lst01' ++ NoEvt :: lst01)
        -> exists pfx1, pfx1 <=| t11 /\ (s01, lst01' ++ NoEvt :: lst01) =[G, P] pfx1.
      intros pc c1 nt' pc' c2 nt WTc1 ? ? WTc2 ? LowNt InPsRdC1
        [s00 st00] s01 st01 [s10 st10] [s11 st11]
        [Prod00 Prod01 Prod10 Prod11 ? ? ? ?]
        (lst00Term & s00' & MStep00Term) DivgS10 DivgS11 pfx PfxOfT00 PsniHypo lst01 lst01' s01Mid [c2' s01'] ? ? TEqPfx ; unfold In, behavior in * ; simpl in *.
      (* Prove that (c1, s00) ==>*[lst00] (Skip, s00') *)
      pose proof (wt_mstep_stop_lst WTc1 MStep00Term) as [lst00 ?] ; subst.
      invert_tail mstep_iff_msteptl MStep00Term.
      lazymatch goal with
        | [H : _ -->[StopEvt] (Stop, _) |- _] => inversion H ; subst ; clear H
      end.
      (* Prove basic facts using divergence of t10 and t11. *)
      inversion PfxOfT00 as [? lst] ; subst.
      assert (Produces c1 s10 st10) by eauto using diverge_prod_under_seq.
      assert (Produces c1 s11 st11) by eauto using diverge_prod_under_seq.
      assert (exists cs, (Seq c1 c2, s00) ==>*[lst] cs) as [[] MStep00'] by eauto using prod_prefix_mstep.
      (* First prove that we can construct some prefix of t10 that is public-equvalent to (s00, lst00). *)
      assert (exists pfx1, pfx1 <=| (s10, st10) /\ (s00, lst00) =[G, P] pfx1) as (? & Pfx1OfT10 & DEqPfx).
      * destruct (mstep_seq_inv MStep00') as [(c1' & ? & ?) | (lst00H & lst00T & s00Mid & ? & ? & ?)].
        - assert ((s00, lst) =[G, T] (s00, lst00))
            by (apply deq_around with DecT pc c1 nt' s01 c1' lst01' (NoEvt :: lst01) ; eauto ; subst
                ; eapply wt_mstep_under_ctx with G pc (fun c => Seq c c2) c1 nt s00 _ lst ; eauto using SeqT, SeqCtx).
          apply PsniHypo ; [apply LeTrace_intro ; eapply prod_mstep_prefix |] ; eauto.
          apply step_under_seq ; [eauto | discriminate].
        - assert (exists pfx1, pfx1 <=| (s10, st10) /\ (s00, lst) =[G, P] pfx1) as (pfx1 & Pfx1OfT10 & ?) by eauto with deq.
          exists pfx1. split ; auto.
          apply dle_pfx_antisym.
          + apply deq_dle_pfx with (s00, lst) ; auto.
            assert (lst00H ++ [StopEvt] = lst00 ++ [StopEvt]) as LstEq by eauto using desterministic_conv_trace, mstep_append, StopE.
            apply app_inj_tail in LstEq as [? Junk] ; subst ; clear Junk.
            exists (s00, lst00).
            split ; [apply LePfx_intro ; rewrite -> prefix_as_append |] ; eauto with deq.
          + inversion Pfx1OfT10 as [? lst10] ; subst.
            assert (exists cs, (c1, s10) ==>*[lst10] cs) as [[c1' ?] MStep10] by eauto using prod_prefix_mstep.
            assert (In Property (PiniD G P) (behavior c1)) as InPini by eauto using wt_pini_d
            ; unfold PiniD, In in InPini.
            assert (exists st00', Produces c1 s00 st00') as [st00' ?] by eauto using prod_nstuck, nstuck_ex_stream, never_stuck_seq_c1.
            eapply pini_one_converge_skip with DecP c1 _ _ _ ; eauto with deq
            ; [intros ; apply InPini with (s10, st10) (s00, st00') ; try unfold behavior, In ; simpl
                ; eauto using LeTrace_intro, prod_mstep_prefix with deq
              | intro ; subst ; apply DivgS10 in MStep10 as (? & ? & ?) ; handle_simple_contradict].
      * (* Now we can use that prefix to prove that nt' \notin P, which means pc' \not P, so c2 is contained. *)
        inversion Pfx1OfT10 as [? lst10] ; subst ; clear Pfx1OfT10.
        assert (~ In Label P nt')
          by (assert (exists cs, (c1, s10) ==>*[lst10] cs) as [[c1' ?] MStep10] by eauto using prod_prefix_mstep
              ; apply conv_divg_deq with G DecP lst00 pc c1 s00 s10 s00' lst10 ; eauto using prod_nstuck, never_stuck_seq_c1).
        assert (~ In Label P pc') by eauto using high_set_up_closed.
        (* Use the containment to show that lst01 is either P-equivalent to [] or [StopEvt]. *)
        assert (deq_evt_lst G P lst01 [] \/ (c2' = Stop /\ deq_evt_lst G P lst01 [StopEvt])) as [DEq01Nil | [? DEqLst01Stop]]
          by (apply mstep_contain_evt_lst with DecP pc' c2 nt s01Mid s01' ; eauto).
        - (* If lst01 is T-equivalent to [], then construct something from T11 that is P-equivalent to lst01', which is enough. *)
          assert (exists pfx1, pfx1 <=| (s11, st11) /\ (s01, lst01') =[G, P] pfx1) as (pfx1 & Pfx1OfT11 & DEqPfxFinal).
          + (* This proof relies on ctx_psrd_s01_from_c1, since lst01' is from (c1, s01),
               but it gets complicated to prove the premise implication. *)
            assert ((s00, lst00) =[G, T] (s01, lst01'))
              by (apply DEqPfx_intro ; auto
                  ; apply deq_app_same_inv with StopEvt
                  ; eauto using pini_conv_lst, mstep_append, StopE).
            apply ctx_psrd_s01_from_c1 with pc c1 nt' (fun c => Seq c c2) (s00, st00) st01 (s10, st10) (s00, lst00) Skip s01Mid
            ; auto using SeqCtx
            ; [apply NmifInput_intro ; try unfold behavior, In ; simpl
               | apply LeTrace_intro  ; apply prod_mstep_prefix with (Seq c1 c2) s00 (Seq Skip c2, s00') ; [| apply step_under_seq]
               | |] ; auto ; try discriminate.
            (* Proving the premise implication requires checking that structure of lst again. *)
            intros pfx0 Pfx0OfT00 TEqPfx'.
            destruct (mstep_seq_inv MStep00') as [(c1' & ? & ?) | (lst00H & lst00T & s00Mid & ? & ? & ?)].
            ** (* If lst is from (c1, s00), then (s00, lst) =[T] (s00, lst00), which makes life easy. *)
               apply PsniHypo ; auto.
               transitivity (s00, lst00) ; auto.
               apply deq_around with DecT pc c1 nt' s01 c1' lst01' (NoEvt :: lst01) ; eauto.
               subst. eapply wt_mstep_under_ctx with G pc (fun c1' => Seq c1' c2) c1 nt s00 _ lst ; eauto using SeqCtx, SeqT.
            ** (* Otherwise, pfx0 be anywhere from larger (but T-equivalent) to lst to strictly shorter,
                  making this case a bit more complicated. *)
               apply restricted_psni_shorter with (s00, st00) (s00, lst) (s00, lst00)
               ; eauto using LeTrace_intro, prod_mstep_prefix, step_under_seq_skip.
               assert (lst00H ++ [StopEvt] = lst00 ++ [StopEvt]) as LstEq by eauto using desterministic_conv_trace, mstep_append, StopE
               ; apply app_inj_tail in LstEq as [? Junk] ; subst ; clear Junk.
               exists (s00, lst00). split ; [apply LePfx_intro ; rewrite -> prefix_as_append |] ; eauto with deq.
          + (* Once we have a pfx1 that is P-equivalent to (s01, lst01'),
               prove that it is also P-equivalent to (s01, lst01' ++ NoEvt :: lst01). *)
            exists pfx1 ; split ; [assumption |].
            inversion Pfx1OfT11 as [? lst11'] ; subst ; inversion DEqPfxFinal ; subst.
            apply DEqPfx_intro ; [assumption |].
            rewrite <- app_nil_r with Event lst11'.
            auto using deq_app, DEqNoEvtL with deq.
        - (* If lst01 is T-equivalent to [StopEvt], we can use that to show that lst ends with StopEvt,
             and there is a P-equivalent element of T10, so that must end in StopEvt,
             meaning T10 terminates, which we assumed it did not. *)
          subst.
          assert (exists pfx1, pfx1 <=| (s10, st10) /\ (s00, lst) =[G, P] pfx1) as (? & Pfx1OfT10 & DEqPfx10) by eauto with deq.
          inversion Pfx1OfT10 as [? lst10'] ; subst ; inversion DEqPfx10 ; subst ; clear Pfx1OfT10.
          rewrite <- app_nil_l with Event [StopEvt] in DEqLst01Stop.
          assert (exists lst, lst01 = lst ++ [StopEvt]) as [? ?] by eauto using mstep_deq_stop with deq ; subst.
          inversion TEqPfx as [? ? ? ? ? TEqPfxLst] ; subst.
          rewrite -> app_comm_cons in TEqPfxLst. rewrite -> app_assoc in TEqPfxLst.
          assert (exists lst', lst = lst' ++ [StopEvt]) as [lst' ?]
            by (assert (exists cs, (Seq c1 c2, s00) ==>*[lst] cs) as [? ?] by eauto using prod_prefix_mstep
                ; eauto using mstep_deq_stop with deq) ; subst.
          assert (exists cs, (c1, s10) ==>*[lst10'] cs) as [[c1' ?] ?] by eauto using prod_prefix_mstep.
          assert (exists lst, lst10' = lst ++ [StopEvt]) as [? ?] by eauto using mstep_deq_stop with deq ; subst.
          assert (c1' = Stop) by eauto using mstep_to_stop_evt ; subst.
          contradiction diverge_impl_not_converge with c1 s10.
          unfold converge ; eauto.
    Qed.

    Ltac reduce_to_converge :=
      lazymatch goal with
        | [LowNt : In Label (Union Label P T) ?nt, LowPc : In Label (Intersection Label P T) ?pc |- _]
          => apply psrd_is_pird_rpl ; auto ; apply Intersection_intro
             ; [apply pini_in_pird ; apply wt_pini_d with pc nt DecP ; eauto using SkipT, AssignT |]
             ; unfold RplA, In
             ; intros ? [s0 st0] ? [s1 st1] [? ? ? ? ? ? ? ?] ? ? ? ? ? Pfx0OfT0 Pfx1OfT1 ? ?
             ; inversion Pfx0OfT0 as [? lst0] ; inversion Pfx1OfT1 ; subst
             ; lazymatch goal with
             | [H : In Trace (behavior ?c) _ |- _]
               => apply conv_lfp with pc c nt s0 st0 lst0 ; eauto using SkipT, AssignT
             end
      end.

    Theorem low_pc_psrd : forall pc c nt, G;; pc |- c -| nt
        -> In Label (Union Label P T) nt -> In Label (Intersection Label P T) pc -> In Property (PsRdA G P T) (behavior c).
      intros pc c nt WTc LowNt LowPc. induction WTc.
      (* For cases other than inductive and converging, unfold and intro everything. *)
      3,4,5,6: unfold PsRdA, In
        ; intros [s00 st00] [s01 st01] [s10 st10] [s11 st11]
                 [Prod00 Prod01 Prod10 Prod11 ? ? DEqStoreP1 ?]
                 pfx PfxOfT00 PsniHypo pfx0 Pfx0OfT01 TEqPfxPfx0
        ; simpl in *
        ; inversion Pfx0OfT01 as [? lst0 ? EvtPfx01] ; subst.
      * (* Skip: Use conv_lfp and prove it converges *)
        reduce_to_converge.
        unfold converge. eauto using MultiStep, StopE.
      * (* Assign: Use conv_lfp and prove it converges *)
        reduce_to_converge.
        unfold In, behavior in * ; simpl in *.
        assert (never_stuck (Assign x e) s1) as NStuck by eauto using prod_nstuck.
        destruct (NStuck (Assign x e) s1 [] (MultiStep_refl (Assign x e, s1))) as [| (? & ? & Step)] ; [discriminate |].
        inversion Step ; subst.
        unfold converge.
        eauto 6 using MultiStep, AssignE, StopE.
      * (* First prove that all four traces take the same step. Then use induction and prepend_equiv. *)
        destruct LowPc as [pc PubPc TrustPc].
        unfold In, behavior in * ; simpl in *.
        (* Using inversion and deq_expr_eval, prove that all four traces take the same step. *)
        do 4 (match goal with
          | [Prod : Produces (If _ _ _) ?s ?st |- _]
              => (* Check to make sure we haven't already done this one and fail if we have. *)
                lazymatch st with | (ConsEvt NoEvt _) => fail | _ => idtac end
                ; let st' := fresh st "'" in
                inversion Prod as [? ? ? c' s' st' IfStep |] ; subst
                ; inversion IfStep
                (* Substitute so important names don't get destroyed *)
                ; repeat lazymatch goal with
                  | [H : _ = c' |- _] => try rewrite <- H in * ; clear c' H
                  | [H : _ = s' |- _] => try rewrite <- H in * ; clear s' H
                end ; subst
                ; clear IfStep
        end
        ; try match goal with
          | [EvalS : evalExpr e ?s0 = Some (S _), Eval0 : evalExpr e ?s1 = Some 0 |- _]
            => assert (evalExpr e s0 = evalExpr e s1) as EvalSame
                by (lazymatch goal with
                  | [DEq : deq_store G ?D s0 s1 |- _] => eapply deq_expr_eval with G D ?[H] pc
                  | [DEq : deq_store G ?D s1 s0 |- _] => eapply deq_expr_eval with G D ?[H] pc
                end ; eauto with deq)
              ; rewrite -> EvalSame in EvalS ; rewrite -> EvalS in Eval0 ; injection Eval0 ; intro BadEq ; inversion BadEq
        end)
        (* Apply prepend_equiv to get to the body of whichever branch was taken. *)
        ; rewrite -> trace_prepend_cons with s11 NoEvt s11 st11'
        ; apply prepend_equiv with (s00, st00') (s01, st01') (s10, st10') (s00, [NoEvt]) (s01, [NoEvt]) (s10, [NoEvt]) pfx
        ; simpl ; auto using DEqPfx_intro with deq
        (* Use induction to prove the result for whichever branch we took. *)
        ; intros pfx0 ? ? pfx1 ? ?
        ; [set (c := c1); set (IHWTc := IHWTc1) | set (c := c2); set (IHWTc := IHWTc2)]
        ; apply IHWTc with (s00, st00') (s01, st01') (s10, st10') pfx0 ; try apply Intersection_intro ; auto
        ; apply NmifInput_intro ; unfold behavior, In ; simpl ; auto.
      * (* Seq: This is a very complicated case and should likely be broken out into several lemmas. *)
        specialize (IHWTc1 ((low_set_union_inst P T).(down_closed) nt nt' LowNt H1) LowPc).
        assert (exists cs, (Seq c1 c2, s01) ==>*[lst0] cs) as [[c' s01'] MStep01] by eauto using prod_prefix_mstep.
        destruct (mstep_seq_inv MStep01) as [(c1' & ? & ?) | (lst01' & lst01 & s01Mid & ? & ? & ?)] ; subst
        ; [apply ctx_psrd_s01_from_c1 with pc c1 nt' (fun c => Seq c c2) (s00, st00) st01 (s10, st10) pfx c1' s01'
           ; try (apply NmifInput_intro ; try unfold behavior, In ; simpl)
           ; try (apply wt_mstep_under_ctx with G pc (fun c => Seq c c2) c1 nt s01 s01' lst0)
           ; eauto using SeqCtx, SeqT
          | assert ((c1, s01) ==>*[lst01' ++ [StopEvt]] (Stop, s01Mid)) by eauto using mstep_append, StopE].
        (* destruct (wt_converge_or_diverge WTc1 WFs01) as [ConvS01 |]
        ; [| apply diverge_c1_s01_seq_psrd with G pc c1 nt' c2 (s00, st00) (s01, st01) (s10, st10) pfx ; auto
             ; apply NmifInput_intro ; try unfold behavior, In ; simpl ; auto]. *)
        unfold In, behavior in * ; simpl in *.
        assert (never_stuck c1 s00) as NStuck00 by eauto using prod_nstuck, never_stuck_seq_c1.
        assert (never_stuck c1 s01) by eauto using prod_nstuck, never_stuck_seq_c1.
        assert (never_stuck c1 s10) as NStuck10 by eauto using prod_nstuck, never_stuck_seq_c1.
        assert (never_stuck c1 s11) by eauto using prod_nstuck, never_stuck_seq_c1.
        destruct (never_stuck_conv_or_divg c1 s00 NStuck00) as [ConvS00 |]
        ; [| eapply diverge_c1_s00_seq_psrd with pc c1 nt' pc' c2 nt (s00, st00) st01 (s10, st10) pfx s01Mid (c', s01') ; auto
             ; apply NmifInput_intro ; try unfold behavior, In ; simpl ; auto].
        destruct (never_stuck_conv_or_divg c1 s10 NStuck10) as [ConvS10 | DivgS10].
        - assert (converge c1 s11) as ConvS11
            by (assert (exists st00', Produces c1 s00 st00') as [st00' ?] by eauto using nstuck_ex_stream
                ; assert (exists st01', Produces c1 s01 st01') as [st01' ?] by eauto using nstuck_ex_stream
                ; assert (exists st10', Produces c1 s10 st10') as [st10' ?] by eauto using nstuck_ex_stream
                ; assert (exists st11', Produces c1 s11 st11') as [st11' ?] by eauto using nstuck_ex_stream
                ; apply psrd_not_one_conv with pc nt' s00 s01 s10 st00' st01' st10' st11'
                ; try unfold converge ; eauto).
          (* Prove a bunch of important facts about converging programs. *)
          repeat match goal with
          | [Conv : converge ?c ?s |- _]
            => let s' := fresh s "'" in
                destruct Conv as (x & s' & Conv)
              ; let lst := fresh "l" s in
              assert (exists lst, (c, s) ==>*[lst] (Skip, s')) as [lst ?] by eauto using wt_mstep_to_stop_impl_skip
              ; clear x Conv
              ; assert ((c, s) ==>*[lst ++ [StopEvt]] (Stop, s')) by eauto using mstep_append, StopE
            | [Prod : Produces _ _ (prepend _ _) |- _] => fail
            | [Prod : Produces (Seq c1 c2) ?s ?st, MStep : (c1, ?s) ==>*[?lst] (Skip, ?s') |- _]
              => lazymatch goal with
                  | [Prod' : Produces (Seq c1 c2) s (prepend _ _) |- _] => fail
                  | _ => idtac
                end
                ; let st' := fresh st "'" in
                  assert (exists st', Produces (Seq c1 c2) s (prepend (lst ++ [NoEvt]) st')) as [st' ?]
                  by (apply prod_mstep with (c2, s') st ; eauto using step_under_seq_skip, mstep_append, SeqSkipE)
          end.
          set (lst0 := lst01' ++ NoEvt :: lst01).
          (* Separate out the two halves of the traces so prepend_equiv applies. *)
          enough (exists pfx1, pfx1 <=| trc_prpnd (s11, ls11 ++ [NoEvt]) (s11', st11') /\ (s01, lst0) =[G, P] pfx1) as (pfx1 & PfxOfT11 & ?)
            by (unfold trc_prpnd in * ; simpl in * ; eauto using pfx_prod_both).
          (* Prove that the stores are equivalent after c1 executes. We'll need it multiple times. *)
          do 4 match goal with
            | [DEqStore : deq_store G ?D ?s0 ?s1,
               MStep0 : (c1, ?s0) ==>*[?lst0] (Skip, ?s0'),
               MStep1 : (c1, ?s1) ==>*[?lst1] (Skip, ?s1') |- _]
              => lazymatch goal with | [H : deq_store G D s0' s1' |- _] => fail | _ => idtac end
                 ; assert (deq_store G D s0' s1')
                  by (eapply pini_conv_store with _ pc c1 nt' s0 (lst0 ++ [StopEvt]) s1 (lst1 ++ [StopEvt]) ; eauto)
          end.
          (* Use prepend_equiv to reduce to PsRd on c1. *)
          apply prepend_equiv with (s00', st00') (s01Mid, st01') (s10', st10')
              (s00, ls00 ++ [NoEvt]) (s01, lst01' ++ [NoEvt]) (s10, ls10 ++ [NoEvt]) pfx
          ; try unfold trc_prpnd ; simpl ; eauto using pfx_prod_both
          ; try lazymatch goal with
            | [|- (?s0, ?lst0) =[G, _] (?s1, ?lst1)]
              => apply DEqPfx_intro ; [assumption |]
                ; apply deq_evt_lst_append_same
                ; apply deq_app_same_inv with StopEvt
                ; eapply pini_conv_lst with _ pc c1 nt' s0 _ s1 _ ; eauto
          end.
          + (* Prove that c2 is in PsRd either directly or using induction, depending on pc'. *)
            assert (In Property (PsRdA G P T) (behavior c2)) as InPsRdC2.
            ** destruct (DecP.(dec_in) pc') as [| SecPc'] ; [destruct (DecT.(dec_in) pc') as [| UntrustPc'] |]
               ; [apply IHWTc2 ; try apply Intersection_intro | |] ; eauto using untrusted_pc_psrd, secret_pc_psrd.
            ** apply InPsRdC2.
               assert (Produces c2 s00' st00') by (eapply prod_prepend_mstep with (Seq c1 c2) _ _ ; eauto using step_under_seq_skip, mstep_append, SeqSkipE).
               assert (Produces c2 s01Mid st01') by (eapply prod_prepend_mstep with (Seq c1 c2) _ _ ; eauto using step_under_seq_skip, mstep_append, SeqSkipE).
               assert (Produces c2 s10' st10') by (eapply prod_prepend_mstep with (Seq c1 c2) _ _ ; eauto using step_under_seq_skip, mstep_append, SeqSkipE).
               assert (Produces c2 s11' st11') by (eapply prod_prepend_mstep with (Seq c1 c2) _ _ ; eauto using step_under_seq_skip, mstep_append, SeqSkipE).
               apply NmifInput_intro ; try unfold behavior, In ; simpl ; eauto.
          + (* Handle the Psni-style implication on T00 and T10 by showing the prepended traces are equivalent. *)
            intros pfx0 ? ?.
            assert (exists pfx1, pfx1 <=| (s10, st10) /\ pfx0 =[G, P] pfx1) as (? & ? & ?) by eauto using pfx_prod_both.
            eauto using pfx_prod_both.
        - (* Here c1 converge with s00 and s01, diverges with s10.
             Prove that c1 must diverge with s11 since we can't have only one divergent trace. *)
          assert (never_stuck c1 s11) as NStuck11 by eauto using prod_nstuck, never_stuck_seq_c1.
          destruct (never_stuck_conv_or_divg c1 s11 NStuck11).
          + contradiction diverge_impl_not_converge with c1 s10.
            assert (exists st00', Produces c1 s00 st00') as [st00' ?] by eauto using nstuck_ex_stream, never_stuck_ctx, prod_nstuck.
            assert (exists st01', Produces c1 s01 st01') as [st01' ?] by eauto using nstuck_ex_stream, never_stuck_ctx, prod_nstuck.
            assert (exists st10', Produces c1 s10 st10') as [st10' ?] by eauto using nstuck_ex_stream, never_stuck_ctx, prod_nstuck.
            pose proof (nstuck_ex_stream NStuck11) as [st11' ?].
            apply psrd_not_one_conv with pc nt' s01 s00 s11 st01' st00' st11' st10' ; auto with deq.
            try unfold converge ; eauto.
          + (* Appeal to the very complicated lemma that solves this directly. *)
            apply conv_s00_s01_divg_s10_s11_psrd with pc c1 nt' pc' c2 nt (s00, st00) st01 (s10, st10) pfx s01Mid (c', s01')
            ; try (apply NmifInput_intro ; try unfold behavior, In) ; eauto.
      * (* While: This is another very complicated case. *)
        inversion LowPc as [? PubPc TrustPc].
        unfold In, behavior in * ; simpl in *.
        assert (never_stuck (While e c) s00) as NStuck00 by eauto using prod_nstuck.
        assert (never_stuck (While e c) s01) as NStuck01 by eauto using prod_nstuck.
        assert (never_stuck (While e c) s10) as NStuck10 by eauto using prod_nstuck.
        assert (never_stuck (While e c) s11) as NStuck11 by eauto using prod_nstuck.
        (* First branch based on which of the while_pair_trilemma cases we're in. *)
        destruct (while_pair_trilemma H WTc NStuck01 NStuck11 P LowP PubPc DEqStoreP1) as [[? Conv11] | [| (n0 & s01'' & s11'' & ? & ? & ? & ? & Divg)]].
        - (* If T11 terminates, then that is sufficient by itself. *)
          assert (In Property (PiniD G P) (behavior (While e c))) as InPini by eauto using wt_pini_d, WhileT
          ; unfold PiniD, In in InPini.
          apply pini_lfp_impl_psni with (fun pfx0 => True) (s01, st01) ; auto
          ; [intros ; apply InPini with (s01, st01) (s11, st11) ; try unfold behavior ; simpl ; eauto
            | intros ? ? Pfx0Of00 Pfx1Of11 ? ? ; inversion Pfx0Of00 as [? lst0'] ; inversion Pfx1Of11 ; subst].
          apply conv_lfp with pc (While e c) pc s01 st01 lst0' ; auto using WhileT.
        - (* If both T01 and T11 loop an infinite number of times, they're in Psni, so use that.*)
          eauto using infinite_loop_psni, WhileT.
        - (* The most complicated case by far is when the body of the loop diverges in one of the traces. *)
          assert (exists n s00' s01' s10' s11' m,
                  LoopsN e c s00 s00' n
                  /\ LoopsN e c s01 s01' n
                  /\ LoopsN e c s10 s10' n
                  /\ LoopsN e c s11 s11' n
                  /\ evalExpr e s00' = Some (S m)
                  /\ (diverge c s01' \/ diverge c s00' \/ diverge c s10' \/ diverge c s11'))
            as (n & s00' & s01' & s10' & s11' & ? & ? & ? & ? & ? & ? & DivgOpts).
          + (* First prove that there is some finite number of loops that they all take before someone diverges.
               This is mostly an annoying case analysis using wt_while_options. It's not conceptually complex. *)
            pose proof (nstuck_while_options NStuck00 n0) as [[s00' ?] | (n1 & s00' & Ltn'n0 & ? & [|])]
            ; [remember n0 as n
              | assert (exists s', LoopsN e c s01 s' (S n1)) as [] by eauto using loops_lt ; handle_loop_cnt_contradict
              | assert (exists s', LoopsN e c s01 s' (S n1)) as [? Loops] by eauto using loops_lt ; inversion Loops ; subst ; clear Loops
                ; apply le_S in Ltn'n0 ; apply le_S_n in Ltn'n0
                ; assert (exists s', LoopsN e c s11 s' n1) as [] by eauto using loops_lt
                ; remember n1 as n]
            ; (pose proof (nstuck_while_options NStuck10 n) as [[s10' ?] | (n2 & s10' & Ltn'n1 & ? & [|])]
              ; [| assert (exists s', LoopsN e c s00 s' (S n2)) as [] by eauto using loops_lt ; handle_loop_cnt_contradict
                  | assert (exists s', LoopsN e c s00 s' (S n2)) as [? Loops] by eauto using loops_lt ; inversion Loops ; subst ; clear Loops
                    ; apply le_S in Ltn'n1 ; apply le_S_n in Ltn'n1
                    ; assert (exists s', LoopsN e c s01 s' n2) as [] by eauto using loops_lt
                    ; assert (exists s', LoopsN e c s11 s' n2) as [] by eauto using loops_lt
                    ; remember n2 as n])
            ; lazymatch goal with
              | [L00 : LoopsN e c s00 ?s00' ?n,
                  L01 : LoopsN e c s01 ?s01' ?n,
                  L10 : LoopsN e c s10 ?s10' ?n,
                  L11 : LoopsN e c s11 ?s11' ?n |- _]
                => exists n ; exists s00' ; exists s01' ; exists s10' ; exists s11' ; eexists;
                    repeat split ; eauto ; rewrite_eq_expr_evals s00' s01' ; destruct Divg ; eauto
            end.
          + (* Now state two basic facts about the situation: *)
            (* 1: None of the loops terminate here (they all go into the body) *)
            repeat match goal with
              | [Loops : LoopsN ?e ?c _ ?s0 n, Expr : evalExpr ?e ?s1 = Some (S ?m) |- _]
                => lazymatch goal with
                    | [H : evalExpr _ s0 = Some (S _) |- _] => fail
                    | _ => idtac
                  end
                  ; assert (evalExpr e s0 = Some (S m)) by (try rewrite_eq_expr_evals s0 s1 ; try rewrite_eq_expr_evals s1 s0 ; auto)
            end.
            (* 2: The full traces are the trace generated by n loops followed by the trace generated by the sequence. *)
            repeat lazymatch goal with
              | [Loops : LoopsN _ _ ?s ?s' n, Prod : Produces (While e c) ?s ?st |- _]
                => let lst := fresh "l" s in apply loopsn_loopsnlst in Loops as [lst ?]
                  ; let st' := fresh st "'" in
                    assert (exists st', Produces (While e c) s (prepend (lst ++ [NoEvt ; NoEvt]) st')) as [st' ?]
                      by (apply prod_mstep with (Seq c (While e c), s') st
                          ; eauto 6 using step_concat, loops_lst_step, MultiStep, WhileE, IfNE)
            end.
            (* Now use prepend_env to get us down to proving PsRd on (Seq c (While e c)) when c diverges in one trace. *)
            enough (exists pfx1, pfx1 <=| trc_prpnd (s11, ls11 ++ [NoEvt ; NoEvt]) (s11', st11') /\ (s01, lst0) =[G, P] pfx1) as (pfx1 & PfxOfT11 & ?)
              by (unfold trc_prpnd in * ; simpl in * ; eauto using pfx_prod_both).
            apply prepend_equiv with (s00', st00') (s01', st01') (s10', st10')
              (s00, ls00 ++ [NoEvt ; NoEvt]) (s01, ls01 ++ [NoEvt ; NoEvt]) (s10, ls10 ++ [NoEvt ; NoEvt]) pfx
            ; try unfold trc_prpnd ; simpl
            ; try (apply DEqPfx_intro ; repeat (apply deq_app ; [| auto with deq]))
            ; try (intros pfx0 ? ? ; assert (exists pfx1, pfx1 <=| (s10, st10) /\ pfx0 =[G, P] pfx1) as (? & ? & ?) by eauto using pfx_prod_both)
            ; eauto using pfx_prod_both, loops_lst_store_deq, WhileT, loops_lst_deq.
            (* Clean up the hypotheses into something easier to work with. *)
            repeat lazymatch goal with
              | [Loops : LoopsNLst e c ?s ?s' ?lst _,
                 Prod : Produces (While e c) ?s (prepend (?lst ++ [NoEvt ; NoEvt]) ?st) |- _]
                => assert (Produces (Seq c (While e c)) s' st) as Prod'
                    by (apply prod_prepend_mstep with (While e c) s (lst ++ [NoEvt ; NoEvt]) ; auto
                        ; apply step_concat with (While e c, s') ; eauto using MultiStep, WhileE, IfNE, loops_lst_step)
                   ; revert Prod' ; clear Prod
              | [DEq : deq_store G ?D ?s0 ?s1,
                 Loops0 : LoopsNLst _ _ ?s0 ?s0' _ ?n,
                 Loops1 : LoopsNLst _ _ ?s1 ?s1' _ ?n |- _]
                => assert (deq_store G D s0' s1') as DEq' by eauto using loops_lst_store_deq, WhileT
                   ; revert DEq' ; clear DEq
            end.
            specialize (IHWTc LowNt LowPc).
            generalize DecT LowT DecP LowP AtkPT s00' s01' s10' s11' DivgOpts LowNt LowPc WTc H IHWTc ; clear.
            intros DecT LowT DecP LowP AtkPT s00 s01 s10 s11
              DivgOpts ? ? WTc ? ? ? ? ? ? ? ? ? ? pfx PfxOfT00 ? pfx0 Pfx0OfT01 DEqPfx.
            inversion Pfx0OfT01 as [? lst0] ; subst.
            (* Now we're in a re-hash of the Seq case where we know the first command diverges in at least once trace. *)
            assert (exists cs, (Seq c (While e c), s01) ==>*[lst0] cs) as [[c' s01'] MStep01] by eauto using prod_prefix_mstep.
            destruct (mstep_seq_inv MStep01) as [(c1' & ? & ?) | (? & ? & s01Mid & ? & ? & ?)] ; subst
            ; [apply ctx_psrd_s01_from_c1 with pc c pc (fun c1' => Seq c1' (While e c)) (s00, st00') st01' (s10, st10') pfx c1' s01'
               ; try (apply NmifInput_intro ; try unfold behavior, In) ; simpl
               ; try (apply wt_mstep_under_ctx with G pc (fun c1' => Seq c1' (While e c)) c pc s01 s01' lst0)
               ; eauto using SeqCtx, SeqT, WhileT |].
            assert (never_stuck c s00) by eauto using prod_nstuck, never_stuck_seq_c1.
            assert (never_stuck c s01) by eauto using prod_nstuck, never_stuck_seq_c1.
            assert (never_stuck c s10) by eauto using prod_nstuck, never_stuck_seq_c1.
            assert (never_stuck c s11) by eauto using prod_nstuck, never_stuck_seq_c1.
            assert (exists st', Produces c s00 st') as [st00 ?] by eauto using nstuck_ex_stream.
            assert (exists st', Produces c s01 st') as [st01 ?] by eauto using nstuck_ex_stream.
            assert (exists st', Produces c s10 st') as [st10 ?] by eauto using nstuck_ex_stream.
            assert (exists st', Produces c s11 st') as [st11 ?] by eauto using nstuck_ex_stream.
            assert (converge c s00 \/ diverge c s00) as [|] by eauto using never_stuck_conv_or_divg
            ; [| eapply diverge_c1_s00_seq_psrd with pc c pc pc (While e c) pc (s00, st00') st01' (s10, st10') pfx s01Mid (c', s01')
                ; try (apply NmifInput_intro ; try unfold behavior, In) ; simpl ; auto using WhileT].
            assert (converge c s10 \/ diverge c s10) as [|] by eauto using never_stuck_conv_or_divg.
            ** assert (G;; pc |- Seq c (While e c) -| pc) as WTSeq by eauto using SeqT, WhileT.
               destruct DivgOpts as [| [| [|]]]
               ; lazymatch goal with
                  | [H : diverge c ?s |- _] => contradiction diverge_impl_not_converge with c s
              end
              ; [| apply psrd_not_one_conv with pc pc s00 s01 s10 st00 st01 st10 st11 ; auto]
              ; unfold converge ; eauto using mstep_append, StopE.
            ** assert (converge c s11 \/ diverge c s11) as [|] by eauto using never_stuck_conv_or_divg
               ; [contradiction diverge_impl_not_converge with c s10
                  ; apply psrd_not_one_conv with pc pc s01 s00 s11 st01 st00 st11 st10
                  ; try unfold converge ; eauto using mstep_append, StopE with deq |].
               apply conv_s00_s01_divg_s10_s11_psrd with pc c pc pc (While e c) pc (s00, st00') st01' (s10, st10') pfx s01Mid (c', s01')
                ; try (apply NmifInput_intro ; try unfold behavior, In) ; eauto using WhileT.
      * (* ProgDown: This case is surprisingly annoying. *)
        assert (never_stuck c s00) as NStuck00 by eauto using prod_nstuck, never_stuck_under_pdown.
        assert (never_stuck c s01) as NStuck01 by eauto using prod_nstuck, never_stuck_under_pdown.
        assert (never_stuck c s10) as NStuck10 by eauto using prod_nstuck, never_stuck_under_pdown.
        assert (never_stuck c s11) as NStuck11 by eauto using prod_nstuck, never_stuck_under_pdown.
        destruct (never_stuck_conv_or_divg c s11 NStuck11) as [(lst01 & s01' & MStep01) |].
        - (* If (c, s11) converges, then so does T11, so just use that. *)
          assert (In Property (PiniD G P) (behavior (ProgDown l c))) as InPini by eauto using wt_pini_d, ProgDownT
          ; unfold PiniD, In in InPini.
          apply pini_lfp_impl_psni with (fun pfx0 => True) (s01, st01) ; auto.
          + intros ; apply InPini with (s01, st01) (s11, st11) ; try unfold behavior ; simpl ; eauto.
          + intros ? ? Pfx0Of00 Pfx1Of11 ? ?.
            inversion Pfx0Of00 as [? lst0'] ; inversion Pfx1Of11 ; subst.
            apply conv_lfp with pc (ProgDown l c) l s01 st01 lst0' ; eauto using ProgDownT.
            assert (exists lst01', (c, s11) ==>*[lst01'] (Skip, s01')) as [lst01' ?] by eauto using wt_mstep_to_stop_impl_skip.
            exists ((lst01' ++ [PDownEvt l]) ++ [StopEvt]).
            eauto using step_under_pdown_skip, mstep_append, PDownSkipE, StopE.
        - (* If T11 diverges, split based on whether pfx0 is from (c, s01) or past the PDown event. *)
          assert (Produces c s11 st11) by eauto using diverge_prod_under_pdown.
          pose proof (nstuck_ex_stream NStuck01) as [st01' ?].
          specialize (IHWTc (non_compromised_low nt H) LowPc).
          assert (exists cs, (ProgDown l c, s01) ==>*[lst0] cs) as [[? s01'] MStep01] by eauto using prod_prefix_mstep.
          destruct (mstep_pdown_inv MStep01) as [(c1' & ? & ?) | (lst0' & ? & Lst0Opts)]
          (* If pfx0 is from (c0, s01), then we can use the same logic as the seq case. *)
          ; [apply ctx_psrd_s01_from_c1 with pc c nt (fun c' => ProgDown l c') (s00, st00) st01 (s10, st10) pfx c1' s01'
            ; try (apply NmifInput_intro ; try unfold behavior, In ; simpl)
            ; try (apply wt_mstep_under_ctx with G pc (fun c' => ProgDown l c') c l s01 s01' lst0)
            ; subst ; eauto using PDownCtx, ProgDownT |].
          inversion PfxOfT00 as [? lst] ; subst.
          assert (exists cs, (ProgDown l c, s00) ==>*[lst] cs) as [[c' s00'] MStepLst] by eauto using prod_prefix_mstep.
          destruct (never_stuck_conv_or_divg c s00 NStuck00) as [(lst00Term & s00Mid & ?) | DivgC00].
          + destruct (never_stuck_conv_or_divg c s10 NStuck10) as [| DivgC10]
            ; [pose proof (nstuck_ex_stream NStuck00) as [st00' ?]
                ; pose proof (nstuck_ex_stream NStuck10) as [st10' ?]
                ; contradiction diverge_impl_not_converge with c s11
                ; apply psrd_not_one_conv with pc nt s00 s01 s10 st00' st01' st10' st11
                ; try (unfold converge) ; eauto using mstep_append, StopE
              | assert (Produces c s10 st10) by eauto using diverge_prod_under_pdown].
            assert (exists lst00', lst00Term = lst00' ++ [StopEvt]) as [lst00' ?] by eauto using wt_mstep_stop_lst ; subst.
            assert ((c, s00) ==>*[lst00'] (Skip, s00Mid)) as MStep00 by eauto using wt_mstep_to_stop_skip.
            assert ((s00, lst00') =[G, T] (s01, lst0')) as TEqPfx
              by (apply DEqPfx_intro ; auto
                  ; apply deq_app_same_inv with StopEvt
                  ; apply pini_conv_lst with DecT pc c nt s00 s00Mid s01 s01' ; eauto using mstep_append, StopE).
            destruct Lst0Opts ; [set (lst0T := [PDownEvt l]) | set (lst0T := [PDownEvt l ; StopEvt])] ; subst
            ; assert (exists pfx1, pfx1 <=| (s10, st10) /\ (s00, lst00' ++ lst0T) =[G, P] pfx1) as (? & Pfx1OfT10 & PEqPfx)
              by (apply PsniHypo
                  ; [eauto 7 using LeTrace_intro, prod_mstep_prefix, step_concat, MultiStep, OneStep, mstep_append, step_under_pdown_skip
                    | inversion TEqPfx ; transitivity (s01, lst0' ++ lst0T) ; auto using DEqPfx_intro, deq_app with deq])
            ; inversion Pfx1OfT10 as [? lst10] ; subst
            (* This one is the same annoying thing we've done before using anti-symmetry. *)
            ; assert ((s00, lst00') =[G, P] (s10, lst10)) as PEqPfx'
                by (apply dle_pfx_antisym
                  ; [apply pfx_deq_impl_dle with (s00, lst00' ++ lst0T) ; auto with deq
                      ; apply LePfx_intro ; rewrite -> prefix_as_append ; eauto
                    | assert (exists cs, (c, s10) ==>*[lst10] cs) as [[c10 s10'] MStep10] by eauto using prod_prefix_mstep
                      ; apply pini_one_converge_skip with DecP c c10 s10' s00Mid ; auto with deq
                      ; pose proof (nstuck_ex_stream NStuck00) as [st00' ?]
                      ; assert (In Property (PiniD G P) (behavior c)) as InPini by eauto using wt_pini_d
                      ; unfold PiniD, In in InPini
                      ; [intros ; apply InPini with (s10, st10) (s00, st00') ; try (unfold behavior, In) ; simpl
                          ; eauto using LeTrace_intro, prod_mstep_prefix with deq
                        | intro ; subst ; apply DivgC10 in MStep10 as (? & ? & ?) ; handle_simple_contradict]])
            ; rewrite <- app_nil_r with Event lst10 in PEqPfx
            ; assert (deq_evt_lst G P lst0T []) as DEqTailNil by (inversion PEqPfx ; inversion PEqPfx' ; subst ; eauto using deq_app_inv)
            ; subst lst0T.
            ** inversion DEqTailNil ; subst.
               enough (exists pfx1, pfx1 <=| (s11, st11) /\ (s01, lst0') =[G, P] pfx1) as (pfx1 & Pfx1OfT11 & PEqPfx1)
                 by (inversion Pfx1OfT11 ; subst ; inversion PEqPfx1 ; subst
                     ; eauto using DEqPfx_intro, deq_evt_lst_append_high_l).
               apply ctx_psrd_s01_from_c1 with pc c nt (fun c' => ProgDown l c') (s00, st00) st01 (s10, st10) (s00, lst00') Skip s01'
               ; try (apply NmifInput_intro ; try unfold behavior, In ; simpl)
               ; try (apply wt_mstep_under_ctx with G pc (fun c' => ProgDown l c') c l s01 s01' lst0)
               ; subst ; eauto using PDownCtx, LeTrace_intro, prod_mstep_prefix, step_under_pdown_skip ; try discriminate.
               (* This is the same as a case we did in a Seq lemma, where we show that (s00, lst00') <=[T] (s00, lst),
                  and then use PsniHypo to get what we need. *)
               apply restricted_psni_shorter with (s00, lst) ; eauto using LeTrace_intro, prod_mstep_prefix, step_under_pdown_skip.
               destruct (mstep_pdown_inv MStepLst) as [(? & ? & ?) | (lst' & ? & LstOpts)] ; subst.
               -- exists (s00, lst). split ; auto.
                  symmetry.
                  eapply deq_around with DecT pc c nt s01 _ lst0' [PDownEvt l]
                  ; try apply wt_mstep_under_ctx with G pc (fun c' => ProgDown l c') c l s00 s00' lst
                  ; eauto using PDownCtx, ProgDownT.
               -- assert (lst' ++ [StopEvt] = lst00' ++ [StopEvt]) as LstEq by eauto using desterministic_conv_trace, mstep_append, StopE
                  ; apply app_inj_tail in LstEq as [? Junk] ; subst ; clear Junk.
                  exists (s00, lst00').
                  split ; [apply LePfx_intro ; rewrite -> prefix_as_append ; destruct LstOpts | apply DEqPfx_intro] ; eauto with deq.
            ** assert ([PDownEvt l ; StopEvt] = [PDownEvt l] ++ [StopEvt]) as LstFormat by (simpl ; reflexivity).
               rewrite -> LstFormat in *.
               apply deq_lst_app_eq_nil in DEqTailNil as [? StopNil].
               inversion StopNil ; subst.
               handle_simple_contradict.
          + (* If (c, s00) diverges, we can contradict the assumption that flows_to nt (reflect nt). *)
            assert (Produces c s00 st00) by eauto using diverge_prod_under_pdown.
            assert ((s00, lst) =[G, T] (s01, lst0'))
              by (apply dle_pfx_antisym
                  (* One direction is trivial, the other is not. *)
                  ; [| apply pfx_deq_impl_dle with (s01, lst0)
                      ; [apply LePfx_intro ; rewrite -> prefix_as_append ; destruct Lst0Opts |] ; eauto with deq]
                  ; destruct (mstep_pdown_inv MStepLst) as [(c0' & ? & ?) | (? & ? & ?)] ; subst
                  ; [assert (In Property (PiniD G T) (behavior c)) as InPini by eauto using wt_pini_d ; unfold PiniD, In in InPini
                    ; apply pini_one_converge_skip with DecT c c0' s00' s01' ; eauto using step_under_pdown
                    ; [intros ; apply InPini with (s00, st00) (s01, st01') ; try unfold behavior, In ; simpl
                        ; eauto using LeTrace_intro, prod_mstep_prefix
                      | intro ; subst] |]
                  ; contradiction diverge_impl_not_converge with c s00 ; unfold converge ; eauto using mstep_append, StopE).
            assert (~ In Label T nt)
              by (apply conv_divg_deq with G DecT lst0' pc c s01 s00 s01' lst
                  ; eauto using prod_prefix_mstep, mstep_append, StopE with deq).
            pose proof (nstuck_ex_stream NStuck10) as [st10' ?].
            enough (exists pfx1, pfx1 <=| (s11, st11) /\ (s01, lst0') =[G, P] pfx1) as (? & Pfx1OfT11 & ?)
              by (inversion Pfx1OfT11 as [? lst11] ; subst
                  ; assert (exists cs, (c, s11) ==>*[lst11] cs) as [[c11 s11'] MStep11] by eauto using prod_prefix_mstep
                  ; apply AtkPT.(non_compromised_low) in H ; inversion H ; [| exfalso ; auto]
                  ; contradiction conv_divg_deq with G P DecP lst0' pc c nt s01 s11 s01' lst11
                  ; eauto using mstep_append, StopE).
            unfold PsRdA, In in IHWTc.
            apply IHWTc with (s00, st00) (s01, st01') (s10, st10') (s00, lst)
            ; try (apply NmifInput_intro ; unfold behavior, In ; simpl)
            ; eauto using LeTrace_intro, prod_mstep_prefix.
            intros pfx0 Pfx0OfT00 TEqPfx.
            pose proof (PsniHypo pfx0 Pfx0OfT00 TEqPfx) as (pfx1 & ? & ?).
            apply ctx_prod_c_deq with DecP pc c nt (fun c' => ProgDown l c') s00 st00 st10 pfx1 ; auto using PDownCtx.
      * (* For variance, prove that nt' is not too high,
           then use either a prior lemma or induction, depending on the value of pc'. *)
        assert (In Label (Union Label P T) nt') by (apply (low_set_union_inst P T).(down_closed) with nt ; auto).
        destruct (DecP.(dec_in) pc') ; [destruct (DecT.(dec_in) pc') |]
        ; eauto using secret_pc_psrd, untrusted_pc_psrd, Intersection_intro.
    Qed.

    Theorem wt_psrd : forall pc c nt, G;; pc |- c -| nt
        -> In Label (Union Label P T) nt
        -> In Property (PsRdA G P T) (behavior c).
      intros pc ? ? ? ?.
      destruct (DecP.(dec_in) pc) ; [destruct (DecT.(dec_in) pc) |]
      ; eauto using secret_pc_psrd, untrusted_pc_psrd, low_pc_psrd, Intersection_intro.
    Qed.

  End PsRdProof.

  Theorem wt_pste : forall G pc c nt, G;; pc |- c -| nt
      -> forall P T `(Attacker P T), In Label (Union Label P T) nt -> In Property (PsTeA G P T) (behavior c).
    intros.
    apply ps_rd_te_dual.
    lazymatch goal with
      | [H : In Label (Union Label _ _) _ |- _] => destruct H
    end ; eauto using wt_psrd, attacker_symmetry, Union.
  Qed.

  Theorem wt_rpl : forall G pc c nt, G;; pc |- c -| nt
      -> forall P T `(Attacker P T), In Label (Union Label P T) nt -> In Property (RplA G P T) (behavior c).
    intros.
    assert (In Property (PsRdA G P T) (behavior c)) as InPsRd by eauto using wt_psrd.
    apply psrd_is_pird_rpl in InPsRd as [] ; assumption.
  Qed.

  Theorem wt_tpc : forall G pc c nt, G;; pc |- c -| nt
      -> forall P T `(Attacker P T), In Label (Union Label P T) nt -> In Property (TpcA G P T) (behavior c).
    intros.
    assert (In Property (PsTeA G P T) (behavior c)) as InPsTe by eauto using wt_pste.
    apply pste_is_pite_tpc in InPsTe as [] ; assumption.
  Qed.

End NMIF.
