Require Import Basic.
Require Import ImpDefs SecurityDefs Trace.
Require Import Tactics.
Require Import BasicTheories ImpTheories TraceTheories SecurityTheories.
Require Import ConvergeDiverge.
Require Import Containment BridgeStep Noninterference Nmif.
Require Import InferenceDefs InferenceTheories.

From Coq Require Import Equality List Ensembles Relations RelationClasses.

Import ListNotations.

(* The core results that assume the most general label model. *)
Module Type CoreResults (B : Basic) (ID : ImpDefs) (TD : TraceDefs B ID) (SD : SecurityDefs B ID TD)
    (Tac : SimpleTactics B ID TD SD) (BT : BasicTheories B) (IT : ImpTheories B ID TD SD Tac BT) (TT : TraceTheories B ID TD SD Tac BT IT)
    (ST : SecurityTheories B ID TD SD Tac BT IT TT) (CD : ConvergeDiverge B ID TD SD Tac BT IT)
    (Con : Containment B ID TD SD Tac BT IT TT ST CD) (BStep : BridgeStep B ID TD SD Tac BT IT TT ST CD Con)
    (NI : Noninterference B ID TD SD Tac BT IT TT ST CD Con BStep)
    (Nmif : NMIF B ID TD SD Tac BT IT TT ST CD Con BStep NI).
  Import ID TD SD IT TT ST CD Con BStep NI Nmif.
  Import ImpNotations.

  Section LanguageBasics.

    (* Used in the claim of adequacy of the PDownT rule in Section 4.2. *)
    Proposition Termination_Bound : forall G pc c nt, G;; pc |- c -| nt -> flows_to pc nt \/ forall l, G;; pc |- c -| l.
      intros G pc c nt WTc.
      pose proof (wt_no_pc_flow_any_nt WTc) as [| ExPf] ; [left ; assumption | right].
      intro l.
      destruct (ExPf l (Empty_set Label)) as [Pf ?].
      auto using wt_proof_impl_prop.
    Qed.

    (* Theorem 3 *)
    Theorem Type_Soundess : forall G pc c nt s, G;; pc |- c -| nt -> dom_subset G s -> never_stuck c s.
      eauto using type_soundness.
    Qed.

  End LanguageBasics.

  Section Hyperproperties.

    Variable G : Varname -> option Label.

    (* Theorem 1 *)
    Theorem Psni_is_Pini_and_Lfp : forall D, DecideIn D -> Same_set Property (PsniD G D) (Intersection Property (PiniD G D) (LfpD G D)).
      eauto using psni_is_pini_lfp.
    Qed.

    (* Theorem 2 *)
    Theorem PsRd_is_PiRd_and_Rpl : forall P T, DecideIn P -> DecideIn T
        -> Same_set Property (PsRdA G P T) (Intersection Property (PiRdA G P T) (RplA G P T)).
      eauto using psrd_is_pird_rpl.
    Qed.

    (* Prove that all our security hyperproperties are subset-closed. *)
    Section SubsetClosed.

      Proposition Pini_Subset_Closed D : forall T0 T1, Included Trace T0 T1 -> In Property (PiniD G D) T1 -> In Property (PiniD G D) T0.
        unfold Included, PiniD, In. intros ; eauto.
      Qed.

      Proposition Lfp_Subset_Closed D : forall T0 T1, Included Trace T0 T1 -> In Property (LfpD G D) T1 -> In Property (LfpD G D) T0.
        unfold Included, LfpD, In. intros ; eauto.
      Qed.

      Proposition PiRd_Subset_Closed P T : forall T0 T1, Included Trace T0 T1 -> In Property (PiRdA G P T) T1 -> In Property (PiRdA G P T) T0.
        unfold Included, PiRdA. intros ? ? ? InPiRd ? ? ? ? [].
        apply InPiRd ; auto using NmifInput_intro.
      Qed.

      Proposition Rpl_Subset_Closed P T : forall T0 T1, Included Trace T0 T1 -> In Property (RplA G P T) T1 -> In Property (RplA G P T) T0.
        unfold Included, RplA. intros ? ? ? InRpl ? ? ? ? [].
        apply InRpl ; auto using NmifInput_intro.
      Qed.

    End SubsetClosed.
  End Hyperproperties.

  Section Security.

    (* Theorem 4 *)
    Theorem Progress_Insensitive_Noninterference :
        forall G pc c nt, G;; pc |- c -| nt -> In Property (Pini G) (behavior c).
      unfold Pini, In. intros. eapply wt_pini_d ; eauto.
    Qed.

    (* Theorem 5 *)
    Theorem NoDowngrade_Psni : forall D `(LowSet D) G pc c nt (WTc : CmdTypeProof G pc c nt),
        In Label D nt
        -> ~ HasDowngrade D WTc
        -> In Property (PsniD G D) (behavior c).
      eauto using nodown_psni.
    Qed.

    (* Theorem 6 *)
    Theorem Low_nt_NmPl : forall P T `(Attacker P T) G pc c nt, G;; pc |- c -| nt
        -> In Label (Union Label P T) nt
        -> In Property (NmPlA G P T) (behavior c).
      unfold NmPlA.
      intros ; constructor ; eauto using wt_rpl, wt_tpc.
    Qed.

    (* Theorem 7 *)
    Theorem Nonmalleable_Progress_Leakage:
        forall G pc c nt, G;; pc |- c -| nt -> flows_to nt (reflect nt) -> In Property (NmPl G) (behavior c).
      unfold NmPl, NmPlA, In. intros.
      apply Intersection_intro
      ; [eapply wt_rpl | eapply wt_tpc] ; try apply non_compromised_low ; eauto.
    Qed.

    (* Corollary 1 *)
    Theorem Progress_Sensitive_Nonmalleable_Information_Flow :
        forall G pc c nt, G;; pc |- c -| nt -> flows_to nt (reflect nt) -> In Property (PsNmif G) (behavior c).
      unfold PsNmif, In. intros.
      apply Intersection_intro ; unfold PsRd, PsTe, In
      ; intros ; [eapply wt_psrd | eapply wt_pste] ; try apply non_compromised_low ; eauto.
    Qed.

    (* Lemma 1 *)
    Lemma Matching_Bridge_Step : forall D `(LowSet D) G pc c nt, G;; pc |- c -| nt
        -> forall s0 s1, deq_store G D s0 s1
        -> never_stuck c s1
        -> forall c' s0' a n, BridgeStep G D (c, s0) (c', s0') a n
        -> (exists s1' n', BridgeStep G D (c, s1) (c', s1') a n' /\ deq_store G D s0' s1')
           \/ (silent G D c s1 /\ ((exists l, a = PDownEvt l) \/ a = StopEvt /\ ~ In Label D nt)).
      intros D ? ? ? ? ? ? WTc ? ? DEqStore NStuck1 ? ? ? ? BStep.
      apply wt_impl_proof in WTc as [Pf ?].
      destruct (matching_bridge_step G D Pf BStep DEqStore NStuck1) as [| [? [| (? & ? & ?)]]] ; eauto.
    Qed.

    (* Lemma 2 *)
    Lemma Containment : forall D `(LowSet D) G pc c nt, G;; pc |- c -| nt
        -> forall s a c' s', (c, s) -->[a] (c', s')
        -> ~ In Label D pc
        -> deq_store G D s s' /\ (a = StopEvt \/ deq_evt G D a NoEvt).
      eauto using store_containment, step_containment.
    Qed.

    (* Lemma 3 *)
    (* This lemma is taken to be an Axiom for most of the proofs from the ConvergeDiverge module.
       The ClassicalResults module (which nothing depends on) contains a classical proof of it. *)
    Lemma While_Trilemma : forall e c s, never_stuck (While e c) s
        -> converge (While e c) s
          \/ (exists n s' m, LoopsN e c s s' n /\ evalExpr e s' = Some (S m) /\ diverge c s')
          \/ (forall n, exists s', LoopsN e c s s' n).
      eauto using never_stuck_while_trilemma.
    Qed.

  End Security.

End CoreResults.

(* Soundness, completeness, and minimality of the inference algorithm.
   This is in a separate module type since it assumes the labels form a lattice. *)
Module Type InferenceResults (ID : ImpDefs) (InfD : InferenceDefs ID) (InfT : InferenceTheories ID InfD).
  Import ID InfD InfT.
  Import ImpNotations.

  (* Theorem 8 *)
  Theorem Sound_Inference : forall G pc c c' nt, infer G pc c = Some (c', nt)
      -> G;; pc |- c' -| nt /\ flows_to nt (reflect nt).
    unfold infer. intros. simplify_infer_hypo G.
    split ; eauto using sound_inference_help, infer_nt_ft_refl, infer_impl_can_infer.
  Qed.

  (* Theorem 9 *)
  Theorem Complete_Inference : forall G pc c nt, flows_to nt (reflect nt) -> G;; pc |- c -| nt
      -> exists c' nt', infer G pc (erase_pdown c) = Some (c', nt').
    intros G pc c nt FT WTc.
    pose proof (complete_inf_help G pc c nt FT WTc) as (? & ? & ? & CanInf).
    apply can_infer_impl_infer in CanInf.
    unfold infer. rewrite -> CanInf. eauto.
  Qed.

  (* Theorem 10 *)
  Theorem Correct_Inference : forall G pc c c' nt, infer G pc c = Some (c', nt) -> c = erase_pdown c'.
    unfold infer. intros. simplify_infer_hypo G.
    eauto using infer_no_modify, infer_impl_can_infer.
  Qed.

  (* Theorem 11 *)
  Theorem Minimal_Inference : forall G pc c0 c1 nt0, infer G pc c0 = Some (c1, nt0)
      -> forall c1' nt1, PDownLe c1' c1
      -> flows_to nt1 (reflect nt1)
      -> G;; pc |- c1' -| nt1
      -> EqCmdStructure c1 c1'.
    intro G ; intros.
    unfold infer in * ; simplify_infer_hypo G.
    eauto using min_inference, infer_impl_can_infer.
  Qed.

  (* Lemma 4 *)
  Lemma Inference_Bound_Validity : forall G pc c c' b nt, infer_pdown_locs G pc c = Some (c', b, nt)
      -> forall l, flows_to l (reflect l)
      -> flows_to l b <-> exists c'' b' nt', infer_pdown_locs G (join pc l) c = Some (c'', b', nt').
    intros ? ? ? ? ? ? CanInf ? LNonComp. split.
    * intro FlowsToB.
      pose proof (infer_increase_pc (infer_impl_can_infer CanInf) LNonComp FlowsToB) as (? & ? & ? & ? & ?).
      eauto using can_infer_impl_infer.
    * intros (? & ? & ? & ?).
      eauto using infer_increase_pc_flow, infer_impl_can_infer.
  Qed.

  (* Lemma 5 *)
  Lemma Inferred_Nt_Minimality : forall G pc c c0 nt, infer G pc c = Some (c0, nt)
      -> forall c1 nt', G;; pc |- c1 -| nt'
      -> EqCmdStructure c0 c1
      -> flows_to nt nt'.
    unfold infer. intro G ; intros. simplify_infer_hypo G.
    eauto using min_nt_inference, infer_impl_can_infer.
  Qed.

End InferenceResults.
