Require Import Basic.
Require Export ImpDefs Trace SecurityDefs.
Require Import Tactics.
Require Import BasicTheories ImpTheories.

From Coq Require Import Equality List Compare.

Import ListNotations.

Module Type ConvergeDiverge (B : Basic) (ID : ImpDefs) (TD : TraceDefs B ID) (SD : SecurityDefs B ID TD) (Tac : SimpleTactics B ID TD SD)
    (BT : BasicTheories B) (IT : ImpTheories B ID TD SD Tac BT).
  Import ID Tac IT.
  Import ImpNotations.

  Axiom never_stuck_while_trilemma : forall {e c s}, never_stuck (While e c) s
      -> converge (While e c) s
         \/ (exists n s' m, LoopsN e c s s' n /\ evalExpr e s' = Some (S m) /\ diverge c s')
         \/ (forall n, exists s', LoopsN e c s s' n).

  Lemma divg_seq : forall c1 c2 s, diverge c1 s -> diverge (Seq c1 c2) s.
    unfold diverge ; intros ? ? ? DivgC1 ? ? MStep.
    dependent induction MStep.
    * assert (exists cs a, (c1, s) -->[a] cs) as ([c1' s'] & ? & ?) by eauto using MultiStep_refl.
      destruct (cmd_stop_dec c1')
      ; [subst ; assert (exists cs a, (Stop, s') -->[a] cs) as (? & ? & ?) by eauto using MultiStep ; handle_simple_contradict
        | eauto using SeqCE].
    * destruct cs1 as [c' s'].
      inversion H as [| ? c1' | | | | | | |] ; subst.
      - apply IHMStep with s' c2 c1' ; eauto using MultiStep.
      - assert (exists cs a, (Stop, s') -->[a] cs) as (? & ? & ?) by eauto using MultiStep, StopE.
        handle_simple_contradict.
  Qed.

  Lemma divg_pdown : forall l c s, diverge c s -> diverge (ProgDown l c) s.
    unfold diverge ; intros ? ? ? DivgC1 ? ? MStep.
    dependent induction MStep.
    * assert (exists cs a, (c, s) -->[a] cs) as ([c' s'] & ? & ?) by eauto using MultiStep_refl.
      destruct (cmd_stop_dec c')
      ; [subst ; assert (exists cs a, (Stop, s') -->[a] cs) as (? & ? & ?) by eauto using MultiStep ; handle_simple_contradict
        | eauto using PDownCE].
    * destruct cs1 as [? s'].
      inversion H as [| ? c' | | | | | | |] ; subst.
      - apply IHMStep with s' c' l ; eauto using MultiStep.
      - assert (exists cs a, (Stop, s') -->[a] cs) as (? & ? & ?) by eauto using MultiStep, StopE.
        handle_simple_contradict.
  Qed.

  Lemma never_stuck_under_seq_c1 : forall c1 c2 s, never_stuck (Seq c1 c2) s -> never_stuck c1 s.
    unfold never_stuck. intros c1 c2 s NStuck c' s' lst MStep.
    dependent induction MStep.
    * specialize (NStuck (Seq c' c2) s' [] (MultiStep_refl (Seq c' c2, s'))).
      destruct NStuck as [| (? & ? & SeqStep)] ; [discriminate |].
      inversion SeqStep ; subst ; eauto using StopE.
    * destruct cs1 as [c1' s1].
      destruct (cmd_stop_dec c1').
      - subst. inversion MStep ; subst ; [auto | handle_simple_contradict].
      - apply IHMStep with c1' s1 ; auto.
        intros. eauto using MultiStep_some, SeqCE.
  Qed.

  Lemma never_stuck_under_seq_c2 : forall c1 c2 s lst s', never_stuck (Seq c1 c2) s
      -> (c1, s) ==>*[lst] (Stop, s')
      -> never_stuck c2 s'.
    intros c1 c2 s lst s' NStuck MStep.
    assert (exists lst', (c1, s) ==>*[lst'] (Skip, s')) as [lst' ?] by eauto using nstuck_stop_mstep_seq.
    unfold never_stuck in *. intros.
    apply NStuck with (lst' ++ NoEvt :: lst0).
    apply step_concat with (Seq Skip c2, s') ; [apply step_under_seq ; [assumption | discriminate] |].
    apply MultiStep_some with (c2, s') ; auto using SeqSkipE.
  Qed.

  Lemma never_stuck_under_pdown : forall c l s, never_stuck (ProgDown l c) s -> never_stuck c s.
    unfold never_stuck. intros c ? s NStuck c' s' lst MStep.
    dependent induction MStep.
    * destruct (NStuck (ProgDown l c') s' [] (MultiStep_refl (ProgDown l c', s'))) as [| (? & ? & PDownStep)] ; [discriminate |].
      inversion PDownStep ; subst ; eauto using StopE.
    * destruct cs1 as [c1 s1].
      destruct (cmd_stop_dec c1).
      - subst. inversion MStep ; subst ; [auto | handle_simple_contradict].
      - apply IHMStep with c1 s1 ; auto.
        intros. eauto using MultiStep_some, PDownCE.
  Qed.

  Lemma loops_to_divg_divg : forall e c s s' n m, LoopsN e c s s' n -> evalExpr e s' = Some (S m) -> diverge c s' -> diverge (While e c) s.
    unfold diverge. intros e c s s' ? ? Loops EvalE DivgC [c1 s1] lst1 MStep.
    assert (exists lst, (While e c, s) ==>*[lst] (While e c, s')) as [lst0 MStepWhile] by eauto using loops_step.
    destruct (mstep_prefix (While e c, s) (c1, s1) lst1 MStep (While e c, s') lst0 MStepWhile) as [[lst1' MStep'] | [lst0' MStep']]
    ; inversion MStep' as [| ? ? ? ? ? WhileStep MStepCs1] ; subst ; eauto using WhileE.
    inversion WhileStep ; subst ; inversion MStepCs1 as [| ? ? ? ? lst' IfStep MStepSeq] ; subst ; eauto using IfNE.
    inversion IfStep ; subst ; [| handle_simple_contradict].
    destruct (seq_mstep_inv MStepSeq) as [(c' & ? & MStepC) | (? & ? & ? & ? & ?)] ; subst
    ; [pose proof (DivgC (c', s1) lst' MStepC) as ([c'' s''] & a & ?)
        ; destruct (cmd_stop_dec c'') ; eauto using SeqCE ; subst |]
    ; contradiction converge_impl_not_diverge with c s'
    ; unfold converge ; eauto using mstep_append, StopE.
  Qed.

  Lemma mstep_prefix_len : forall cs cs0 lst0, cs ==>*[lst0] cs0
      -> forall cs1 lst1, cs ==>*[lst1] cs1
      -> length lst0 <= length lst1
      -> exists lst0', cs0 ==>*[lst0'] cs1.
    intros cs cs0 lst0 MStep0. dependent induction MStep0 ; intros cs1' lst1 MStep1 LenLeq ; eauto.
    dependent destruction MStep1 ; simpl in LenLeq ; [inversion LenLeq |].
    subst_eq_steps. eauto using le_S_n.
  Qed.

  Lemma infinite_loops_divg : forall e c s, (forall n, exists s', LoopsN e c s s' n) -> diverge (While e c) s.
    unfold diverge. intros e c s LoopsAllN [c' s'] lst MStep.
    pose proof (LoopsAllN (length lst)) as [s'' Loops].
    apply loopsn_loopsnlst in Loops as [lst' Loops].
    assert (exists lst, (c', s') ==>*[lst] (While e c, s'')) as [? MStep']
      by (apply mstep_prefix_len with (While e c, s) lst lst' ; eauto using loops_lst_len, loops_lst_step).
    inversion MStep' ; subst ; eauto using WhileE.
  Qed.

  Proposition never_stuck_conv_or_divg : forall c s, never_stuck c s -> converge c s \/ diverge c s.
    induction c ; intros s NStuck.
    * left. unfold converge. eauto using MultiStep, StopE.
    * left. unfold converge.
      assert (Assign x e = Stop \/ exists cs a, (Assign x e, s) -->[a] cs) as [| (? & ? & AssignStep)] by eauto using MultiStep_refl
      ; [discriminate |].
      inversion AssignStep ; subst.
      eauto using MultiStep, AssignE, StopE.
    * unfold never_stuck in *.
      assert (If e c1 c2 = Stop \/ exists cs a, (If e c1 c2, s) -->[a] cs) as [| ([c' s'] & ? & IfStep)] by eauto using MultiStep_refl
      ; [discriminate |].
      dependent destruction IfStep
      ; (assert (converge c' s' \/ diverge c' s') as [|]
          by (try apply IHc1 ; try apply IHc2 ; eauto using MultiStep, IfNE, If0E)
        ; [left | right])
      ; lazymatch goal with
        | [H : converge _ ?s |- converge (If _ _ _) ?s] => unfold converge in * ; destruct H as (lst & ? & ?)
        | [H : diverge _ ?s |- diverge (If _ _ _) ?s] => eapply step_diverge
      end
      ; eauto using MultiStep_some, If0E, IfNE.
    * assert (converge c1 s \/ diverge c1 s) as [(? & s1 & ?) |] by eauto using never_stuck_under_seq_c1
      ; [| right ; apply divg_seq ; assumption].
      assert (exists lst1, (c1, s) ==>*[lst1] (Skip, s1)) as [lst1 ?] by eauto using nstuck_stop_mstep_seq.
      assert (converge c2 s1 \/ diverge c2 s1) as [(lst2 & s2 & ?) | DivgC2] by eauto using never_stuck_under_seq_c2.
      - left. unfold converge in *.
        exists (lst1 ++ NoEvt :: lst2). exists s2.
        apply step_concat with (Seq Skip c2, s1) ; [apply step_under_seq ; [assumption | discriminate] |].
        eauto using MultiStep_some, SeqSkipE.
      - right. unfold diverge in *.
        intros [c' s'] lst' MStep.
        destruct (seq_mstep_inv MStep) as [(c1' & ? & MStep') | (lst1' & lst2 & s1' & ? & ?)]
        ; subst
        ; [apply NStuck in MStep as [| (? & ? & ?)]
           | assert (s1 = s1') by eauto using deterministic_conv_state, mstep_append, StopE ; subst]
        ; eauto ; discriminate.
    * destruct (never_stuck_while_trilemma NStuck) as [| [(? & ? & ? & ? & ? & ?) |]]
      ; eauto using loops_to_divg_divg, infinite_loops_divg.
    * assert (converge c s \/ diverge c s) as [(? & s' & ?) |] by eauto using never_stuck_under_pdown
      ; [left | right ; apply divg_pdown ; assumption].
      unfold converge in *.
      assert (exists lst, (c, s) ==>*[lst] (Skip, s')) as [lst' ?] by eauto using nstuck_stop_mstep_pdown.
      exists (lst' ++ [(PDownEvt l) ; StopEvt]). exists s'.
      apply step_concat with (ProgDown l Skip, s')
      ; [apply step_under_pdown |]
      ; eauto using step_under_pdown, MultiStep, PDownSkipE, StopE.
      discriminate.
    * unfold converge. eauto using MultiStep_refl.
  Qed.

  Lemma divg_while_options : forall {e c s}, diverge (While e c) s
      -> forall n, (exists s', LoopsN e c s s' n) \/ (exists n' s' m, LoopsN e c s s' n' /\ evalExpr e s' = Some (S m) /\ diverge c s' /\ n' < n).
    intros ? c ? Divg. induction n ; eauto using LoopsN_none.
    destruct IHn as [[s' Loops] | (n' & s' & m & ? & ? & ? & ?)] ; [| right ; unfold lt in * ; eauto 8].
    assert (converge c s' \/ diverge c s') as [|] by eauto using never_stuck_conv_or_divg, while_divg_never_stuck
    ; [eauto using one_loop_two_loop | right].
    assert (exists lst, (While e c, s) ==>*[lst] (While e c, s')) as [lst ?] by eauto using loops_step.
    assert ((While e c, s') ==>*[[NoEvt ; NoEvt]] (Seq c (While e c), s')) as MStep
      by (apply while_divg_step_to_seq ; unfold diverge in * ; intros ; eauto using step_concat).
    inversion MStep as [| ? ? ? ? ? WhileStep MStep'] ; inversion WhileStep ; subst.
    inversion MStep' as [| ? ? ? ? ? IfStep MStep''] ; subst ; inversion MStep'' ; subst.
    inversion IfStep ; subst.
    eauto 8.
  Qed.

  Lemma nstuck_while_options : forall {e c s}, never_stuck (While e c) s
      -> forall n, (exists s', LoopsN e c s s' n)
                   \/ (exists n' s', n' < n /\ LoopsN e c s s' n' /\ (evalExpr e s' = Some 0 \/ diverge c s')).
    intros e c s NStuck n.
    destruct (never_stuck_while_trilemma NStuck) as [Conv | [(n' & ? & ? & ? & ? & ?) |]] ; eauto
    ; [apply conv_while_fin_loops in Conv as (n' & s' & ? & ?) |]
    ; (destruct (le_dec n n') as [| LtN'N] ; [left ; eauto using loops_lt |])
    ; (destruct (le_decide n' n LtN'N) ; [right ; do 2 eexists | subst])
    ; eauto.
  Qed.

End ConvergeDiverge.
