Require Import Basic.
Require Import ImpDefs SecurityDefs Trace.
Require Import Tactics.
Require Import BasicTheories ImpTheories TraceTheories SecurityTheories ConvergeDiverge.

From Coq Require Import Basics Equality List Ensembles.

Import ListNotations.

Module Type Containment (B : Basic) (ID : ImpDefs) (TD : TraceDefs B ID) (SD : SecurityDefs B ID TD)
    (Tac : SimpleTactics B ID TD SD) (BT : BasicTheories B) (IT : ImpTheories B ID TD SD Tac BT)
    (TT : TraceTheories B ID TD SD Tac BT IT) (ST : SecurityTheories B ID TD SD Tac BT IT TT)
    (CD : ConvergeDiverge B ID TD SD Tac BT IT).
  Import ID Tac IT SD ST CD.
  Import ImpNotations.

  Lemma stop_evt_not_nil : forall G D lst0 lst1, ~ deq_evt_lst G D (lst0 ++ StopEvt :: lst1) [].
    intro D. induction lst0 ; intros lst1 DEqLst ; simpl in * ; inversion DEqLst as [| | ? ? ? DEqEvt | ? ? ? ? DEqSubLst].
    * inversion DEqEvt.
    * contradiction IHlst0 with lst1.
  Qed.

  Proposition wt_silent_impl_diverge : forall D G pc c nt s, G;; pc |- c -| nt
      -> never_stuck c s
      -> silent G D c s
      -> diverge c s.
    unfold never_stuck, silent, diverge.
    intros D G pc c nt s WTc NStuck Silent [c' s'] lst MStep.
    destruct (NStuck c' s' lst MStep) ; [exfalso ; subst | assumption].
    pose proof (Silent (Stop, s') lst MStep) as DEqLstNil.
    assert (exists lst' a, lst = lst' ++ [a]) as (lst' & a & ?)
      by (dependent destruction MStep using mstep_rev_ind ; [handle_simple_contradict | eauto]) ; subst.
    assert (a = StopEvt) by eauto using wt_mstep_to_stop ; subst.
    apply deq_lst_app_eq_nil in DEqLstNil as [? BadDeq].
    inversion BadDeq ; subst ; handle_simple_contradict.
  Qed.

  Section ContainSec.

    Context (G : Varname -> option Label) (D : Ensemble Label) `{LowSet D}.

    Theorem deq_expr_eval : forall s0 s1, deq_store G D s0 s1
      -> forall e l, ExprType G e l -> In Label D l -> evalExpr e s0 = evalExpr e s1.
      intros s0 s1 DEqStores e l ExprT. dependent induction ExprT ; intros LowL ; simpl
      ; repeat lazymatch goal with
        | [Fl: flows_to ?l ?l', LowL: In Label D ?l' |- _] => assert (In Label D l) by eauto using down_closed ; clear LowL
        | [IH : In Label D ?l -> _ = _, LowL: In Label D ?l |- _] => specialize (IH LowL) ; rewrite -> IH in * ; clear IH
      end ; eauto.
    Qed.

    Lemma step_containment : forall c s c' s' a, (c, s) -->[a] (c', s')
        -> forall pc nt, G;; pc |- c -| nt
        -> ~ In Label D pc
        -> a = StopEvt \/ deq_evt G D a NoEvt.
      intros c s c' s' a Step.
      dependent induction Step ; intros pc nt WTc Highpc ; auto with deq.
      * eapply IHStep with _ c0 s c0' s' pc nt ; auto. apply seq_type_c1_type with c1 ; auto.
      * right. dependent induction WTc ; eauto using DEqHighAssignNoEvt, high_set_up_closed.
      * enough (exists l, G;; pc |- c0 -| l) as [] by eauto.
        generalize WTc ; clear ; intro WTc.
        dependent induction WTc ; [| destruct (IHWTc c0 l eq_refl)] ; eauto using VarianceT.
      * right. apply DEqHighPDownNoEvt. dependent induction WTc ; eauto using high_set_up_closed.
    Qed.

    Lemma store_containment : forall c s c' s' a, (c, s) -->[a] (c', s')
        -> forall pc nt, G;; pc |- c -| nt
        -> ~ In Label D pc
        -> deq_store G D s s'.
      intros ? ? c' ? a Step ; intros.
      assert (a = StopEvt \/ deq_evt G D a NoEvt) as [|] by eauto using step_containment
      ; [subst | eauto using step_noevt_store_eq].
      assert (c' = Stop) by eauto using step_stop_evt_impl_stop ; subst.
      inversion Step ; subst ; auto with deq.
    Qed.

    Proposition mstep_contain_evt_lst : forall pc c nt s, G;; pc |- c -| nt -> ~ In Label D pc
        -> forall c' s' lst, (c, s) ==>*[lst] (c', s') -> deq_evt_lst G D lst [] \/ (c' = Stop /\ deq_evt_lst G D lst [StopEvt]).
      intros pc c nt s WellTyped Highpc c' s' lst MStep. dependent induction MStep.
      * auto with deq.
      * destruct cs1 as [c1 s1].
        assert (c1 = Stop \/ G;; pc |- c1 -| nt) as c1StopOrWt by (apply type_preservation with c s a s1 ; auto).
        destruct c1StopOrWt as [| c1Wt].
        - subst. inversion MStep ; subst ; try handle_simple_contradict.
          assert (a = StopEvt) as aStop by (apply wt_step_to_stop_impl_stop_evt with G pc c nt s s' ; auto).
          subst ; auto with deq.
        - assert (a = StopEvt \/ deq_evt G D a NoEvt) as [| DEqaNone] by (apply step_containment with c s c1 s1 pc nt ; auto).
          + subst.
            assert (c1 = Stop) as c1Stop by (apply step_stop_evt_impl_stop with (c, s) s1 ; auto).
            handle_simple_contradict.
          + assert (deq_evt_lst G D lst [] \/ (c' = Stop /\ deq_evt_lst G D lst [StopEvt])) as [| [? ?]]
              by (eapply IHMStep with ?[H] c1 s1 s' ; auto)
            ; auto using deq_evt_lst.
    Qed.

    Proposition mstep_contain_store : forall pc c nt s, G;; pc |- c -| nt -> ~ In Label D pc
        -> forall c' s' lst, (c, s) ==>*[lst] (c', s') -> deq_store G D s s'.
      intros pc c nt s WellTyped Highpc c' s' lst MStep. dependent induction MStep.
      * apply deq_store_refl.
      * destruct cs1 as [c1 s1]. transitivity s1.
        - apply store_containment with c c1 a pc nt ; auto.
        - assert (c1 = Stop \/ G;; pc |- c1 -| nt) as c1StopOrWt by (apply type_preservation with c s a s1 ; auto).
          destruct c1StopOrWt as [| c1Wt].
          + inversion MStep ; subst ; auto with deq. handle_simple_contradict.
          + eapply IHMStep with ?[H] c1 c' ; eauto.
    Qed.

    Theorem mstep_containment : forall pc c nt s,
        G;; pc |- c -| nt
        -> never_stuck c s
        -> ~ In Label D pc
        -> silent G D c s \/ exists lst s', (c, s) ==>*[lst ++ [StopEvt]] (Stop, s') /\ (s, lst) =[G, D] (s', []).
      intros pc c nt s WTc WFs HighPc.
      destruct (never_stuck_conv_or_divg c s WFs) as [(lst & s' & MStep) | cDivg] ; [right | left].
      * apply mstep_iff_msteptl in MStep.
        inversion MStep as [| ? cs1 ? a lst0 MStep1 Step] ; [ handle_simple_contradict | ] ; subst.
        apply mstep_iff_msteptl in MStep.
        assert (a = StopEvt) by (apply wt_mstep_to_stop with G pc c nt s s' lst0 ; auto) ; subst.
        exists lst0. exists s'. split ; auto.
        apply DEqPfx_intro.
        - apply mstep_contain_store with pc c nt Stop (lst0 ++ [StopEvt]) ; auto.
        - apply mstep_iff_msteptl in MStep1. destruct cs1 as [c1 s1].
          assert (deq_evt_lst G D lst0 [] \/ (c1 = Stop /\ deq_evt_lst G D lst0 [StopEvt])) as EvtLstContain
            by (apply mstep_contain_evt_lst with pc c nt s s1 ; auto).
          destruct EvtLstContain as [| BadStop] ; [assumption | destruct BadStop ; subst ; inversion Step].
      * unfold silent. intros cs' lst MStep. destruct cs' as [c' s'].
        assert (deq_evt_lst G D lst [] \/ (c' = Stop /\ deq_evt_lst G D lst [StopEvt])) as EvtLstContain
          by (apply mstep_contain_evt_lst with pc c nt s s' ; auto).
        destruct EvtLstContain as [DEqEvtLstNil | BadStop] ; [assumption |].
        destruct BadStop as [c'Stop ?].
        rewrite -> c'Stop in MStep. apply cDivg in MStep.
        repeat destruct MStep as [? MStep]. inversion MStep.
    Qed.

  End ContainSec.

  Ltac resolve_if_case c constr :=
    lazymatch goal with
      | [ IH : forall s, never_stuck _ s -> exists lst s', (c, s) ==>*[lst] (Stop, s')  |- _ ] =>
          assert (converge c s) as (lst & s' & HConv) by (apply IH ; eauto using never_stuck_step)
          ; exists (NoEvt :: lst) ; exists s' ; apply MultiStep_some with (c, s) ; eauto using constr
    end.

  Theorem termination_bound : forall G pc c nt, G;; pc |- c -| nt
      -> flows_to pc nt \/ forall s, never_stuck c s -> converge c s.
    unfold converge. intros G pc c nt WTc.
    induction WTc as [| x e l ? Gx eType | pc e c1 c2 nt eType | | | |] ; auto.
    * right. eauto using StopE, MultiStep.
    * right ; intros s NStuck.
      destruct (NStuck (Assign x e) s [] (MultiStep_refl (Assign x e, s))) as [| (? & ? & Step)] ; [discriminate | inversion Step ; subst].
      do 2 eexists. eapply MultiStep_some ; [apply AssignE |] ; eauto using MultiStep, StopE.
    * destruct IHWTc1 ; destruct IHWTc2 ; auto ; right ; intros s NStuck.
      destruct (NStuck (If e c1 c2) s [] (MultiStep_refl (If e c1 c2, s))) as [| (? & ? & Step)] ; [discriminate | inversion Step ; subst]
      ; [resolve_if_case c1 IfNE | resolve_if_case c2 If0E].
    * destruct IHWTc1 as [| IHWTc1] ; destruct IHWTc2 as [| IHWTc2] ; eauto using flows_to_trans ; right ; intros s NStuck.
      assert (converge c1 s) as ConvC1 by (apply IHWTc1 ; try eapply never_stuck_seq_c1 ; eauto).
      apply conv_step_to_skip with G pc c1 nt s in ConvC1 ; [| eauto using VarianceT with deq]
      ; destruct ConvC1 as (lst1 & s1 & ?).
      assert (converge c2 s1) as (lst2 & s2 & ConvC2)
        by (apply IHWTc2 ; intros ? ? ? ? ; eauto using step_under_seq_skip, MultiStep_some, SeqSkipE, step_concat).
      exists (lst1 ++ NoEvt :: lst2). exists s2.
      apply step_concat with ((Seq Skip c2), s1).
      - apply step_under_seq ; auto. discriminate.
      - apply MultiStep_some with (c2, s1) ; auto using SeqSkipE.
    * destruct IHWTc ; eauto using flows_to_trans.
  Qed.

  Corollary diverge_pc_ft_nt : forall G pc c nt, G;; pc |- c -| nt
      -> forall s, diverge c s -> flows_to pc nt.
    intros G pc c nt WTc s Divg.
    assert (flows_to pc nt \/ forall s', never_stuck c s' -> converge c s') as FTorConv by (eapply termination_bound ; eauto).
    destruct FTorConv as [| Conv] ; [assumption |].
    contradiction converge_impl_not_diverge with c s ; eauto using diverge_impl_never_stuck.
  Qed.

End Containment.
