Require Import Basic.
Require Import ImpDefs Trace SecurityDefs.
Require Import Tactics.
Require Import BasicTheories ImpTheories.

From Coq Require Import Equality List Classical.

Import ListNotations.

Module Type NonTermination (B : Basic) (ID : ImpDefs) (TD : TraceDefs B ID) (SD : SecurityDefs B ID TD) (Tac : SimpleTactics B ID TD SD)
    (BT : BasicTheories B) (IT : ImpTheories B ID TD SD Tac BT).
  Import ID IT.
  Import ImpNotations.

  Implicit Types (n : nat) (e : Expr) (c : Cmd) (s : Store).

  Proposition never_stuck_conv_or_divg : forall c s, never_stuck c s -> converge c s \/ diverge c s.
    intros. classical_right. apply nstuck_not_converge_impl_diverge ; assumption.
  Qed.

  Lemma divg_while_options : forall e c s, diverge (While e c) s
      -> forall n, (exists s', LoopsN e c s s' n) \/ (exists n' s' m, LoopsN e c s s' n' /\ evalExpr e s' = Some (S m) /\ diverge c s').
    intros ? c ? Divg. induction n ; eauto using LoopsN_none.
    destruct IHn as [[s' Loops] |] ; auto.
    assert (converge c s' \/ diverge c s') as [|] by eauto using never_stuck_conv_or_divg, while_divg_never_stuck
    ; [left ; eauto using one_loop_two_loop | right].
    assert (exists lst, (While e c, s) ==>*[lst] (While e c, s')) as [lst ?] by eauto using loops_step.
    assert ((While e c, s') ==>*[[NoEvt ; NoEvt]] (Seq c (While e c), s')) as MStep
      by (apply while_divg_step_to_seq ; unfold diverge in * ; intros ; eauto using step_concat).
    inversion MStep as [| ? ? ? ? ? WhileStep MStep'] ; inversion WhileStep ; subst.
    inversion MStep' as [| ? ? ? ? ? IfStep MStep''] ; subst ; inversion MStep'' ; subst.
    inversion IfStep ; subst.
    eauto 6.
  Qed.

  Proposition while_trilemma : forall e c s, never_stuck (While e c) s
    -> converge (While e c) s
        \/ (exists n s' m, LoopsN e c s s' n /\ evalExpr e s' = Some (S m) /\ diverge c s')
        \/ (forall n, exists s', LoopsN e c s s' n).
    intros e c s NStuck.
    assert (converge (While e c) s \/ diverge (While e c) s) as [| Divg] by eauto using never_stuck_conv_or_divg
    ; [left ; assumption | right].
    classical_right.
    intro n.
    pose proof (divg_while_options e c s Divg n) as [|] ; [| exfalso] ; auto.
  Qed.

End NonTermination.
